/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.dumper.merge;

import com.oceanbase.tools.loaddump.dumper.merge.AbstractBlockSizeFileMerger;
import com.oceanbase.tools.loaddump.dumper.writer.AbstractRollingFileWriterV2;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.orc.OrcFile;
import org.apache.orc.Reader;
import org.apache.orc.RecordReader;
import org.apache.orc.TypeDescription;
import org.apache.orc.Writer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrcFileMerger
extends AbstractBlockSizeFileMerger<VectorizedRowBatch> {
    private static final Logger log = LoggerFactory.getLogger(OrcFileMerger.class);
    private final Map<String, Writer> path2Writer = new HashMap<String, Writer>();

    public OrcFileMerger(Long blockSizeBytes, Long blockRow) {
        super(blockSizeBytes, blockRow);
    }

    @Override
    protected void doWrite(String fromPath, String toPath, AbstractBlockSizeFileMerger.DataBlock<VectorizedRowBatch> dataBlock) throws IOException {
        Writer writer = this.path2Writer.get(toPath);
        if (writer == null) {
            throw new IllegalStateException("Failed to find writer by path, " + toPath);
        }
        writer.addRowBatch(dataBlock.getData());
    }

    @Override
    protected void doOnRollOver(String fromPath, String toPath) throws Exception {
        TypeDescription schema;
        try (Reader reader = OrcFile.createReader((Path)new Path(fromPath), (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)new Configuration()));){
            schema = reader.getSchema();
        }
        OrcFile.WriterOptions option = OrcFile.writerOptions((Configuration)new Configuration()).setSchema(schema).overwrite(true);
        this.path2Writer.put(toPath, OrcFile.createWriter((Path)new Path(toPath), (OrcFile.WriterOptions)option));
    }

    @Override
    protected void forEachDataBlock(String fromPath, AbstractRollingFileWriterV2.FileMetaInfo fileMeta, Consumer<AbstractBlockSizeFileMerger.DataBlock<VectorizedRowBatch>> consumer) {
        try (Reader reader = OrcFile.createReader((Path)new Path(fromPath), (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)new Configuration()));){
            VectorizedRowBatch batch = reader.getSchema().createRowBatch();
            RecordReader rows = reader.rows();
            float lastProgress = 0.0f;
            boolean hasData = false;
            while (rows.nextBatch(batch)) {
                hasData = true;
                if (batch == null) continue;
                double ratio = rows.getProgress() - lastProgress;
                lastProgress = rows.getProgress();
                consumer.accept(new AbstractBlockSizeFileMerger.DataBlock<VectorizedRowBatch>(batch, (long)((double)fileMeta.getRows() * ratio), (long)((double)fileMeta.getSizeBytes() * ratio)));
            }
            if (!hasData) {
                consumer.accept(new AbstractBlockSizeFileMerger.DataBlock<VectorizedRowBatch>(reader.getSchema().createRowBatch(), 0L, 0L));
            }
            rows.close();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void close() throws Exception {
        this.path2Writer.values().forEach(writer -> {
            try {
                writer.close();
            }
            catch (Exception e) {
                log.warn("Failed to close writer", (Throwable)e);
            }
        });
    }
}

