/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.dumper.merge;

import com.oceanbase.tools.loaddump.dumper.merge.AbstractBlockSizeFileMerger;
import com.oceanbase.tools.loaddump.dumper.writer.AbstractRollingFileWriterV2;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.ParquetFileWriter;
import org.apache.parquet.hadoop.util.HadoopInputFile;
import org.apache.parquet.hadoop.util.HadoopOutputFile;
import org.apache.parquet.io.InputFile;
import org.apache.parquet.io.OutputFile;
import org.apache.parquet.schema.MessageType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParquetFileMerger
extends AbstractBlockSizeFileMerger<Void> {
    private static final Logger log = LoggerFactory.getLogger(ParquetFileMerger.class);
    private final Map<String, ParquetFileWriter> path2Writer = new HashMap<String, ParquetFileWriter>();
    private final Configuration conf = new Configuration();

    public ParquetFileMerger(Long blockSizeBytes, Long blockRow) {
        super(blockSizeBytes, blockRow);
        this.conf.set("fs.file.impl", RawLocalFileSystem.class.getName());
        this.conf.set("fs.file.impl.disable.cache", "true");
    }

    @Override
    protected void doWrite(String fromPath, String toPath, AbstractBlockSizeFileMerger.DataBlock<Void> dataBlock) throws IOException {
        ParquetFileWriter writer = this.path2Writer.get(toPath);
        if (writer == null) {
            throw new IllegalStateException("Failed to find writer by path, " + toPath);
        }
        writer.appendFile(this.conf, new Path(fromPath));
    }

    @Override
    protected void doOnRollOver(String fromPath, String toPath) throws Exception {
        MessageType schema;
        try (ParquetFileReader reader = ParquetFileReader.open((InputFile)HadoopInputFile.fromPath((Path)new Path(fromPath), (Configuration)this.conf));){
            schema = reader.getFooter().getFileMetaData().getSchema();
        }
        ParquetFileWriter writer = new ParquetFileWriter((OutputFile)HadoopOutputFile.fromPath((Path)new Path(toPath), (Configuration)this.conf), schema, ParquetFileWriter.Mode.OVERWRITE, 0x800000L, 0, 64, Integer.MAX_VALUE, true);
        writer.start();
        this.path2Writer.put(toPath, writer);
    }

    @Override
    protected void forEachDataBlock(String fromPath, AbstractRollingFileWriterV2.FileMetaInfo fileMetaInfo, Consumer<AbstractBlockSizeFileMerger.DataBlock<Void>> consumer) {
        consumer.accept(new AbstractBlockSizeFileMerger.DataBlock<Object>(null, fileMetaInfo.getRows(), fileMetaInfo.getSizeBytes()));
    }

    @Override
    public void close() throws Exception {
        this.path2Writer.values().forEach(writer -> {
            try {
                writer.end(new HashMap());
            }
            catch (Exception e) {
                log.warn("Failed to close writer", (Throwable)e);
            }
        });
    }
}

