/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.dumper.task;

import com.oceanbase.tools.loaddump.common.SessionManager;
import com.oceanbase.tools.loaddump.common.enums.ServerMode;
import com.oceanbase.tools.loaddump.common.model.ConnectionKey;
import com.oceanbase.tools.loaddump.common.model.DumpParameter;
import com.oceanbase.tools.loaddump.common.model.TaskDetail;
import com.oceanbase.tools.loaddump.common.model.TaskState;
import com.oceanbase.tools.loaddump.loader.reader.AbstractDatabaseReader;
import com.oceanbase.tools.loaddump.utils.StringUtils;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDumpTask
extends AbstractDatabaseReader
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(AbstractDumpTask.class);
    private static final long serialVersionUID = 5921786708138983445L;
    protected volatile TaskState taskState = TaskState.INITIAL;
    protected transient String message;
    protected long recordCount;
    protected String schemaName;
    protected String objectType;
    protected String objectName;
    protected String partitionName;
    protected String dataPath;
    protected String fileEncoding;
    protected String checkpointPath;
    protected ServerMode serverMode;
    protected TaskDetail taskDetail;
    protected AtomicBoolean supervisor;
    protected transient ConnectionKey connectionKey;
    protected transient SessionManager sessionManager;
    protected boolean noNestedDir;

    public void initialize(DumpParameter parameter) throws Exception {
        this.dataPath = parameter.getDataPath();
        this.schemaName = parameter.getDatabaseName();
        this.fileEncoding = parameter.getFileEncoding();
        this.serverMode = parameter.getDatabase().getServerMode();
        this.connectionKey = parameter.getConnectionKey();
        this.sessionManager = parameter.getConnectionKey().getSessionManager();
        this.noNestedDir = parameter.isNoNestedDir();
    }

    public String getTablePartition() {
        StringBuilder sb = new StringBuilder(64);
        if (StringUtils.isNotBlank(this.schemaName)) {
            sb.append(this.schemaName).append(".");
        }
        if (StringUtils.isNotBlank(this.objectName)) {
            sb.append(this.objectName);
        }
        if (StringUtils.isNotBlank(this.partitionName)) {
            sb.append(".").append(this.partitionName);
        }
        return sb.toString();
    }

    protected abstract void updateTaskDetail();

    protected void updateTaskState(TaskState taskState) {
        if (this.taskState != TaskState.FAILURE) {
            this.taskState = taskState;
        }
    }

    public boolean isFinished() {
        return this.taskState.getCode() > TaskState.RUNNING.getCode();
    }

    public boolean isSuccess() {
        return this.taskState.getCode() == TaskState.SUCCESS.getCode();
    }

    public boolean isFailure() {
        return this.taskState.getCode() == TaskState.FAILURE.getCode();
    }

    public TaskState getTaskState() {
        return this.taskState;
    }

    public void setObjectType(String objectType) {
        this.objectType = objectType;
    }

    public String getObjectType() {
        return this.objectType;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public void setCheckpointPath(String checkpointPath) {
        this.checkpointPath = checkpointPath;
    }

    public TaskDetail getTaskDetail() {
        return this.taskDetail;
    }

    public void setTaskDetail(TaskDetail taskDetail) {
        this.taskDetail = taskDetail;
    }

    public void setSupervisor(AtomicBoolean supervisor) {
        this.supervisor = supervisor;
    }
}

