/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.dumper.task.generator;

import com.google.common.base.Stopwatch;
import com.oceanbase.partition.calculator.enums.ObPartLevel;
import com.oceanbase.partition.calculator.model.TableEntry;
import com.oceanbase.partition.metadata.desc.ObTablePart;
import com.oceanbase.tools.loaddump.common.metadata.MetadataProvider;
import com.oceanbase.tools.loaddump.common.model.DumpParameter;
import com.oceanbase.tools.loaddump.common.model.TableEntryInfo;
import com.oceanbase.tools.loaddump.common.model.TableInfo;
import com.oceanbase.tools.loaddump.dumper.task.generator.AbstractSqlParserBasedRecordDumpTaskGenerator;
import com.oceanbase.tools.loaddump.dumper.task.helper.AbstractPartitionHelper;
import com.oceanbase.tools.loaddump.dumper.task.helper.MySqlPartitionHelper;
import com.oceanbase.tools.loaddump.dumper.task.helper.OraclePartitionHelper;
import com.oceanbase.tools.loaddump.utils.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractRecordDumpTaskGenerator
extends AbstractSqlParserBasedRecordDumpTaskGenerator {
    private static final Logger log = LoggerFactory.getLogger(AbstractRecordDumpTaskGenerator.class);
    private final MetadataProvider metadataProvider;
    private final AbstractPartitionHelper partitionHelper;

    protected AbstractRecordDumpTaskGenerator(@NonNull DumpParameter dumpParameter) {
        super(dumpParameter);
        if (dumpParameter == null) {
            throw new NullPointerException("dumpParameter is marked non-null but is null");
        }
        this.partitionHelper = this.createPartitionHelper();
        this.metadataProvider = dumpParameter.getConnectionKey().getMetadataProvider();
    }

    @Override
    protected TableEntryInfo queryTableEntryInfo(TableInfo targetTable) throws Exception {
        try {
            return super.queryTableEntryInfo(targetTable);
        }
        catch (Exception e) {
            log.warn("Failed to query table entry. Reason: {}", (Object)e.getMessage());
            Stopwatch stopwatch = Stopwatch.createStarted();
            boolean isPreviousV4 = this.serverMode.isPreviousV4();
            boolean hasNoSysPrivilege = this.dumpParameter.getConnectionKey().hasNoSysPrivileges();
            String table = targetTable.getTable();
            TableEntryInfo targetTableEntryInfo = new TableEntryInfo();
            if (hasNoSysPrivilege && isPreviousV4) {
                log.info("Query partitions for table: \"{}\" without sys account...", (Object)table);
                this.partitionHelper.queryPartitionsNoSys(table, targetTableEntryInfo);
            } else {
                log.info("Query partitions for table: \"{}\" with sys account...", (Object)table);
                try {
                    this.fullFillPartitionInfo(this.partitionHelper.queryTableEntry(table), targetTableEntryInfo);
                }
                catch (Exception e2) {
                    log.warn("Query table entry failed. Reason: {}", (Object)ExceptionUtils.getMessage((Throwable)e2));
                    this.partitionHelper.queryPartitionsNoSys(table, targetTableEntryInfo);
                }
            }
            try {
                Stopwatch sw4GetConstraint = Stopwatch.createStarted();
                targetTableEntryInfo.getSplitKeyColumns().addAll(this.querySplitKeyColumns(targetTable));
                log.debug("Query split key for table: \"{}\" finished. Elapsed: {}", (Object)table, (Object)sw4GetConstraint);
            }
            catch (Exception e3) {
                log.error("Query split key for table: \"{}\" failed. Reason: {}", (Object)table, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e3));
                throw new IllegalStateException(e3);
            }
            log.info("Query all table entries success. Elapsed: {}", (Object)stopwatch);
            return targetTableEntryInfo;
        }
    }

    private void fullFillPartitionInfo(TableEntry tableEntry, TableEntryInfo target) {
        ObTablePart tablePart = tableEntry.getTablePart();
        if (tablePart == null) {
            target.setPartLevel(ObPartLevel.LEVEL_ZERO);
            return;
        }
        target.setPartLevel(tablePart.getLevel());
        target.setPartNames(new ArrayList<String>(tablePart.getPartDesc().getPartNameIdMap().keySet()));
        if (tablePart.getLevel() == ObPartLevel.LEVEL_TWO) {
            boolean isUseTemplateInOB3X;
            target.setSubPartNames(new ArrayList<String>(tablePart.getSubPartDesc().getPartNameIdMap().keySet()));
            boolean bl = isUseTemplateInOB3X = !tableEntry.getServerMode().isSubsequentFrom("4.0.0.0") && tablePart.getSubPartDesc().isUseTemplate();
            if (isUseTemplateInOB3X) {
                target.setSubPartNames(target.getPartNames().stream().flatMap(partName -> target.getSubPartNames().stream().map(subPartName -> partName + "s" + subPartName)).collect(Collectors.toList()));
            }
            target.setPartToSubPartMaps(target.getPartNames().stream().collect(Collectors.toMap(Function.identity(), name -> {
                long partId = (Long)tablePart.getPartDesc().getPartNameIdMap().get(name);
                Map partIdSubNames = tablePart.getSubPartDesc().getPartIdSubNamesMap();
                if (MapUtils.isEmpty((Map)partIdSubNames)) {
                    if (!isUseTemplateInOB3X) {
                        throw new IllegalStateException("Invalid state. No sub partition mapping found");
                    }
                    return tablePart.getSubPartDesc().getPartNameIdMap().keySet().stream().map(t -> name + "s" + t).collect(Collectors.toSet());
                }
                return new HashSet((Collection)partIdSubNames.get(partId));
            })));
        }
    }

    private AbstractPartitionHelper createPartitionHelper() {
        return this.serverMode.isOracleMode() ? new OraclePartitionHelper(this.dumpParameter.getConnectionKey()) : new MySqlPartitionHelper(this.dumpParameter.getConnectionKey());
    }

    private List<String> querySplitKeyColumns(TableInfo tableInfo) throws Exception {
        String tableName;
        String schemaName = tableInfo.getSchema();
        List<String> pkCols = this.metadataProvider.queryPrimaryKeyList(this.serverMode, schemaName, tableName = tableInfo.getTable());
        if (CollectionUtils.isNotEmpty(pkCols)) {
            pkCols = pkCols.stream().map(s -> StringUtils.unquoteColumnIdentifier(s, this.serverMode)).collect(Collectors.toList());
        }
        tableInfo.setPrimaryCols(pkCols);
        if (CollectionUtils.isNotEmpty(pkCols)) {
            return new ArrayList<String>(pkCols);
        }
        if (this.dumpParameter.isEnableHiddenPk()) {
            return Collections.singletonList("__pk_increment");
        }
        tableInfo.setNotNullUniqueKeyMap(this.metadataProvider.queryNonNullUniqueKeyMap(this.serverMode, schemaName, tableName));
        if (MapUtils.isEmpty(tableInfo.getNotNullUniqueKeyMap())) {
            return Collections.emptyList();
        }
        return this.findShortestLenUniqueKey(tableInfo);
    }
}

