/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.dumper.task.generator;

import com.google.common.base.Stopwatch;
import com.oceanbase.partition.calculator.enums.ObPartLevel;
import com.oceanbase.tools.loaddump.common.constants.JdbcType;
import com.oceanbase.tools.loaddump.common.enums.ObjectType;
import com.oceanbase.tools.loaddump.common.enums.ServerMode;
import com.oceanbase.tools.loaddump.common.model.DumpParameter;
import com.oceanbase.tools.loaddump.common.model.TableEntryInfo;
import com.oceanbase.tools.loaddump.common.model.TableInfo;
import com.oceanbase.tools.loaddump.dumper.assembler.AbstractStatementAssembler;
import com.oceanbase.tools.loaddump.dumper.assembler.ObMySqlStatementAssembler;
import com.oceanbase.tools.loaddump.dumper.assembler.ObOracleStatementAssembler;
import com.oceanbase.tools.loaddump.dumper.task.generator.DumpTaskGenerator;
import com.oceanbase.tools.loaddump.dumper.task.record.RecordDumpTask;
import com.oceanbase.tools.loaddump.utils.StringUtils;
import com.oceanbase.tools.sqlparser.OBMySQLParser;
import com.oceanbase.tools.sqlparser.OBOracleSQLParser;
import com.oceanbase.tools.sqlparser.statement.Expression;
import com.oceanbase.tools.sqlparser.statement.Operator;
import com.oceanbase.tools.sqlparser.statement.createtable.ColumnAttributes;
import com.oceanbase.tools.sqlparser.statement.createtable.CreateTable;
import com.oceanbase.tools.sqlparser.statement.createtable.InLineConstraint;
import com.oceanbase.tools.sqlparser.statement.createtable.OutOfLineCheckConstraint;
import com.oceanbase.tools.sqlparser.statement.createtable.OutOfLineConstraint;
import com.oceanbase.tools.sqlparser.statement.createtable.Partition;
import com.oceanbase.tools.sqlparser.statement.createtable.SubPartitionElement;
import com.oceanbase.tools.sqlparser.statement.createtable.SubPartitionOption;
import com.oceanbase.tools.sqlparser.statement.expression.CollectionExpression;
import com.oceanbase.tools.sqlparser.statement.expression.ColumnReference;
import com.oceanbase.tools.sqlparser.statement.expression.CompoundExpression;
import com.oceanbase.tools.sqlparser.statement.expression.NullExpression;
import com.oceanbase.tools.sqlparser.statement.expression.RelationReference;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractSqlParserBasedRecordDumpTaskGenerator
implements DumpTaskGenerator<RecordDumpTask> {
    private static final Logger log = LoggerFactory.getLogger(AbstractSqlParserBasedRecordDumpTaskGenerator.class);
    protected final DumpParameter dumpParameter;
    protected final boolean oracleMode;
    protected final ServerMode serverMode;

    protected AbstractSqlParserBasedRecordDumpTaskGenerator(@NonNull DumpParameter dumpParameter) {
        if (dumpParameter == null) {
            throw new NullPointerException("dumpParameter is marked non-null but is null");
        }
        this.dumpParameter = dumpParameter;
        this.serverMode = dumpParameter.getConnectionKey().getServerMode();
        this.oracleMode = this.serverMode.isOracleMode();
    }

    @Override
    public List<RecordDumpTask> generateDumpTasks(@NonNull ObjectType objectType, @NonNull Set<String> objectNames) throws Exception {
        if (objectType == null) {
            throw new NullPointerException("objectType is marked non-null but is null");
        }
        if (objectNames == null) {
            throw new NullPointerException("objectNames is marked non-null but is null");
        }
        Validate.isTrue((objectType == ObjectType.TABLE ? 1 : 0) != 0, (String)"ObjectType should be equals to TABLE when dumping record", (Object[])new Object[0]);
        AbstractStatementAssembler customQueryOrEmptyTblAssembler = this.getAssemblerForCustomQueryOrEmptyTable();
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)this.dumpParameter.getQuerySql())) {
            Validate.isTrue((objectNames.size() == 1 ? 1 : 0) != 0, (String)"Object name should be singleton when --query-sql is set", (Object[])new Object[0]);
            String objectName = objectNames.iterator().next();
            return Collections.singletonList(new RecordDumpTask(objectName, customQueryOrEmptyTblAssembler));
        }
        ArrayList<RecordDumpTask> tasks = new ArrayList<RecordDumpTask>();
        for (String objectName : objectNames) {
            TableInfo targetTable = this.dumpParameter.getDatabase().getTableInfoMap().get(objectName);
            if (targetTable == null) {
                throw new IllegalStateException("Table " + objectName + " is not present");
            }
            if (targetTable.isEmptyTable()) {
                tasks.add(new RecordDumpTask(true, objectName, customQueryOrEmptyTblAssembler));
                continue;
            }
            TableEntryInfo targetTableEntryInfo = this.queryTableEntryInfo(targetTable);
            List<String> partNames = this.filterSpecifiedPartitionNames(targetTableEntryInfo);
            tasks.addAll(this.doGenerateDumpTasks(targetTable, targetTableEntryInfo, partNames));
        }
        Collections.shuffle(tasks);
        return tasks;
    }

    protected abstract List<RecordDumpTask> doGenerateDumpTasks(TableInfo var1, TableEntryInfo var2, List<String> var3) throws Exception;

    private List<String> filterSpecifiedPartitionNames(TableEntryInfo tableEntryInfo) {
        if (tableEntryInfo.getPartLevel() == null || tableEntryInfo.getPartLevel() == ObPartLevel.LEVEL_ZERO) {
            return Collections.emptyList();
        }
        Set<String> specifiedParts = this.dumpParameter.getPartitions();
        if (CollectionUtils.isEmpty(specifiedParts)) {
            return tableEntryInfo.getPartLevel() == ObPartLevel.LEVEL_TWO ? tableEntryInfo.getSubPartNames() : tableEntryInfo.getPartNames();
        }
        HashSet specPartSet = new HashSet();
        if (tableEntryInfo.getPartLevel() == ObPartLevel.LEVEL_TWO) {
            specifiedParts.forEach(name -> {
                if (tableEntryInfo.getPartNames().contains(name)) {
                    specPartSet.addAll(tableEntryInfo.getPartToSubPartMaps().get(name));
                } else if (tableEntryInfo.getSubPartNames().contains(name)) {
                    specPartSet.add(name);
                } else {
                    throw new IllegalArgumentException("Partition: " + name + " doesn't exists. Note, the value of `--partition` should be case-sensitive.");
                }
            });
        } else {
            specifiedParts.forEach(name -> {
                if (!tableEntryInfo.getPartNames().contains(name)) {
                    throw new IllegalArgumentException("Partition: " + name + " doesn't exists. Note, the value of `--partition` should be case-sensitive.");
                }
                specPartSet.add(name);
            });
        }
        return new ArrayList<String>(specPartSet);
    }

    protected AbstractStatementAssembler getAssemblerForCustomQueryOrEmptyTable() {
        return this.oracleMode ? new ObOracleStatementAssembler(this.dumpParameter) : new ObMySqlStatementAssembler(this.dumpParameter);
    }

    protected TableEntryInfo queryTableEntryInfo(TableInfo targetTable) throws Exception {
        Stopwatch stopwatch = Stopwatch.createStarted();
        String ddl = this.queryTableDDL(targetTable);
        CreateTable createTable = this.serverMode.isOracleMode() ? (CreateTable)new OBOracleSQLParser().parse((Reader)new StringReader(ddl)) : (CreateTable)new OBMySQLParser().parse((Reader)new StringReader(ddl));
        TableEntryInfo targetTableEntryInfo = new TableEntryInfo();
        Partition partition = createTable.getPartition();
        if (partition == null) {
            targetTableEntryInfo.setPartLevel(ObPartLevel.LEVEL_ZERO);
        } else {
            targetTableEntryInfo.setPartLevel(ObPartLevel.LEVEL_ONE);
            List<String> partNames = partition.getPartitionElements().stream().map(partitionElement -> StringUtils.unquoteColumnIdentifier(partitionElement.getRelation(), this.serverMode)).collect(Collectors.toList());
            targetTableEntryInfo.setPartNames(partNames);
            ArrayList<String> subPartNames = new ArrayList<String>();
            HashMap<String, Set<String>> partToSubPartMaps = new HashMap<String, Set<String>>();
            SubPartitionOption subPartitionOption = partition.getSubPartitionOption();
            if (subPartitionOption != null) {
                targetTableEntryInfo.setPartLevel(ObPartLevel.LEVEL_TWO);
                partition.getPartitionElements().forEach(partitionElement -> {
                    String partitionName = StringUtils.unquoteColumnIdentifier(partitionElement.getRelation(), this.serverMode);
                    ArrayList<String> subPartitionNames = new ArrayList<String>();
                    List subPartitionElements = partitionElement.getSubPartitionElements();
                    if (subPartitionElements != null) {
                        for (SubPartitionElement subPartitionElement : subPartitionElements) {
                            subPartitionNames.add(StringUtils.unquoteColumnIdentifier(subPartitionElement.getRelation(), this.serverMode));
                        }
                    } else if (subPartitionOption.getTemplates() != null) {
                        for (SubPartitionElement subPartitionElement : subPartitionOption.getTemplates()) {
                            subPartitionNames.add(partitionName + "s" + StringUtils.unquoteColumnIdentifier(subPartitionElement.getRelation(), this.serverMode));
                        }
                    }
                    subPartNames.addAll(subPartitionNames);
                    partToSubPartMaps.put(partitionName, new TreeSet(subPartitionNames));
                });
            }
            targetTableEntryInfo.setSubPartNames(subPartNames);
            targetTableEntryInfo.setPartToSubPartMaps(partToSubPartMaps);
        }
        String table = targetTable.getTable();
        try {
            Stopwatch sw4GetConstraint = Stopwatch.createStarted();
            targetTableEntryInfo.getSplitKeyColumns().addAll(this.querySplitKeyColumns(targetTable, createTable));
            log.debug("Query split key for table: \"{}\" finished. Elapsed: {}", (Object)table, (Object)sw4GetConstraint);
        }
        catch (Exception e) {
            log.error("Query split key for table: \"{}\" failed. Reason: {}", (Object)table, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            throw e;
        }
        log.info("Query table entry for table \"{}\" success. Elapsed: {}", (Object)table, (Object)stopwatch);
        return targetTableEntryInfo;
    }

    /*
     * Exception decompiling
     */
    private String queryTableDDL(TableInfo tableInfo) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private List<String> getNotNullColumns(CreateTable createTable) {
        List<String> notNullColumns = createTable.getColumnDefinitions().stream().filter(columnDefinition -> {
            ColumnAttributes attr = columnDefinition.getColumnAttributes();
            if (attr == null || CollectionUtils.isEmpty((Collection)attr.getConstraints())) {
                return false;
            }
            return attr.getConstraints().stream().anyMatch(item -> {
                if (!Boolean.FALSE.equals(item.getNullable())) {
                    return false;
                }
                if (item.getState() == null) {
                    return true;
                }
                return !Boolean.FALSE.equals(item.getState().getEnable());
            });
        }).map(item -> StringUtils.unquoteColumnIdentifier(item.getColumnReference().getColumn(), this.serverMode)).collect(Collectors.toList());
        notNullColumns.addAll(createTable.getConstraints().stream().filter(c -> {
            if (c.getState() != null && Boolean.FALSE.equals(c.getState().getEnable())) {
                return false;
            }
            return c instanceof OutOfLineCheckConstraint;
        }).flatMap(c -> this.getNotNullColumns(((OutOfLineCheckConstraint)c).getCheckExpr()).stream()).collect(Collectors.toList()));
        return notNullColumns;
    }

    private List<String> getNotNullColumns(Expression expression) {
        return this.findAll(expression, expr -> {
            if (!(expr instanceof CompoundExpression)) {
                return false;
            }
            CompoundExpression cExpr = (CompoundExpression)expr;
            return (cExpr.getLeft() instanceof ColumnReference || cExpr.getLeft() instanceof RelationReference) && cExpr.getOperator() == Operator.NE && cExpr.getRight() instanceof NullExpression;
        }).stream().map(expr -> {
            Expression left = ((CompoundExpression)expr).getLeft();
            String columnName = left instanceof RelationReference ? this.getColumnName((RelationReference)left) : ((ColumnReference)left).getColumn();
            return StringUtils.unquoteColumnIdentifier(columnName, this.serverMode);
        }).collect(Collectors.toList());
    }

    private String getColumnName(RelationReference r) {
        String tmp = null;
        while (r != null) {
            tmp = r.getRelationName();
            if (r.getReference() == null || !(r.getReference() instanceof RelationReference)) break;
            r = (RelationReference)r.getReference();
        }
        return tmp;
    }

    private List<Expression> findAll(Expression expr, Predicate<Expression> predicate) {
        if (predicate.test(expr)) {
            ArrayList<Expression> list = new ArrayList<Expression>();
            list.add(expr);
            return list;
        }
        if (!(expr instanceof CompoundExpression) && !(expr instanceof CollectionExpression)) {
            return new ArrayList<Expression>();
        }
        if (expr instanceof CollectionExpression) {
            return ((CollectionExpression)expr).getExpressionList().stream().flatMap(e -> this.findAll((Expression)e, predicate).stream()).collect(Collectors.toList());
        }
        CompoundExpression c = (CompoundExpression)expr;
        List<Expression> list = this.findAll(c.getLeft(), predicate);
        if (c.getRight() != null) {
            list.addAll(this.findAll(c.getRight(), predicate));
        }
        return list;
    }

    private List<String> querySplitKeyColumns(TableInfo tableInfo, CreateTable createTable) {
        List primaryKeys = createTable.getColumnDefinitions().stream().filter(columnDefinition -> {
            ColumnAttributes attr = columnDefinition.getColumnAttributes();
            if (attr == null || CollectionUtils.isEmpty((Collection)attr.getConstraints())) {
                return false;
            }
            return attr.getConstraints().stream().anyMatch(InLineConstraint::isPrimaryKey);
        }).map(i -> StringUtils.unquoteColumnIdentifier(i.getColumnReference().getColumn(), this.serverMode)).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(primaryKeys)) {
            primaryKeys = createTable.getConstraints().stream().filter(OutOfLineConstraint::isPrimaryKey).map(constraint -> constraint.getColumns().stream().map(c -> StringUtils.unquoteColumnIdentifier(c.getColumn().getText(), this.serverMode)).collect(Collectors.toList())).findFirst().orElse(new ArrayList());
        }
        tableInfo.setPrimaryCols(primaryKeys);
        if (CollectionUtils.isNotEmpty(primaryKeys)) {
            return new ArrayList<String>(primaryKeys);
        }
        if (this.dumpParameter.isEnableHiddenPk()) {
            return Collections.singletonList("__pk_increment");
        }
        List<String> nonNullKeys = this.getNotNullColumns(createTable);
        HashMap<String, List<String>> nonNullUniqueKeys = new HashMap<String, List<String>>();
        createTable.getConstraints().stream().filter(OutOfLineConstraint::isUniqueKey).forEach(constraint -> {
            String name;
            List columnNames = constraint.getColumns().stream().map(c -> StringUtils.unquoteColumnIdentifier(c.getColumn().getText(), this.serverMode)).filter(nonNullKeys::contains).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(columnNames)) {
                return;
            }
            String string = name = constraint.getConstraintName() != null ? constraint.getConstraintName() : constraint.getIndexName();
            if (name == null) {
                name = UUID.randomUUID().toString();
            }
            nonNullUniqueKeys.put(StringUtils.unquoteSqlIdentifier(name, this.serverMode), columnNames);
        });
        createTable.getColumnDefinitions().stream().filter(columnDefinition -> {
            ColumnAttributes attr = columnDefinition.getColumnAttributes();
            if (attr == null || CollectionUtils.isEmpty((Collection)attr.getConstraints())) {
                return false;
            }
            return attr.getConstraints().stream().anyMatch(InLineConstraint::isUniqueKey);
        }).forEach(i -> {
            String columnName = StringUtils.unquoteColumnIdentifier(i.getColumnReference().getColumn(), this.serverMode);
            if (!nonNullKeys.contains(columnName)) {
                return;
            }
            nonNullUniqueKeys.put(UUID.randomUUID().toString(), Collections.singletonList(columnName));
        });
        tableInfo.setNotNullUniqueKeyMap(nonNullUniqueKeys);
        if (MapUtils.isEmpty(tableInfo.getNotNullUniqueKeyMap())) {
            return Collections.emptyList();
        }
        return this.findShortestLenUniqueKey(tableInfo);
    }

    protected List<String> findShortestLenUniqueKey(TableInfo tableInfo) {
        Map<String, List<String>> uniqueKeyMap = tableInfo.getNotNullUniqueKeyMap();
        TreeMap<Integer, List> multimap = new TreeMap<Integer, List>();
        for (Map.Entry<String, List<String>> entry : uniqueKeyMap.entrySet()) {
            int totalScore = entry.getValue().size();
            for (String columnName : entry.getValue()) {
                String dataType = tableInfo.getColumnTypeName(columnName);
                if (JdbcType.isNumericType(dataType)) {
                    ++totalScore;
                    continue;
                }
                if (JdbcType.isStringType(dataType)) {
                    totalScore += 2;
                    continue;
                }
                if (JdbcType.isDateType(dataType)) {
                    totalScore += 3;
                    continue;
                }
                totalScore += 4;
            }
            List uniqueConstraintNames = multimap.getOrDefault(totalScore, new ArrayList());
            uniqueConstraintNames.add(entry.getKey());
            multimap.putIfAbsent(totalScore, uniqueConstraintNames);
        }
        String uniqueConstraintName = (String)((List)multimap.firstEntry().getValue()).get(0);
        log.debug("Find the shortest length unique constraint success. Constraint name: \"{}\"", (Object)uniqueConstraintName);
        return uniqueKeyMap.get(uniqueConstraintName);
    }
}

