/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.dumper.task.generator;

import com.google.common.base.Stopwatch;
import com.oceanbase.tools.loaddump.common.constants.JdbcType;
import com.oceanbase.tools.loaddump.common.enums.Hint;
import com.oceanbase.tools.loaddump.common.model.DumpParameter;
import com.oceanbase.tools.loaddump.common.model.Pair;
import com.oceanbase.tools.loaddump.common.model.RangeKey;
import com.oceanbase.tools.loaddump.common.model.TableEntryInfo;
import com.oceanbase.tools.loaddump.common.model.TableInfo;
import com.oceanbase.tools.loaddump.common.model.TableRangeInfo;
import com.oceanbase.tools.loaddump.dumper.assembler.AbstractStatementAssembler;
import com.oceanbase.tools.loaddump.dumper.assembler.ObMySqlStatementAssembler;
import com.oceanbase.tools.loaddump.dumper.assembler.ObOracleStatementAssembler;
import com.oceanbase.tools.loaddump.dumper.task.generator.AbstractRecordDumpTaskGenerator;
import com.oceanbase.tools.loaddump.dumper.task.record.RecordDumpTask;
import com.oceanbase.tools.loaddump.dumper.typehandler.TypeHandler;
import com.oceanbase.tools.loaddump.utils.SqlNotesUtil;
import com.oceanbase.tools.loaddump.utils.StringUtils;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.NonNull;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecordDumpTaskGenerator
extends AbstractRecordDumpTaskGenerator {
    private static final Logger log = LoggerFactory.getLogger(RecordDumpTaskGenerator.class);
    private final ThreadPoolExecutor queryBoundsExecutor;

    public RecordDumpTaskGenerator(@NonNull DumpParameter dumpParameter, @NonNull ThreadPoolExecutor queryBoundsExecutor) {
        super(dumpParameter);
        if (dumpParameter == null) {
            throw new NullPointerException("dumpParameter is marked non-null but is null");
        }
        if (queryBoundsExecutor == null) {
            throw new NullPointerException("queryBoundsExecutor is marked non-null but is null");
        }
        this.queryBoundsExecutor = queryBoundsExecutor;
    }

    @Override
    protected List<RecordDumpTask> doGenerateDumpTasks(TableInfo targetTable, TableEntryInfo targetTableEntryInfo, List<String> partNames) throws Exception {
        ArrayList<RecordDumpTask> tasks;
        String tblName = targetTable.getTable();
        log.info("Generating sub-tasks for table \"{}\" by partitions and primary/unique keys...", (Object)tblName);
        Stopwatch stopwatch = Stopwatch.createStarted();
        ExecutorCompletionService<List> completionService = new ExecutorCompletionService<List>(this.queryBoundsExecutor);
        long dataVersion = this.queryLatestMergedDataVersion();
        if (CollectionUtils.isEmpty(partNames)) {
            tasks = new ArrayList<RecordDumpTask>(this.splitTableRows(targetTable, targetTableEntryInfo, null, dataVersion));
        } else {
            int i;
            for (i = 1; i < partNames.size(); ++i) {
                String partName = partNames.get(i);
                completionService.submit(() -> this.splitTableRows(targetTable, targetTableEntryInfo, partName, dataVersion));
            }
            tasks = new ArrayList<RecordDumpTask>(this.splitTableRows(targetTable, targetTableEntryInfo, partNames.get(0), dataVersion));
            for (i = 1; i < partNames.size(); ++i) {
                tasks.addAll((Collection)completionService.take().get());
            }
        }
        log.info("Generate {} sub-tasks for table \"{}\" succeed. Elapsed: {}", new Object[]{tasks.size(), tblName, stopwatch});
        return tasks;
    }

    protected AbstractStatementAssembler getAssembler(TableRangeInfo tableRangeInfo, long dataVersion) {
        return this.oracleMode ? new ObOracleStatementAssembler(tableRangeInfo, this.dumpParameter, dataVersion) : new ObMySqlStatementAssembler(tableRangeInfo, this.dumpParameter, dataVersion);
    }

    protected long queryLatestMergedDataVersion() throws Exception {
        return Long.MIN_VALUE;
    }

    private RecordDumpTask generateTask(TableInfo targetTable, long dataVersion, TableRangeInfo item) {
        return new RecordDumpTask(targetTable.getTable(), this.getAssembler(item, dataVersion));
    }

    private List<RecordDumpTask> splitTableRows(TableInfo tableInfo, TableEntryInfo tableEntryInfo, String partName, long dataVersion) throws Exception {
        String partitionedFlag;
        boolean isPartNameNotExists = org.apache.commons.lang3.StringUtils.isBlank((CharSequence)partName);
        String tableName = tableInfo.getTable();
        String string = partitionedFlag = isPartNameNotExists ? "non-partitioned table" : "partitioned table";
        if (CollectionUtils.isEmpty(tableEntryInfo.getSplitKeyColumns())) {
            if (isPartNameNotExists) {
                log.debug("Split rows for {}(without primary key): \"{}\" success. Ranges: 1", (Object)partitionedFlag, (Object)tableName);
                return Collections.singletonList(this.generateTask(tableInfo, dataVersion, new TableRangeInfo(tableName)));
            }
            log.debug("Split rows for {}(without primary key): \"{}\" partition: \"{}\" success. Ranges: 1", new Object[]{partitionedFlag, tableName, partName});
            return Collections.singletonList(this.generateTask(tableInfo, dataVersion, new TableRangeInfo(tableName, partName)));
        }
        try {
            List<TableRangeInfo> bounds;
            Stopwatch stopwatch = Stopwatch.createStarted();
            if (isPartNameNotExists) {
                bounds = this.queryBounds(tableInfo, tableEntryInfo, null, dataVersion);
                log.debug("Split rows for {}(with primary key): \"{}\" success. Ranges: {}. Elapsed: {}", new Object[]{partitionedFlag, tableName, bounds.size(), stopwatch});
            } else {
                bounds = this.queryBounds(tableInfo, tableEntryInfo, partName, dataVersion);
                log.debug("Split rows for {}(with primary key): \"{}\" partition: \"{}\" success. Ranges: {}. Elapsed: {}", new Object[]{partitionedFlag, tableName, partName, bounds.size(), stopwatch});
            }
            return bounds.stream().map(item -> this.generateTask(tableInfo, dataVersion, (TableRangeInfo)item)).collect(Collectors.toList());
        }
        catch (Exception e) {
            log.error("Split rows for {}(with primary key): \"{}\" failed. Reason: {}", new Object[]{partitionedFlag, tableName, ExceptionUtils.getRootCauseMessage((Throwable)e)});
            throw e;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<TableRangeInfo> queryBounds(TableInfo tableInfo, TableEntryInfo tableEntryInfo, String partName, long dataVersion) throws Exception {
        isNonPartitioned = org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)partName);
        splitKeyCols = tableEntryInfo.getSplitKeyColumns();
        primaryKeyColumnSize = splitKeyCols.size();
        bounds = new ArrayList<TableRangeInfo>();
        tableName = tableInfo.getTable();
        partitionedFlag = isNonPartitioned != false ? "non-partitioned table" : "partitioned table";
        successFlag = isNonPartitioned != false ? "success" : "partition: \"" + partName + "\" success";
        conn = this.dumpParameter.getConnectionKey().getSessionManager().getPooledBizConnection();
        var14_13 = null;
        try {
            wrappedPkCols2DataType = splitKeyCols.stream().map((Function<String, Pair>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$queryBounds$2(com.oceanbase.tools.loaddump.common.model.TableInfo java.lang.String ), (Ljava/lang/String;)Lcom/oceanbase/tools/loaddump/common/model/Pair;)((RecordDumpTaskGenerator)this, (TableInfo)tableInfo)).collect(Collectors.toList());
            descPriCols = null;
            if (this.oracleMode) {
                descPriCols = splitKeyCols.stream().map((Function<String, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$queryBounds$3(java.lang.String ), (Ljava/lang/String;)Ljava/lang/String;)((RecordDumpTaskGenerator)this)).collect(Collectors.joining(","));
            }
            preBound = null;
            curBound = null;
            typeHandlers = splitKeyCols.stream().map((Function<String, TypeHandler>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getTypeHandler(java.lang.String ), (Ljava/lang/String;)Lcom/oceanbase/tools/loaddump/dumper/typehandler/TypeHandler;)((TableInfo)tableInfo)).collect(Collectors.toList());
            while (true) {
                block65: {
                    block66: {
                        try {
                            block62: {
                                if (curBound != null) {
                                    preBound = preBound == null ? new RangeKey[primaryKeyColumnSize] : preBound;
                                    System.arraycopy(curBound, 0, preBound, 0, curBound.length);
                                }
                                sql = this.buildSelectBoundSql(tableInfo.getSchemaTable(), partName, dataVersion, wrappedPkCols2DataType, descPriCols, preBound);
                                ps = conn.prepareStatement(SqlNotesUtil.addLoaderDumperNotes(sql), 1003, 1007);
                                var22_24 = null;
                                try {
                                    block60: {
                                        block61: {
                                            ps.setFetchSize(this.dumpParameter.getFetchSize());
                                            if (preBound != null) {
                                                for (i = 0; i < preBound.length; ++i) {
                                                    ps.setObject(i + 1, preBound[i].getValue());
                                                }
                                            }
                                            rs = ps.executeQuery();
                                            var24_29 = null;
                                            try {
                                                if (!rs.next()) {
                                                    rangeList = preBound == null ? null : Collections.singletonList(Pair.of(preBound, new RangeKey[0]));
                                                    bounds.add(new TableRangeInfo(tableName, rangeList, wrappedPkCols2DataType, partName));
                                                    if (RecordDumpTaskGenerator.log.isDebugEnabled()) {
                                                        RecordDumpTaskGenerator.log.debug("....Splitting rows for {}: \"{}\" {}. Batch: {}", new Object[]{partitionedFlag, tableName, successFlag, bounds.size()});
                                                    }
                                                    if (rs == null) break block60;
                                                    if (var24_29 == null) break block61;
                                                }
                                                ** GOTO lbl-1000
                                            }
                                            catch (Throwable var25_33) {
                                                try {
                                                    var24_29 = var25_33;
                                                    throw var25_33;
                                                }
                                                catch (Throwable var29_43) {
                                                    if (rs == null) throw var29_43;
                                                    if (var24_29 == null) {
                                                        rs.close();
                                                        throw var29_43;
                                                    }
                                                    try {
                                                        rs.close();
                                                        throw var29_43;
                                                    }
                                                    catch (Throwable var30_44) {
                                                        var24_29.addSuppressed(var30_44);
                                                        throw var29_43;
                                                    }
                                                }
                                            }
                                            try {
                                                rs.close();
                                            }
                                            catch (Throwable var26_36) {
                                                var24_29.addSuppressed(var26_36);
                                            }
                                            break block60;
                                        }
                                        rs.close();
                                    }
                                    if (ps == null) break;
                                    if (var22_24 == null) break block62;
                                }
                                catch (Throwable var23_28) {
                                    try {
                                        var22_24 = var23_28;
                                        throw var23_28;
                                    }
                                    catch (Throwable var31_45) {
                                        if (ps == null) throw var31_45;
                                        if (var22_24 == null) {
                                            ps.close();
                                            throw var31_45;
                                        }
                                        try {
                                            ps.close();
                                            throw var31_45;
                                        }
                                        catch (Throwable var32_46) {
                                            var22_24.addSuppressed(var32_46);
                                            throw var31_45;
                                        }
                                    }
                                }
                                try {
                                    ps.close();
                                }
                                catch (Throwable var26_37) {
                                    var22_24.addSuppressed(var26_37);
                                }
                                break;
                            }
                            ps.close();
                            break;
lbl-1000:
                            // 1 sources

                            {
                                curBound = curBound == null ? new RangeKey[primaryKeyColumnSize] : curBound;
                                i = 0;
lbl101:
                                // 2 sources

                                while (i < primaryKeyColumnSize) {
                                    value = ((TypeHandler)typeHandlers.get(i)).getNullableResult(rs, i + 1);
                                    if (value != null) ** GOTO lbl-1000
                                    RecordDumpTaskGenerator.log.info("Found null in unique constraints [{}], abort splitting table \"{}\"", (Object)wrappedPkCols2DataType.stream().map((Function<Pair, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getLeft(), (Lcom/oceanbase/tools/loaddump/common/model/Pair;)Ljava/lang/String;)()).collect(Collectors.joining(",")), (Object)tableName);
                                    var27_38 = Collections.singletonList(new TableRangeInfo(tableName, partName));
                                    if (rs == null) break block63;
                                    if (var24_29 == null) break block64;
                                }
                                ** GOTO lbl136
                            }
                            {
                                block63: {
                                    block64: {
                                        try {
                                            rs.close();
                                        }
                                        catch (Throwable var28_39) {
                                            var24_29.addSuppressed(var28_39);
                                        }
                                        break block63;
                                    }
                                    rs.close();
                                }
                                if (ps == null) return var27_38;
                                if (var22_24 != null) {
                                    try {
                                        ps.close();
                                        return var27_38;
                                    }
                                    catch (Throwable var28_40) {
                                        var22_24.addSuppressed(var28_40);
                                        return var27_38;
                                    }
                                }
                                ps.close();
                                return var27_38;
                                break;
                            }
                        }
                        catch (Exception e) {
                            failedFlag = isNonPartitioned != false ? "failed." : "partition: \"" + partName + "\" failed.";
                            RecordDumpTaskGenerator.log.error("Splitting rows for {}: \"{}\" {}. Reason: {}", new Object[]{partitionedFlag, tableName, failedFlag, ExceptionUtils.getRootCauseMessage((Throwable)e)});
                            throw e;
                        }
lbl-1000:
                        // 1 sources

                        {
                            curBound[i] = new RangeKey(value.toString());
                            ++i;
                            ** GOTO lbl101
lbl136:
                            // 1 sources

                            startRange = new RangeKey[]{};
                            if (preBound != null) {
                                startRange = new RangeKey[preBound.length];
                                System.arraycopy(preBound, 0, startRange, 0, preBound.length);
                            }
                            endRange = new RangeKey[curBound.length];
                            System.arraycopy(curBound, 0, endRange, 0, curBound.length);
                            bounds.add(new TableRangeInfo(tableName, Collections.singletonList(Pair.of(startRange, endRange)), wrappedPkCols2DataType, partName));
                            if (RecordDumpTaskGenerator.log.isDebugEnabled()) {
                                RecordDumpTaskGenerator.log.debug("....Splitting rows for {}: \"{}\" {}. Batch: {}", new Object[]{partitionedFlag, tableName, successFlag, bounds.size()});
                            }
                            if (rs == null) break block65;
                            if (var24_29 == null) break block66;
                        }
                        try {
                            rs.close();
                        }
                        catch (Throwable var25_32) {
                            var24_29.addSuppressed(var25_32);
                        }
                        break block65;
                    }
                    rs.close();
                }
                if (ps == null) continue;
                if (var22_24 != null) {
                    try {
                        ps.close();
                    }
                    catch (Throwable var23_27) {
                        var22_24.addSuppressed(var23_27);
                    }
                    continue;
                }
                ps.close();
            }
            var20_20 = bounds;
            return var20_20;
        }
        catch (Throwable var15_15) {
            var14_13 = var15_15;
            throw var15_15;
        }
        finally {
            if (conn != null) {
                if (var14_13 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable var28_42) {
                        var14_13.addSuppressed(var28_42);
                    }
                } else {
                    conn.close();
                }
            }
        }
    }

    private String buildSelectBoundSql(String schemaTable, String partName, long dataVersion, List<Pair<String, String>> wrappedPkCols2DataType, String descPriCols, RangeKey[] preVals) {
        if (this.oracleMode) {
            return this.buildOracleSelectBoundPattern(schemaTable, partName, dataVersion, wrappedPkCols2DataType, descPriCols, preVals);
        }
        return this.buildMysqlSelectBoundPattern(schemaTable, partName, dataVersion, wrappedPkCols2DataType, preVals);
    }

    private String buildMysqlSelectBoundPattern(String schemaTable, String partName, long dataVersion, List<Pair<String, String>> wrappedPkCols2DataType, RangeKey[] preVals) {
        StringBuilder sql = new StringBuilder(128);
        String primaryCols = wrappedPkCols2DataType.stream().map(Pair::getLeft).collect(Collectors.joining(","));
        sql.append("select ");
        ArrayList<Hint> hints = new ArrayList<Hint>();
        if (dataVersion > -1L) {
            hints.add(new Hint(Hint.HintTypes.FROZEN_VERSION, dataVersion));
        }
        if (this.dumpParameter.isEnableHiddenPk() && !this.serverMode.isPreviousV4()) {
            hints.add(new Hint(Hint.HintTypes.OPT_PARAM, "'hidden_column_visible', 'true'"));
        }
        if (!hints.isEmpty()) {
            sql.append("/*+").append(hints.stream().map(Hint::getHintStatement).collect(Collectors.joining(" , "))).append("*/ ");
        }
        sql.append(primaryCols).append(" from ").append(schemaTable);
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)partName)) {
            sql.append("partition(").append(this.serverMode.wrapName(partName)).append(") ");
        }
        if (dataVersion <= -1L && !this.serverMode.isPreviousV2270() && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)this.dumpParameter.getFlashbackScn())) {
            sql.append(" as of snapshot ").append(this.dumpParameter.getFlashbackScn());
        }
        if (preVals != null) {
            String prePlaceHolders = Stream.of(preVals).map(RangeKey::getPlaceHolder).collect(Collectors.joining(","));
            String wrappedPks = wrappedPkCols2DataType.stream().map(e -> e.getRight() != null && JdbcType.isBinaryType((String)e.getRight()) ? "hex(" + (String)e.getLeft() + ")" : (String)e.getLeft()).collect(Collectors.joining(","));
            sql.append(" where ( ").append(wrappedPks).append(") > ( ").append(prePlaceHolders).append(" ) ");
        }
        return sql.append(" order by ").append(primaryCols).append(" limit ").append(this.dumpParameter.getPageSize() - 1).append(",").append(" 1 ").toString();
    }

    private String buildOracleSelectBoundPattern(String schemaTable, String partName, long dataVersion, List<Pair<String, String>> wrappedPkCols2DataType, String descPrimaryCols, RangeKey[] preVals) {
        StringBuilder sql = new StringBuilder(128);
        String primaryCols = wrappedPkCols2DataType.stream().map(Pair::getLeft).collect(Collectors.joining(","));
        sql.append("SELECT ");
        ArrayList<Hint> hints = new ArrayList<Hint>();
        if (dataVersion > -1L) {
            hints.add(new Hint(Hint.HintTypes.FROZEN_VERSION, dataVersion));
        }
        if (this.dumpParameter.isEnableHiddenPk() && !this.serverMode.isPreviousV4()) {
            hints.add(new Hint(Hint.HintTypes.OPT_PARAM, "'hidden_column_visible', 'true'"));
        }
        if (!hints.isEmpty()) {
            sql.append("/*+").append(hints.stream().map(Hint::getHintStatement).collect(Collectors.joining(" , "))).append("*/ ");
        }
        sql.append(primaryCols).append(", ROWNUM RN FROM ").append(schemaTable);
        if (StringUtils.isNotEmpty(partName)) {
            sql.append("PARTITION(").append(this.serverMode.wrapName(partName)).append(") ");
        }
        if (dataVersion <= -1L && !this.serverMode.isPreviousV2270()) {
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)this.dumpParameter.getFlashbackScn())) {
                sql.append(" AS OF SCN ").append(this.dumpParameter.getFlashbackScn());
            } else if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)this.dumpParameter.getFlashbackTimestamp())) {
                sql.append(" AS OF TIMESTAMP TO_TIMESTAMP('").append(this.dumpParameter.getFlashbackTimestamp()).append("','YYYY-MM-DD HH24:MI:SS')");
            }
        }
        if (this.serverMode.isPrevious("2.2.52")) {
            sql.append(" WHERE ");
            if (preVals != null) {
                String prePlaceHolders = Stream.of(preVals).map(RangeKey::getPlaceHolder).collect(Collectors.joining(","));
                sql.append(" (").append(primaryCols).append(")>( ").append(prePlaceHolders).append(") AND ");
            }
            sql.append(" ROWNUM<=").append(this.dumpParameter.getPageSize()).append(" ORDER BY ").append(descPrimaryCols);
            return "SELECT " + primaryCols + " FROM (" + sql + ") A WHERE ROWNUM<=1 ORDER BY A.RN";
        }
        if (preVals != null) {
            String prePlaceHolders = Stream.of(preVals).map(RangeKey::getPlaceHolder).collect(Collectors.joining(","));
            sql.append(" WHERE ").append(" (").append(primaryCols).append(")>( ").append(prePlaceHolders).append(")");
        }
        return sql.append(" ORDER BY ").append(primaryCols).append(" OFFSET ").append(this.dumpParameter.getPageSize() - 1).append(" ROWS FETCH NEXT 1 ROWS ONLY").toString();
    }

    private /* synthetic */ String lambda$queryBounds$3(String e) {
        return this.serverMode.wrapName(e) + " desc ";
    }

    private /* synthetic */ Pair lambda$queryBounds$2(TableInfo tableInfo, String s) {
        return new Pair<String, String>(this.serverMode.wrapName(s), tableInfo.getColumnTypeName(s));
    }
}

