/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.dumper.task.generator;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.oceanbase.tools.loaddump.common.enums.ObjectType;
import com.oceanbase.tools.loaddump.common.model.ConnectionKey;
import com.oceanbase.tools.loaddump.common.model.DumpParameter;
import com.oceanbase.tools.loaddump.dumper.task.generator.DumpTaskGenerator;
import com.oceanbase.tools.loaddump.dumper.task.schema.AbstractSchemaDumpTask;
import com.oceanbase.tools.loaddump.dumper.task.schema.ObMysqlCompactSchemaDumpTask;
import com.oceanbase.tools.loaddump.dumper.task.schema.ObMysqlSchemaDumpTask;
import com.oceanbase.tools.loaddump.dumper.task.schema.ObOracleCompactSchemaDumpTask;
import com.oceanbase.tools.loaddump.dumper.task.schema.ObOracleSchemaDumpTask;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.NonNull;

public class SchemaDumpTaskGenerator
implements DumpTaskGenerator<AbstractSchemaDumpTask> {
    private final DumpParameter dumpParameter;
    private final boolean compactSchema;

    public SchemaDumpTaskGenerator(@NonNull DumpParameter dumpParameter) {
        if (dumpParameter == null) {
            throw new NullPointerException("dumpParameter is marked non-null but is null");
        }
        this.dumpParameter = dumpParameter;
        ConnectionKey connectionKey = dumpParameter.getConnectionKey();
        this.compactSchema = dumpParameter.isCompactSchema() || connectionKey.hasNoSysPrivileges() && connectionKey.getServerMode().isPreviousV4();
    }

    @Override
    public List<AbstractSchemaDumpTask> generateDumpTasks(@NonNull ObjectType objectType, @NonNull Set<String> objectNames) {
        if (objectType == null) {
            throw new NullPointerException("objectType is marked non-null but is null");
        }
        if (objectNames == null) {
            throw new NullPointerException("objectNames is marked non-null but is null");
        }
        return Lists.partition(new ArrayList<String>(objectNames), (int)128).stream().map(items -> {
            AbstractSchemaDumpTask dumpTask = this.createDumpTask();
            dumpTask.setObjectType(objectType.getName());
            dumpTask.setRetainSchema(this.dumpParameter.isRetainSchema());
            dumpTask.setWithExtra(this.dumpParameter.isWithExtra());
            HashMap<ObjectType, HashSet> whiteListMap = new HashMap<ObjectType, HashSet>(1);
            whiteListMap.put(objectType, Sets.newHashSet((Iterable)items));
            dumpTask.getWhiteListMap().putAll(whiteListMap);
            dumpTask.getBlackListMap().putAll(this.dumpParameter.getBlackListMap());
            return dumpTask;
        }).collect(Collectors.toList());
    }

    private AbstractSchemaDumpTask createDumpTask() {
        boolean oracleMode = this.dumpParameter.getConnectionKey().getServerMode().isOracleMode();
        if (this.compactSchema) {
            return oracleMode ? new ObOracleCompactSchemaDumpTask() : new ObMysqlCompactSchemaDumpTask();
        }
        return oracleMode ? new ObOracleSchemaDumpTask() : new ObMysqlSchemaDumpTask();
    }
}

