/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.dumper.task.generator;

import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import com.oceanbase.partition.calculator.model.TableEntry;
import com.oceanbase.tools.loaddump.common.constants.Constants;
import com.oceanbase.tools.loaddump.common.enums.MergeStatus;
import com.oceanbase.tools.loaddump.common.metadata.MetadataProvider;
import com.oceanbase.tools.loaddump.common.model.DumpParameter;
import com.oceanbase.tools.loaddump.common.model.Pair;
import com.oceanbase.tools.loaddump.common.model.RangeKey;
import com.oceanbase.tools.loaddump.common.model.RowKey;
import com.oceanbase.tools.loaddump.common.model.TableEntryInfo;
import com.oceanbase.tools.loaddump.common.model.TableInfo;
import com.oceanbase.tools.loaddump.common.model.TableRangeInfo;
import com.oceanbase.tools.loaddump.dumper.task.generator.RecordDumpTaskGenerator;
import com.oceanbase.tools.loaddump.dumper.task.helper.AbstractPartitionHelper;
import com.oceanbase.tools.loaddump.dumper.task.helper.MySqlPartitionHelper;
import com.oceanbase.tools.loaddump.dumper.task.helper.OraclePartitionHelper;
import com.oceanbase.tools.loaddump.dumper.task.record.RecordDumpTask;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnapshotRecordDumpTaskGenerator
extends RecordDumpTaskGenerator {
    private static final Logger log = LoggerFactory.getLogger(SnapshotRecordDumpTaskGenerator.class);
    private final MetadataProvider metadataProvider;
    private final AbstractPartitionHelper partitionHelper;
    private final AtomicBoolean isMergedQueried = new AtomicBoolean(false);

    public SnapshotRecordDumpTaskGenerator(@NonNull DumpParameter dumpParameter, @NonNull MetadataProvider metadataProvider, @NonNull ThreadPoolExecutor queryBoundsExecutor) {
        super(dumpParameter, queryBoundsExecutor);
        if (dumpParameter == null) {
            throw new NullPointerException("dumpParameter is marked non-null but is null");
        }
        if (metadataProvider == null) {
            throw new NullPointerException("metadataProvider is marked non-null but is null");
        }
        if (queryBoundsExecutor == null) {
            throw new NullPointerException("queryBoundsExecutor is marked non-null but is null");
        }
        Validate.isTrue((boolean)dumpParameter.isSnapshot(), (String)"Parameter --snapshot is not set");
        this.metadataProvider = metadataProvider;
        this.partitionHelper = this.serverMode.isOracleMode() ? new OraclePartitionHelper(dumpParameter.getConnectionKey()) : new MySqlPartitionHelper(dumpParameter.getConnectionKey());
    }

    @Override
    protected List<RecordDumpTask> doGenerateDumpTasks(TableInfo targetTable, TableEntryInfo targetTableEntryInfo, List<String> partNames) throws Exception {
        long latestMergedDataVersion = this.queryLatestMergedDataVersion();
        boolean isPreviousV4 = this.serverMode.isPreviousV4();
        TableEntry tableEntry = null;
        if (!this.dumpParameter.getConnectionKey().hasNoSysPrivileges() || !isPreviousV4) {
            try {
                tableEntry = this.partitionHelper.queryTableEntry(targetTable.getTable());
            }
            catch (Exception e) {
                log.warn("Failed to query table entry for \"{}\"", (Object)targetTable.getTable());
            }
        }
        Map leaderMap = null;
        if (!this.dumpParameter.getConnectionKey().hasNoSysPrivileges() && isPreviousV4) {
            Objects.requireNonNull(tableEntry, "Cannot proceed since table entry is null.");
            Stopwatch sw4GetLeaderLocation = Stopwatch.createStarted();
            try (Connection conn = this.dumpParameter.getConnectionKey().getSessionManager().getPooledSysConnection();){
                ArrayList partIds = new ArrayList(tableEntry.getPartIdNameMap().keySet());
                leaderMap = this.partitionHelper.getTableEntryExtractor().queryLeaderLocationMap(conn, tableEntry, partIds);
                log.info("Query leader location for table: \"{}\" before query macro ranges success. Elapsed: {}", (Object)targetTable.getTable(), (Object)sw4GetLeaderLocation);
            }
        }
        if (isPreviousV4 && latestMergedDataVersion > 0L && tableEntry != null) {
            String tblName = targetTable.getTable();
            log.info("Generating sub-tasks for table \"{}\" by macro range...", (Object)tblName);
            Stopwatch stopwatch = Stopwatch.createStarted();
            List<RecordDumpTask> tasks = this.generateDumpTasksByMacroRange(tableEntry, leaderMap, targetTable.getTable(), latestMergedDataVersion);
            log.info("Generate {} sub-tasks for table \"{}\" succeed. Elapsed: {}", new Object[]{tasks.size(), tblName, stopwatch});
            return tasks;
        }
        return super.doGenerateDumpTasks(targetTable, targetTableEntryInfo, partNames);
    }

    @Override
    protected long queryLatestMergedDataVersion() throws Exception {
        MergeStatus mergeStatus;
        if (this.isMergedQueried.compareAndSet(false, true) && (mergeStatus = this.metadataProvider.queryMergeStatus(this.serverMode)) != MergeStatus.IDLE) {
            log.error("Data can not be dumped out correctly as merge status is invalid. The snapshot dumper can only be used when the merge state is IDLE. mergeStatus={}", (Object)mergeStatus);
        }
        long dataVersion = this.metadataProvider.queryLatestMergedVersion(this.serverMode);
        log.info("Query the last merged version success, dataVersion={}", (Object)dataVersion);
        if (dataVersion <= 1L) {
            log.warn("Data can not be dumped out as oceanbase cluster has not merged yet, dataVersion={}", (Object)dataVersion);
        }
        return dataVersion;
    }

    private List<RecordDumpTask> generateDumpTasksByMacroRange(TableEntry tableEntry, Map<Long, String> leaderMap, String tableName, long dataVersion) throws Exception {
        Map<Long, List<String>> macroRangeMap;
        List validRowKeys;
        List<RowKey> rowKeys;
        String tenant = tableEntry.getTenantName();
        Long tableId = tableEntry.getTableId();
        try {
            rowKeys = this.metadataProvider.queryRowKeys(this.serverMode, tenant, tableId);
        }
        catch (SQLException e2) {
            log.error("Query row keys failed. Reason: {}", (Object)ExceptionUtils.getRootCauseMessage((Throwable)e2));
            throw e2;
        }
        if (CollectionUtils.isEmpty(rowKeys)) {
            log.warn("Row keys are not exists. Maybe some errors occurred during query row keys. Use select /* +frozen_version({}) */ instead.", (Object)dataVersion);
        }
        if (CollectionUtils.isEmpty(validRowKeys = rowKeys.stream().filter(e -> !Constants.HIDDEN_KEYS.contains(e.getColumn())).collect(Collectors.toList()))) {
            log.warn("No valid row keys can be used. Maybe the non-partitioned table: \"{}\" has no primary key. Use select /* +frozen_version({}) */ instead.", (Object)tableName, (Object)dataVersion);
            return Collections.singletonList(new RecordDumpTask(tableName, this.getAssembler(new TableRangeInfo(tableName), dataVersion)));
        }
        try {
            macroRangeMap = this.metadataProvider.queryMacroRangeMap(leaderMap, tableId, dataVersion);
        }
        catch (Exception e3) {
            log.error("Query macro range failed. Reason: {}", (Object)ExceptionUtils.getRootCauseMessage((Throwable)e3));
            throw e3;
        }
        Map partIdNameMap = tableEntry.getPartIdNameMap();
        HashMap<String, List<String>> macroRangeListMap = new HashMap<String, List<String>>(64);
        for (Long partitionId : macroRangeMap.keySet()) {
            if (tableEntry.isNonPartitionTable()) {
                macroRangeListMap.putIfAbsent(null, macroRangeMap.get(partitionId));
                continue;
            }
            for (String partName : (Set)partIdNameMap.get(partitionId)) {
                if (!this.isPartitionInclude(partName)) continue;
                macroRangeListMap.putIfAbsent(partName, new ArrayList());
                ((List)macroRangeListMap.get(partName)).addAll((Collection)macroRangeMap.get(partitionId));
            }
        }
        if (MapUtils.isEmpty(macroRangeListMap)) {
            return Collections.singletonList(new RecordDumpTask(true, tableName, this.getAssemblerForCustomQueryOrEmptyTable()));
        }
        List<Pair<String, String>> wrappedRowKey2DataType = validRowKeys.stream().filter(k -> !Constants.HIDDEN_KEYS.contains(k.getColumn())).map(rowKey -> new Pair<String, Object>(this.serverMode.wrapName(rowKey.getColumn()), null)).collect(Collectors.toList());
        int parallelMacros = Math.min(this.dumpParameter.getParallelMacros(), 50);
        ArrayList<RecordDumpTask> tasks = new ArrayList<RecordDumpTask>(1024);
        for (Map.Entry entry : macroRangeListMap.entrySet()) {
            List macroGroups = Lists.partition((List)((List)entry.getValue()), (int)parallelMacros);
            for (List macroGroup : macroGroups) {
                List<Pair<RangeKey[], RangeKey[]>> macroRange = this.parseMacroRange(macroGroup, rowKeys, validRowKeys.size());
                TableRangeInfo rangeInfo = new TableRangeInfo(tableName, macroRange, wrappedRowKey2DataType, (String)entry.getKey());
                tasks.add(new RecordDumpTask(tableName, this.getAssembler(rangeInfo, dataVersion)));
            }
        }
        return tasks;
    }

    private List<Pair<RangeKey[], RangeKey[]>> parseMacroRange(List<String> macroRanges, List<RowKey> rowKeys, int validRowKeySize) {
        if (CollectionUtils.isEmpty(macroRanges)) {
            return null;
        }
        ArrayList<Pair<RangeKey[], RangeKey[]>> conditions = new ArrayList<Pair<RangeKey[], RangeKey[]>>(2);
        for (String range : macroRanges) {
            if (StringUtils.isBlank((CharSequence)range) || range.length() < 2) continue;
            range = range.trim();
            String[] ranges = range.substring(1, range.lastIndexOf(93)).split(" ; ");
            RangeKey[] startValues = new RangeKey[]{};
            String left = ranges[0];
            if (!"MIN".equals(left)) {
                startValues = new RangeKey[validRowKeySize];
                String[] macros = left.split(",");
                int j = 0;
                for (int i = 0; i < rowKeys.size(); ++i) {
                    if (Constants.HIDDEN_KEYS.contains(rowKeys.get(i).getColumn())) continue;
                    String macro = "";
                    if (i < macros.length) {
                        macro = macros[i];
                    }
                    startValues[j++] = this.oracleMode && rowKeys.get(i).isDateType() ? new RangeKey(macro, "TO_TIMESTAMP(?)") : new RangeKey(macro);
                }
            }
            RangeKey[] endValues = new RangeKey[]{};
            String right = ranges[1];
            if (!"MAX".equals(right)) {
                endValues = new RangeKey[validRowKeySize];
                String[] macros = right.split(",");
                int j = 0;
                for (int i = 0; i < rowKeys.size(); ++i) {
                    if (Constants.HIDDEN_KEYS.contains(rowKeys.get(i).getColumn())) continue;
                    String macro = "";
                    if (i < macros.length) {
                        macro = macros[i];
                    }
                    endValues[j++] = this.oracleMode && rowKeys.get(i).isDateType() ? new RangeKey(macro, "TO_TIMESTAMP(?)") : new RangeKey(macro);
                }
            }
            if (!ArrayUtils.isNotEmpty((Object[])startValues) && !ArrayUtils.isNotEmpty((Object[])endValues)) continue;
            conditions.add(new Pair<RangeKey[], RangeKey[]>(startValues, endValues));
        }
        return conditions;
    }

    private boolean isPartitionInclude(String partitionName) {
        Set<String> specifiedPartNames = this.dumpParameter.getPartitions();
        if (CollectionUtils.isEmpty(specifiedPartNames)) {
            return true;
        }
        return specifiedPartNames.contains(partitionName);
    }
}

