/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.dumper.task.helper;

import com.alibaba.druid.pool.DruidDataSource;
import com.oceanbase.partition.calculator.enums.ObPartLevel;
import com.oceanbase.partition.calculator.helper.TableEntryExtractor;
import com.oceanbase.partition.calculator.model.TableEntry;
import com.oceanbase.partition.calculator.model.TableEntryKey;
import com.oceanbase.tools.loaddump.common.SessionManager;
import com.oceanbase.tools.loaddump.common.enums.ServerMode;
import com.oceanbase.tools.loaddump.common.model.ConnectionKey;
import com.oceanbase.tools.loaddump.common.model.Pair;
import com.oceanbase.tools.loaddump.common.model.TableEntryInfo;
import com.oceanbase.tools.loaddump.jdbc.JdbcExecutor;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPartitionHelper {
    private static final Logger log = LoggerFactory.getLogger(AbstractPartitionHelper.class);
    protected ServerMode serverMode;
    protected ConnectionKey connectionKey;
    protected SessionManager sessionManager;
    protected TableEntryExtractor tableEntryExtractor;

    public AbstractPartitionHelper(ConnectionKey connectionKey) {
        this.connectionKey = connectionKey;
        this.serverMode = connectionKey.getServerMode();
        this.sessionManager = connectionKey.getSessionManager();
        this.tableEntryExtractor = new TableEntryExtractor();
    }

    public TableEntry queryTableEntry(String table) throws Exception {
        boolean isPreviousV4 = this.serverMode.isPreviousV4();
        TableEntryKey tableEntryKey = this.connectionKey.createTableEntryKey(table);
        DruidDataSource dataSource = isPreviousV4 ? this.sessionManager.getSystemDataSource() : this.sessionManager.getBusinessDataSource();
        return this.tableEntryExtractor.queryTableEntry(dataSource, tableEntryKey, !isPreviousV4);
    }

    public void queryPartitionsNoSys(String table, TableEntryInfo tableEntryInfo) throws Exception {
        try {
            if (this.serverMode.isPreviousV2()) {
                tableEntryInfo.setPartLevel(ObPartLevel.LEVEL_ZERO);
                return;
            }
            Pair<String, Integer> pair = this.queryPartitionLevel(table);
            if (pair == null || pair.getRight() == 0) {
                tableEntryInfo.setPartLevel(ObPartLevel.LEVEL_ZERO);
                return;
            }
            String tableId = pair.getLeft();
            int partLevel = pair.getRight();
            Map<String, Set<String>> partToSubPartMap = this.queryPartMap(tableId);
            tableEntryInfo.setPartToSubPartMaps(partToSubPartMap);
            tableEntryInfo.setPartNames(new ArrayList<String>(partToSubPartMap.keySet()));
            tableEntryInfo.setSubPartNames(partToSubPartMap.values().stream().flatMap(Collection::stream).collect(Collectors.toList()));
            if (partLevel == 2) {
                tableEntryInfo.setPartLevel(ObPartLevel.LEVEL_TWO);
                log.info("Query partition names for level-2 partitioned table: \"{}\" success. (No sys). nPartitions: {}, nSubPartitions: {}.", new Object[]{table, tableEntryInfo.getPartNames().size(), tableEntryInfo.getSubPartNames().size()});
            } else if (partLevel == 1) {
                tableEntryInfo.setPartLevel(ObPartLevel.LEVEL_ONE);
                log.info("Query partition names for level-1 partitioned table: \"{}\" success. (No sys). nPartitions: {}.", (Object)table, (Object)tableEntryInfo.getPartNames().size());
            }
        }
        catch (Exception e) {
            log.error("Query partition names for partitioned table:\" {}\" failed. (No sys). Reason: {}", (Object)table, (Object)e.getMessage());
            throw new IllegalStateException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Pair<String, Integer> queryPartitionLevel(String tableName) throws Exception {
        try (Connection conn = this.sessionManager.getPooledBizConnection();){
            Object[] args = new Object[]{tableName, this.connectionKey.getDatabase()};
            Pair pair = JdbcExecutor.query(conn, this.getQueryPartitionLevelSql(), args, rs -> {
                if (rs.next()) {
                    int partLevel = rs.getInt("part_level");
                    log.info("Query partition level for table: \"{}\" success. Partition level: {}", (Object)tableName, (Object)partLevel);
                    return new Pair<String, Integer>(rs.getString("table_id"), partLevel);
                }
                log.warn("Partition level of table: \"{}\" is null. It will be dumped as non-partitioned table", (Object)tableName);
                return null;
            });
            return pair;
        }
        catch (Exception e) {
            log.error("Query partition level for table: \"{}\" failed. Reason: {}", (Object)tableName, (Object)e.getMessage());
            throw new IllegalStateException(e);
        }
    }

    protected abstract Map<String, Set<String>> queryPartMap(String var1) throws Exception;

    protected abstract String getQueryPartitionLevelSql();

    protected abstract String getQueryTablePartitionsSql(int var1);

    public AbstractPartitionHelper() {
    }

    public TableEntryExtractor getTableEntryExtractor() {
        return this.tableEntryExtractor;
    }
}

