/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.dumper.task.helper;

import com.google.common.collect.Sets;
import com.oceanbase.tools.loaddump.common.model.ConnectionKey;
import com.oceanbase.tools.loaddump.dumper.task.helper.AbstractPartitionHelper;
import com.oceanbase.tools.loaddump.jdbc.JdbcExecutor;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MySqlPartitionHelper
extends AbstractPartitionHelper {
    private static final Logger log = LoggerFactory.getLogger(MySqlPartitionHelper.class);
    static final String QUERY_TABLE_PARTITIONS_LEVEL_MYSQL_1 = "select t.table_id,t.part_level from oceanbase.__all_table t,oceanbase.__all_database d where t.table_name=? and d.database_name=? and t.database_id=d.database_id";
    static final String QUERY_TABLE_PARTITIONS_LEVEL_MYSQL_2 = "select t.table_id, t.part_level from oceanbase.__all_table_v2 t,oceanbase.__all_database d where t.table_name=? and d.database_name=? and t.database_id=d.database_id";
    static final String QUERY_TABLE_PARTITIONS_MYSQL = "select part_name from oceanbase.__all_part where table_id=?";
    static final String QUERY_TABLE_SUB_PARTITIONS_MYSQL = "select sub_part_name as part_name from oceanbase.__all_sub_part where table_id=?";
    static final String QUERY_ALL_PARTITION_NAMES = "SELECT p.part_name, sp.sub_part_name FROM oceanbase.__all_part p LEFT JOIN oceanbase.__all_sub_part sp ON p.part_id = sp.part_id AND p.table_id = sp.table_id WHERE p.table_id = ?";

    public MySqlPartitionHelper(ConnectionKey connectionKey) {
        super(connectionKey);
    }

    @Override
    protected String getQueryPartitionLevelSql() {
        return this.serverMode.isPreviousV2270() || !this.serverMode.isPreviousV4() ? QUERY_TABLE_PARTITIONS_LEVEL_MYSQL_1 : QUERY_TABLE_PARTITIONS_LEVEL_MYSQL_2;
    }

    @Override
    protected String getQueryTablePartitionsSql(int partLevel) {
        return partLevel == 1 ? QUERY_TABLE_PARTITIONS_MYSQL : QUERY_TABLE_SUB_PARTITIONS_MYSQL;
    }

    @Override
    protected Map<String, Set<String>> queryPartMap(String tableId) throws Exception {
        try (Connection conn = this.sessionManager.getPooledBizConnection();){
            Map<String, Set<String>> map = JdbcExecutor.queryMap(conn, QUERY_ALL_PARTITION_NAMES, new Object[]{tableId}, rs -> {
                HashMap<String, Set> m = new HashMap<String, Set>();
                while (rs.next()) {
                    String partName = rs.getString("part_name");
                    String subPartName = rs.getString("sub_part_name");
                    Set subParts = m.computeIfAbsent(partName, t -> Sets.newHashSet());
                    if (subPartName == null) continue;
                    subParts.add(subPartName);
                }
                return m;
            });
            return map;
        }
    }

    public MySqlPartitionHelper() {
    }
}

