/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.dumper.task.record;

import com.google.common.base.Stopwatch;
import com.oceanbase.tools.loaddump.common.enums.DataFormat;
import com.oceanbase.tools.loaddump.common.model.TaskState;
import com.oceanbase.tools.loaddump.dumper.merge.CsvFileMerger;
import com.oceanbase.tools.loaddump.dumper.merge.FileMerger;
import com.oceanbase.tools.loaddump.dumper.merge.FlatFileMerger;
import com.oceanbase.tools.loaddump.dumper.merge.OrcFileMerger;
import com.oceanbase.tools.loaddump.dumper.merge.ParquetFileMerger;
import com.oceanbase.tools.loaddump.dumper.writer.AbstractRollingFileWriterV2;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileMergeTask
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(FileMergeTask.class);
    private static final String MERGE_FILE_TMP_SUFFIX = "mtmp";
    private FileMerger fileMerger;
    private String errorMsg;
    private TaskState taskState;
    private int processedDumpTaskCount = 0;
    private final String fileName;
    private final int dumpTaskCount;
    private final String outputDirPath;
    private final Long blockSizeBytes;
    private final Long blockRows;
    private final AtomicBoolean supervisor;
    private final String fileEncoding;
    private final String fileSuffix;
    private final AtomicLong fileCounter = new AtomicLong(0L);
    private final DataFormat dataFormat;
    private final Set<String> mergedPaths = new HashSet<String>();
    private final BlockingQueue<List<AbstractRollingFileWriterV2.FileMetaInfo>> pendingFilesQueue;

    public FileMergeTask(String fileName, Long blockSizeBytes, Integer blockRows, AtomicBoolean supervisor, String fileEncoding, int dumpTaskCount, String outputDirPath, DataFormat dataFormat, String fileSuffix) {
        this.fileName = fileName;
        this.dumpTaskCount = dumpTaskCount;
        this.supervisor = supervisor;
        this.dataFormat = dataFormat;
        this.outputDirPath = outputDirPath;
        this.taskState = TaskState.INITIAL;
        this.blockSizeBytes = blockSizeBytes;
        this.fileSuffix = fileSuffix;
        this.fileEncoding = fileEncoding;
        this.blockRows = (long)blockRows;
        this.pendingFilesQueue = new LinkedBlockingDeque<List<AbstractRollingFileWriterV2.FileMetaInfo>>(Integer.MAX_VALUE);
    }

    private void initFileMerger() {
        switch (this.dataFormat) {
            case ORC: {
                this.fileMerger = new OrcFileMerger(this.blockSizeBytes, this.blockRows);
                break;
            }
            case PAR: {
                this.fileMerger = new ParquetFileMerger(this.blockSizeBytes, this.blockRows);
                break;
            }
            case CSV: {
                this.fileMerger = new CsvFileMerger(this.fileEncoding, this.blockSizeBytes, this.blockRows);
                break;
            }
            default: {
                this.fileMerger = new FlatFileMerger(this.blockSizeBytes, this.blockRows);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            while (this.processedDumpTaskCount < this.dumpTaskCount && this.supervisor.get()) {
                List<AbstractRollingFileWriterV2.FileMetaInfo> fileMetas = this.pendingFilesQueue.take().stream().filter(i -> i.isDone() && !this.mergedPaths.contains(i.getFilePath())).collect(Collectors.toList());
                String filePaths = fileMetas.stream().map(AbstractRollingFileWriterV2.FileMetaInfo::getFilePath).collect(Collectors.joining(",\n\t"));
                if (this.fileMerger == null) {
                    this.initFileMerger();
                    this.taskState = TaskState.RUNNING;
                }
                Stopwatch stopWatch = Stopwatch.createStarted();
                this.mergedPaths.addAll(fileMetas.stream().map(AbstractRollingFileWriterV2.FileMetaInfo::getFilePath).collect(Collectors.toSet()));
                this.fileMerger.merge(() -> this.outputDirPath + File.separator + this.generateNextMergeFileName(), fileMetas);
                this.deleteUselessFiles(fileMetas);
                ++this.processedDumpTaskCount;
                if (!CollectionUtils.isNotEmpty(fileMetas)) continue;
                log.info("Merge file '{}' of table '{}' finished. Elapsed: {}. Remain: [{}/{}]", new Object[]{filePaths, this.fileName, stopWatch, this.dumpTaskCount - this.processedDumpTaskCount, this.dumpTaskCount});
            }
            if (!this.supervisor.get()) {
                throw new InterruptedException("File merge task has been interrupted");
            }
            this.closeFileMerger();
            this.renameMergedFiles();
            this.taskState = TaskState.SUCCESS;
        }
        catch (Throwable t) {
            this.taskState = TaskState.FAILURE;
            this.errorMsg = ExceptionUtils.getRootCauseMessage((Throwable)t);
            log.error("Merge table '{}' dumped files failed.", (Object)this.fileName, (Object)t);
        }
        finally {
            this.closeFileMerger();
        }
    }

    public synchronized void addPendingFile(List<AbstractRollingFileWriterV2.FileMetaInfo> filePaths) throws InterruptedException {
        this.pendingFilesQueue.put(filePaths);
    }

    public boolean isFinished() {
        return this.taskState == TaskState.SUCCESS || this.taskState == TaskState.FAILURE;
    }

    public boolean isSuccess() {
        return this.taskState == TaskState.SUCCESS;
    }

    private String generateNextMergeFileName() {
        long count = this.fileCounter.getAndIncrement();
        if (count == 0L) {
            return this.fileName + this.fileSuffix + "." + MERGE_FILE_TMP_SUFFIX;
        }
        return this.fileName + "." + (count - 1L) + this.fileSuffix + "." + MERGE_FILE_TMP_SUFFIX;
    }

    private void closeFileMerger() {
        if (this.fileMerger != null && this.taskState != TaskState.SUCCESS) {
            try {
                this.fileMerger.close();
            }
            catch (Exception e) {
                this.errorMsg = ExceptionUtils.getRootCauseMessage((Throwable)e);
                throw new RuntimeException(e);
            }
        }
    }

    private void renameMergedFiles() throws IOException {
        List<String> toBeRenamed = this.fileMerger.getToPaths();
        if (CollectionUtils.isEmpty(toBeRenamed)) {
            return;
        }
        for (String renameItem : toBeRenamed) {
            File item = new File(renameItem);
            int index = item.getAbsolutePath().lastIndexOf(MERGE_FILE_TMP_SUFFIX);
            if (index <= 0) continue;
            File target = new File(item.getAbsolutePath().substring(0, index - 1));
            if (target.exists()) {
                log.debug("Target file \"{}\" already exists, delete it.", (Object)target.getAbsolutePath());
                FileUtils.forceDelete((File)target);
            }
            Files.move(item.toPath(), target.toPath(), new CopyOption[0]);
        }
    }

    private void deleteUselessFiles(List<AbstractRollingFileWriterV2.FileMetaInfo> fileMetaInfoList) throws IOException {
        for (AbstractRollingFileWriterV2.FileMetaInfo fileMetaInfo : fileMetaInfoList) {
            FileUtils.forceDelete((File)new File(fileMetaInfo.getFilePath()));
        }
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public TaskState getTaskState() {
        return this.taskState;
    }
}

