/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.dumper.task.record;

import com.google.common.base.Preconditions;
import com.oceanbase.jdbc.JDBC4ResultSet;
import com.oceanbase.tools.loaddump.common.JavaOpts;
import com.oceanbase.tools.loaddump.common.enums.DataFormat;
import com.oceanbase.tools.loaddump.common.enums.ObjectType;
import com.oceanbase.tools.loaddump.common.enums.TaskType;
import com.oceanbase.tools.loaddump.common.model.AdvancedOption;
import com.oceanbase.tools.loaddump.common.model.ColumnInfo;
import com.oceanbase.tools.loaddump.common.model.DumpParameter;
import com.oceanbase.tools.loaddump.common.model.RangeKey;
import com.oceanbase.tools.loaddump.common.model.TableInfo;
import com.oceanbase.tools.loaddump.common.model.TableRangeInfo;
import com.oceanbase.tools.loaddump.common.model.TaskState;
import com.oceanbase.tools.loaddump.common.unit.BinarySizeUnit;
import com.oceanbase.tools.loaddump.control.ControlDescription;
import com.oceanbase.tools.loaddump.control.ControlManager;
import com.oceanbase.tools.loaddump.control.function.AbstractUserDefinedFunction;
import com.oceanbase.tools.loaddump.control.function.SqlFunction;
import com.oceanbase.tools.loaddump.dumper.assembler.AbstractStatementAssembler;
import com.oceanbase.tools.loaddump.dumper.task.AbstractDumpTask;
import com.oceanbase.tools.loaddump.dumper.task.record.FileMergeTask;
import com.oceanbase.tools.loaddump.dumper.translator.AbstractRecordTranslator;
import com.oceanbase.tools.loaddump.dumper.translator.ColRecordTranslator;
import com.oceanbase.tools.loaddump.dumper.translator.CsvRecordTranslator;
import com.oceanbase.tools.loaddump.dumper.translator.CutRecordTranslator;
import com.oceanbase.tools.loaddump.dumper.translator.PosRecordTranslator;
import com.oceanbase.tools.loaddump.dumper.translator.SqlRecordTranslator;
import com.oceanbase.tools.loaddump.dumper.writer.AbstractRollingFileWriterV2;
import com.oceanbase.tools.loaddump.dumper.writer.CsvWriter;
import com.oceanbase.tools.loaddump.metrics.Meter;
import com.oceanbase.tools.loaddump.parser.record.csv.CsvFormat;
import com.oceanbase.tools.loaddump.parser.record.csv.CsvPrinter;
import com.oceanbase.tools.loaddump.utils.CollectionUtils;
import com.oceanbase.tools.loaddump.utils.SqlNotesUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecordDumpTask
extends AbstractDumpTask {
    private static final Logger log = LoggerFactory.getLogger(RecordDumpTask.class);
    private static final long serialVersionUID = 2223238398433917159L;
    protected int commitSize;
    protected long maxFileSize;
    protected int fetchSize;
    protected boolean emptyTable;
    protected boolean customQuery;
    protected Integer maxRows;
    protected boolean retainEmptyFile;
    protected AdvancedOption option;
    protected TableRangeInfo tableRangeInfo;
    protected transient Meter meter;
    protected transient CsvFormat csvFormat;
    protected transient AbstractStatementAssembler assembler;
    protected transient AbstractRollingFileWriterV2 fileWriter;
    protected transient String outputDirPath;
    protected transient FileMergeTask fileMergeTask;
    protected transient AbstractRecordTranslator<?> recordTranslator;
    private transient AtomicLong fileSizeAccumulator;
    private transient AtomicInteger recordCountAccumulator;

    public RecordDumpTask(String tableName, AbstractStatementAssembler assembler) {
        this(tableName, assembler, false);
    }

    public RecordDumpTask(boolean emptyTable, String tableName, AbstractStatementAssembler assembler) {
        this(tableName, assembler);
        this.emptyTable = emptyTable;
    }

    public RecordDumpTask(String tableName, AbstractStatementAssembler assembler, boolean emptyTable) {
        this.emptyTable = emptyTable;
        this.assembler = assembler;
        this.maxFileSize = assembler.getParameter().getMaxFileSize();
        this.tableRangeInfo = assembler.getTableRangeInfo();
        this.schemaName = assembler.getParameter().getDatabaseName();
        this.objectName = tableName;
    }

    @Override
    public void initialize(DumpParameter parameter) throws Exception {
        super.initialize(parameter);
        this.option = new AdvancedOption(parameter, this.serverMode);
        this.commitSize = parameter.getCommitSize();
        this.fetchSize = parameter.getFetchSize();
        this.checkpointPath = parameter.getCheckpointPath();
        this.recordTranslator = this.createRecordTranslator(parameter);
        this.customQuery = StringUtils.isNotBlank((CharSequence)parameter.getQuerySql());
        this.maxRows = parameter.getMaxRows();
        this.retainEmptyFile = parameter.isRetainEmptyFiles();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.updateTaskState(TaskState.RUNNING);
            if (!this.emptyTable) {
                try (Connection conn = this.sessionManager.createNewConnection();){
                    this.executeAsync(conn, this.assembler.assembleQuerySql());
                }
            }
            this.updateTaskState(TaskState.SUCCESS);
        }
        catch (Throwable e) {
            this.handleException(e);
        }
        finally {
            try {
                this.fileWriter.markDone();
                if (this.fileMergeTask != null) {
                    this.fileMergeTask.addPendingFile(this.fileWriter.getFileName2MetaInfo().values().stream().filter(AbstractRollingFileWriterV2.FileMetaInfo::isDone).collect(Collectors.toList()));
                }
            }
            catch (Exception e) {
                this.handleException(e);
            }
            this.updateTaskDetail();
        }
    }

    private void handleException(Throwable e) {
        if (StringUtils.isEmpty((CharSequence)this.message)) {
            this.message = ExceptionUtils.getRootCauseMessage((Throwable)e);
        }
        log.error("Dump {} failed.", (Object)this.getTablePartition(), (Object)e);
        this.updateTaskState(TaskState.FAILURE);
    }

    private void executeAsync(Connection conn, List<String> querySqlList) {
        boolean hasValues = !this.customQuery && this.tableRangeInfo.hasPrimary();
        block26: for (int i = 0; this.supervisor.get() && i < querySqlList.size(); ++i) {
            long begin = 0L;
            if (JavaOpts.isDebugable) {
                begin = System.currentTimeMillis();
            }
            String querySql = querySqlList.get(i);
            RangeKey[] primaryValues = this.tableRangeInfo.getPrimaryValues(i);
            try (PreparedStatement ps = conn.prepareStatement(SqlNotesUtil.addLoaderDumperNotes(querySql), 1003, 1007);){
                ps.setFetchSize(this.fetchSize);
                if (this.maxRows != null && this.maxRows > 0) {
                    ps.setMaxRows(this.maxRows);
                }
                for (int idx = 0; idx < primaryValues.length; ++idx) {
                    ps.setObject(idx + 1, primaryValues[idx].getValue());
                }
                try (ResultSet rs = ps.executeQuery();){
                    if (JavaOpts.isDebugable) {
                        String range = Arrays.stream(primaryValues).map(RangeKey::getValue).collect(Collectors.joining(","));
                        log.info("Query SQL: {}. Range: [{}]. Elapsed: {}ms", new Object[]{querySql, range, System.currentTimeMillis() - begin});
                    }
                    boolean isInitiated = true;
                    while (this.supervisor.get() && rs.next()) {
                        if (isInitiated) {
                            this.reassignParams(rs);
                            isInitiated = false;
                        }
                        if (this.exceedsLimit()) {
                            if (!(rs instanceof JDBC4ResultSet)) break block26;
                            ((JDBC4ResultSet)rs).abort();
                            break block26;
                        }
                        Object record = this.recordTranslator.translate(rs, this.customQuery);
                        if (JavaOpts.isDryRunMode) {
                            this.meter.mark(1L, record.toString().getBytes().length, 1L);
                            continue;
                        }
                        long size = this.fileWriter.write(record);
                        this.meter.mark(1L, size, 1L);
                        ++this.recordCount;
                        this.fileSizeAccumulator.addAndGet(size);
                    }
                    continue;
                }
            }
            catch (Exception e) {
                String range = hasValues ? Arrays.stream(primaryValues).map(RangeKey::getValue).collect(Collectors.joining(",")) : "[--]";
                log.error("Dump failed. SQL: {}. Range: {}.", new Object[]{querySql, range, e});
                throw new IllegalStateException(e);
            }
        }
    }

    private boolean exceedsLimit() {
        if (this.maxRows != null && this.maxRows > 0 && this.recordCountAccumulator.incrementAndGet() > this.maxRows) {
            log.warn("Stop dump: {} Rows: {} >= {}", new Object[]{this.getTablePartition(), this.recordCountAccumulator.decrementAndGet(), this.maxRows});
            return true;
        }
        long totalFileSize = this.fileSizeAccumulator.get();
        if (this.maxFileSize > 0L && totalFileSize >= this.maxFileSize) {
            log.warn("Stop dump: {} Size: {} >= {}", new Object[]{this.getTablePartition(), BinarySizeUnit.B.of(totalFileSize), BinarySizeUnit.B.of(this.maxFileSize)});
            return true;
        }
        return false;
    }

    private AbstractRecordTranslator<?> createRecordTranslator(DumpParameter parameter) {
        AbstractRecordTranslator recordTranslator;
        TableInfo tableInfo = parameter.getDatabase().getTableInfo(this.objectName);
        ControlManager controlManager = parameter.getControlManager();
        if (DataFormat.SQL == parameter.getDataFormat()) {
            recordTranslator = new SqlRecordTranslator(tableInfo, controlManager);
        } else if (DataFormat.CSV == parameter.getDataFormat()) {
            recordTranslator = new CsvRecordTranslator(tableInfo, controlManager, this.csvFormat);
        } else if (DataFormat.CUT == parameter.getDataFormat()) {
            recordTranslator = new CutRecordTranslator(tableInfo, controlManager, this.csvFormat, parameter.getColumnSplitter(), parameter.isRemoveNewline());
        } else if (parameter.getDataFormat().isBinary()) {
            recordTranslator = new ColRecordTranslator(tableInfo, controlManager);
        } else if (DataFormat.POS == parameter.getDataFormat()) {
            Preconditions.checkArgument((boolean)controlManager.isControlDefined(this.schemaName, tableInfo.getTable()), (Object)("Exporting file of fixed-length format requires a control file for the corresponding table: " + tableInfo.getTable()));
            recordTranslator = new PosRecordTranslator(tableInfo, controlManager, this.csvFormat.getRecordSeparator(), parameter.getFileEncoding(), parameter.isRemoveNewline());
        } else {
            throw new UnsupportedOperationException("Unsupported data format: " + (Object)((Object)parameter.getDataFormat()));
        }
        recordTranslator.setUseRuntimeTableName(parameter.isUseRuntimeTableName());
        return recordTranslator;
    }

    private void reassignParams(ResultSet rs) throws Exception {
        ControlManager controlManager;
        this.recordTranslator.init(rs, this.customQuery);
        if (this.fileWriter instanceof CsvWriter) {
            this.assignCsvHeader(rs);
        }
        if (!this.customQuery) {
            return;
        }
        boolean useRuntimeName = this.recordTranslator.isUseRuntimeTableName();
        TableInfo tableInfo = this.recordTranslator.getTableInfo();
        tableInfo.resetTableInfo(rs, this.serverMode, useRuntimeName, this.option);
        if (this.recordTranslator instanceof SqlRecordTranslator) {
            ((SqlRecordTranslator)this.recordTranslator).setInsertPrefix(tableInfo.getInsertPrefix().toString() + " VALUES (");
        }
        if (Objects.isNull(controlManager = this.recordTranslator.getControlManager())) {
            return;
        }
        String schemaName = tableInfo.getSchema();
        String tableName = tableInfo.getTable();
        for (ColumnInfo columnInfo : tableInfo.getColumnInfoList()) {
            List<SqlFunction> callStacks;
            ControlDescription control;
            String columnName = columnInfo.getColumnName();
            if (useRuntimeName) {
                schemaName = columnInfo.getSchemaName();
                tableName = columnInfo.getTableName();
            }
            if (Objects.isNull(control = controlManager.getControl(schemaName, tableName, columnName)) || CollectionUtils.isEmpty(callStacks = control.getCallStacks())) continue;
            for (SqlFunction sqlFunction : callStacks) {
                if (!(sqlFunction instanceof AbstractUserDefinedFunction)) continue;
                HashMap<String, Object> paramMap = new HashMap<String, Object>();
                paramMap.put("column_name", columnName);
                paramMap.put("table_name", tableName);
                paramMap.put("data_type", tableInfo.getColumnType(columnName));
                ((AbstractUserDefinedFunction)sqlFunction).setParams(paramMap);
            }
        }
    }

    @Override
    protected void updateTaskDetail() {
        this.taskDetail.setSchema(this.schemaName);
        this.taskDetail.setObject(this.objectName);
        this.taskDetail.setType(ObjectType.TABLE.getName());
        this.taskDetail.setCount(this.recordCount);
        this.taskDetail.setState(this.taskState);
        this.taskDetail.setError(this.message);
        this.taskDetail.setTaskType(TaskType.DUMP_RECORD);
    }

    private void assignCsvHeader(ResultSet rs) throws Exception {
        if (this.csvFormat.getSkipHeaderRecord()) {
            return;
        }
        if (this.customQuery) {
            this.csvFormat = this.csvFormat.withHeader(rs);
        }
        StringBuilder headerBuilder = new StringBuilder(48);
        try (CsvPrinter ignored = new CsvPrinter(headerBuilder, this.csvFormat);){
            ((CsvWriter)((Object)this.fileWriter)).setCsvHeader(headerBuilder.toString());
        }
    }

    public void setMeter(Meter meter) {
        this.meter = meter;
    }

    public void setCsvFormat(CsvFormat csvFormat) {
        this.csvFormat = csvFormat;
    }

    public void setFileWriter(AbstractRollingFileWriterV2 fileWriter) {
        this.fileWriter = fileWriter;
    }

    public void setOutputDirPath(String outputDirPath) {
        this.outputDirPath = outputDirPath;
    }

    public String getOutputDirPath() {
        return this.outputDirPath;
    }

    public void setFileMergeTask(FileMergeTask fileMergeTask) {
        this.fileMergeTask = fileMergeTask;
    }

    public void setFileSizeAccumulator(AtomicLong fileSizeAccumulator) {
        this.fileSizeAccumulator = fileSizeAccumulator;
    }

    public void setRecordCountAccumulator(AtomicInteger recordCountAccumulator) {
        this.recordCountAccumulator = recordCountAccumulator;
    }
}

