/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.dumper.task.schema;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.oceanbase.tools.loaddump.common.JavaOpts;
import com.oceanbase.tools.loaddump.common.enums.DbType;
import com.oceanbase.tools.loaddump.common.enums.ObjectType;
import com.oceanbase.tools.loaddump.configure.Configure;
import com.oceanbase.tools.loaddump.dumper.task.schema.ObOracleSchemaDumpTask;
import com.oceanbase.tools.loaddump.jdbc.JdbcTemplate;
import com.oceanbase.tools.loaddump.schema.model.CreateObjectDefine;
import com.oceanbase.tools.loaddump.schema.model.ObjectDefine;
import com.oceanbase.tools.loaddump.utils.CollectionUtils;
import com.oceanbase.tools.loaddump.utils.StringUtils;
import com.oceanbase.tools.sqlparser.OBOracleSQLParser;
import com.oceanbase.tools.sqlparser.statement.createtable.CreateTable;
import java.io.Reader;
import java.io.StringReader;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObOracleCompactSchemaDumpTask
extends ObOracleSchemaDumpTask {
    private static final Logger log = LoggerFactory.getLogger(ObOracleCompactSchemaDumpTask.class);
    private static final long serialVersionUID = -1430858198704696204L;
    private static final String QUERY_TABLE_COMMENTS = "SELECT REPLACE(COMMENTS,'''', '''''') AS COMMENTS FROM ALL_TAB_COMMENTS WHERE OWNER=? AND TABLE_TYPE=? AND TABLE_NAME=?";
    private static final String QUERY_COLUMN_COMMENTS = "SELECT COLUMN_NAME,REPLACE(COMMENTS,'''', '''''') AS COMMENTS FROM ALL_COL_COMMENTS WHERE OWNER=? AND TABLE_NAME=? AND COLUMN_NAME NOT IN ('__pk_increment','__pk_cluster_id','__pk_partition_id')";
    private static final String QUERY_INDEX = "SELECT DBMS_METADATA.GET_DDL('INDEX',?,?) FROM DUAL";
    private static final Pattern FIND_NAME_IN_CREATE_INDEX_PATTERN = Pattern.compile("\"[^\"]+\"\\.\"([^\"]+)\"");

    @Override
    public List<ObjectDefine> dumpSchema(Configure configure) throws Exception {
        if (this.objectType.equalsIgnoreCase(ObjectType.TABLE.getName()) || this.objectType.equalsIgnoreCase(ObjectType.TABLE_GROUP.getName())) {
            return this.showCreateTableOrTableGroup(configure);
        }
        return super.dumpSchema(configure);
    }

    private List<ObjectDefine> showCreateTableOrTableGroup(Configure configure) throws SQLException {
        JdbcTemplate jdbc = new JdbcTemplate(configure.getSessionManager());
        boolean isPrevious225 = this.serverMode.isPreviousV2250();
        DbType dbType = DbType.valueOf(this.serverMode.name(), this.serverMode.getVersion());
        ArrayList<ObjectDefine> list = new ArrayList<ObjectDefine>();
        for (Map.Entry entry : this.whiteListMap.entrySet()) {
            if (CollectionUtils.isEmpty((Collection)((Collection)entry.getValue()))) continue;
            ObjectType objectType = (ObjectType)((Object)entry.getKey());
            boolean isTable = objectType.equals((Object)ObjectType.TABLE);
            for (String objectName : (Set)entry.getValue()) {
                String tableGrammar = this.queryTableGrammar(jdbc, objectType.getName(), objectName);
                ArrayList subObjectDefines = Lists.newArrayList();
                if (isTable) {
                    if (JavaOpts.enableTableComment.booleanValue()) {
                        subObjectDefines.addAll(this.queryTableComment(jdbc, objectName));
                    }
                    if (JavaOpts.enableTableColumnComment.booleanValue()) {
                        subObjectDefines.addAll(this.queryColumnComment(jdbc, objectName));
                    }
                    if (!isPrevious225 && JavaOpts.enableTableIndex.booleanValue()) {
                        subObjectDefines.addAll(this.queryIndexes(jdbc, objectName, tableGrammar));
                    }
                }
                list.add(new CreateObjectDefine(objectType, objectName, tableGrammar, subObjectDefines));
            }
        }
        log.info("Query {} schema success. DbType: {} Version: {}", new Object[]{this.objectType, dbType.getType(), dbType.getRealVersion()});
        return list;
    }

    private String queryTableGrammar(JdbcTemplate jdbc, String objectType, String objectName) throws SQLException {
        String sql = "show create " + objectType + " \"" + objectName.replace("\"", "\"\"") + "\"";
        return jdbc.query(sql, null, rs -> rs.next() ? rs.getString(2) + ";" : "");
    }

    private Collection<ObjectDefine> queryTableComment(JdbcTemplate jdbc, String objectName) throws SQLException {
        Object[] args = new Object[]{this.schemaName, ObjectType.TABLE.getName(), objectName};
        String tableColumnComment = jdbc.query(QUERY_TABLE_COMMENTS, args, rs -> {
            String tableComment;
            if (rs.next() && (tableComment = rs.getString("COMMENTS")) != null) {
                StringBuilder sb = new StringBuilder(tableComment.length() + 64);
                sb.append("COMMENT ON TABLE ").append(this.serverMode.wrapName(objectName)).append(" IS '").append(tableComment).append("';");
                return sb.toString();
            }
            return "";
        });
        if (StringUtils.isBlank(tableColumnComment)) {
            return Lists.newArrayList();
        }
        return Lists.newArrayList((Object[])new ObjectDefine[]{new CreateObjectDefine(ObjectType.TABLE, objectName, tableColumnComment)});
    }

    private Collection<ObjectDefine> queryColumnComment(JdbcTemplate jdbc, String objectName) throws SQLException {
        Object[] args = new Object[]{this.schemaName, objectName};
        return jdbc.queryList(QUERY_COLUMN_COMMENTS, args, rs -> {
            ArrayList<CreateObjectDefine> columnComments = new ArrayList<CreateObjectDefine>();
            while (rs.next()) {
                String comment = rs.getString("COMMENTS");
                if (comment == null) continue;
                String columnName = rs.getString("COLUMN_NAME");
                StringBuilder sb = new StringBuilder(columnName.length() + 64);
                sb.append("COMMENT ON COLUMN ");
                sb.append(this.serverMode.wrapName(objectName)).append(".").append(this.serverMode.wrapName(columnName));
                sb.append(" IS '").append(comment).append("';");
                columnComments.add(new CreateObjectDefine(ObjectType.TABLE, objectName, sb.toString()));
            }
            return columnComments;
        });
    }

    private Collection<ObjectDefine> queryIndexes(JdbcTemplate jdbc, String objectName, String tableGrammar) throws SQLException {
        HashSet indexNames = Sets.newHashSet(this.connectionKey.getMetadataProvider().queryObOracleIndexNames(this.schemaName, objectName));
        ArrayList<ObjectDefine> indexDefines = new ArrayList<ObjectDefine>(indexNames.size());
        if (CollectionUtils.isEmpty((Collection)indexNames)) {
            return indexDefines;
        }
        Set<String> indexesInTable = this.getIndexesFromTableGrammar(tableGrammar);
        for (String indexName : indexNames) {
            if (indexesInTable.contains(indexName)) continue;
            Object[] args2 = new Object[]{indexName, this.schemaName};
            String indexGrammar = jdbc.query(QUERY_INDEX, args2, rs -> rs.next() ? rs.getString(1) : "");
            if (!this.retainSchema) {
                indexGrammar = this.trailSchemaPrefix(indexGrammar);
            }
            indexDefines.add(new CreateObjectDefine(ObjectType.INDEX, objectName, indexGrammar));
        }
        return indexDefines;
    }

    private Set<String> getIndexesFromTableGrammar(String tableGrammar) {
        HashSet<String> indexesInTable = new HashSet<String>();
        try {
            CreateTable createTable = (CreateTable)new OBOracleSQLParser().parse((Reader)new StringReader(tableGrammar));
            createTable.getIndexes().forEach(outOfLineIndex -> {
                String idxName = outOfLineIndex.getIndexName();
                if (idxName != null) {
                    indexesInTable.add(StringUtils.unquoteSqlIdentifier(idxName, this.serverMode));
                }
            });
            createTable.getConstraints().forEach(constraint -> {
                String indexName;
                String string = indexName = constraint.getConstraintName() != null ? constraint.getConstraintName() : constraint.getIndexName();
                if (indexName != null) {
                    indexesInTable.add(StringUtils.unquoteSqlIdentifier(indexName, this.serverMode));
                }
            });
            return indexesInTable;
        }
        catch (Exception e) {
            log.error("Failed to parse table definition to obtain index constraint in Oracle mode. Error: {}", (Object)e.getMessage());
            return indexesInTable;
        }
    }

    private String trailSchemaPrefix(String ddl) {
        Matcher matcher = FIND_NAME_IN_CREATE_INDEX_PATTERN.matcher(ddl);
        StringBuffer result = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(result, "\"$1\"");
        }
        matcher.appendTail(result);
        return result.toString();
    }
}

