/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.dumper.task.schema;

import com.oceanbase.tools.loaddump.common.JavaOpts;
import com.oceanbase.tools.loaddump.common.enums.ObjectType;
import com.oceanbase.tools.loaddump.configure.Configure;
import com.oceanbase.tools.loaddump.dumper.task.schema.AbstractSchemaDumpTask;
import com.oceanbase.tools.loaddump.schema.AbstractDatabase;
import com.oceanbase.tools.loaddump.schema.accessor.MetadataAccessorFactory;
import com.oceanbase.tools.loaddump.schema.model.ObjectDefine;
import com.oceanbase.tools.loaddump.schema.oboracle.ObOracleDatabase;
import com.oceanbase.tools.loaddump.utils.CollectionUtils;
import com.oceanbase.tools.loaddump.utils.FileUtils;
import com.oceanbase.tools.loaddump.utils.JacksonUtils;
import java.io.OutputStream;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObOracleSchemaDumpTask
extends AbstractSchemaDumpTask {
    private static final Logger log = LoggerFactory.getLogger(ObOracleSchemaDumpTask.class);
    private static final long serialVersionUID = -7805047148834341264L;

    @Override
    public List<ObjectDefine> dumpSchema(Configure configure) throws Exception {
        ObOracleDatabase database = (ObOracleDatabase)this.build(configure);
        if (JavaOpts.isBackupRestoreMode && configure.getIncludeObjectTypes().contains(ObjectType.TABLE.getName())) {
            String dirPath = this.dataPath.substring(0, this.dataPath.lastIndexOf("data") - 1);
            String schemaFilePath = FileUtils.toPath(dirPath, "database.json");
            try (FSDataOutputStream os = this.fs.create(new Path(schemaFilePath));){
                IOUtils.write((String)JacksonUtils.toJsonString(database), (OutputStream)os, (String)this.fileEncoding);
            }
            log.info("Serialize database.json finished. Schema: \"{}\". File: \"{}\"", (Object)database.getSchemaName(), (Object)schemaFilePath);
        }
        return database.buildDefinition();
    }

    private AbstractDatabase build(Configure configure) throws Exception {
        if (CollectionUtils.isEmpty(configure.getIncludeObjectTypes())) {
            log.warn("Include types is empty. Ignore schema: {}", (Object)configure.getSchemaName());
            return MetadataAccessorFactory.emptyDatabase(configure);
        }
        return MetadataAccessorFactory.get(configure).queryMetadata();
    }
}

