/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.dumper.translator;

import com.google.common.base.Preconditions;
import com.oceanbase.tools.loaddump.common.model.MapObject;
import com.oceanbase.tools.loaddump.common.model.TableInfo;
import com.oceanbase.tools.loaddump.control.ControlManager;
import com.oceanbase.tools.loaddump.dumper.translator.IRecordTranslator;
import com.oceanbase.tools.loaddump.dumper.typehandler.TypeHandler;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Map;
import java.util.stream.IntStream;

public abstract class AbstractRecordTranslator<T>
implements IRecordTranslator<T> {
    protected TableInfo tableInfo;
    protected ControlManager controlManager;
    private boolean useRuntimeTableName = false;
    private int[] offsets;
    private int columnCnt;
    private ResultSetMetaData rsmd;
    private String[] columnLabels;

    protected AbstractRecordTranslator(TableInfo tableInfo, ControlManager ctrlManager) {
        this.tableInfo = tableInfo;
        this.controlManager = ctrlManager;
    }

    protected String doCleaning(String schemaName, String table, String columnName, String columnValue) {
        if (this.controlManager == null || !this.controlManager.isControlDefined(schemaName, table)) {
            return columnValue;
        }
        Map<String, MapObject> columnIndexMapping = this.tableInfo.getColumnIndexMapping();
        MapObject mapObj = columnIndexMapping.get(columnName);
        if (mapObj.getGeneratedDefine() != null) {
            return mapObj.getGeneratedDefine().getValue();
        }
        return this.controlManager.transform(schemaName, table, columnName, columnValue);
    }

    public void init(ResultSet rs, boolean customQuery) throws SQLException {
        this.rsmd = rs.getMetaData();
        this.columnCnt = this.rsmd.getColumnCount();
        this.offsets = customQuery ? IntStream.range(0, this.columnCnt).toArray() : this.getTableInfo().getLogicOffsets().stream().mapToInt(Integer::intValue).toArray();
        this.columnLabels = new String[this.columnCnt];
        for (int i = 0; i < this.columnCnt; ++i) {
            this.columnLabels[i] = this.rsmd.getColumnLabel(i + 1);
        }
    }

    @Override
    public T translate(ResultSet rs, boolean isNullable) throws Exception {
        int index = 0;
        String tableName = this.tableInfo.getTable();
        String schemaName = this.tableInfo.getSchema();
        T recordPattern = this.buildRecordPattern(this.columnCnt);
        while (index < this.columnCnt) {
            TypeHandler<?> typeHandler;
            int rsIdx = index + 1;
            String columnName = this.columnLabels[index];
            if (this.useRuntimeTableName) {
                tableName = this.rsmd.getTableName(rsIdx);
                schemaName = this.rsmd.getCatalogName(rsIdx);
            }
            if ((typeHandler = this.tableInfo.getTypeHandler(columnName)) == null) {
                columnName = this.rsmd.getColumnName(rsIdx);
                typeHandler = this.tableInfo.getTypeHandler(columnName);
                Preconditions.checkArgument((typeHandler != null ? 1 : 0) != 0, (String)"No appropriate type handler was found. Column: %s", (Object)columnName);
            }
            Object result = isNullable ? typeHandler.getNullableResult(rs, rsIdx) : typeHandler.getResult(rs, rsIdx);
            String columnValue = result == null ? null : result.toString();
            columnValue = this.doCleaning(schemaName, tableName, columnName, columnValue);
            this.formatRecord(recordPattern, columnValue, this.offsets[++index - 1], index < this.columnCnt);
        }
        return this.appendLineSeparator(recordPattern);
    }

    protected abstract T buildRecordPattern(int var1);

    protected abstract T appendLineSeparator(T var1);

    protected abstract T formatRecord(T var1, String var2, int var3, boolean var4);

    public TableInfo getTableInfo() {
        return this.tableInfo;
    }

    public void setTableInfo(TableInfo tableInfo) {
        this.tableInfo = tableInfo;
    }

    public ControlManager getControlManager() {
        return this.controlManager;
    }

    public boolean isUseRuntimeTableName() {
        return this.useRuntimeTableName;
    }

    public void setUseRuntimeTableName(boolean useRuntimeTableName) {
        this.useRuntimeTableName = useRuntimeTableName;
    }
}

