/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.dumper.translator;

import com.google.common.base.Strings;
import com.oceanbase.tools.loaddump.common.model.TableInfo;
import com.oceanbase.tools.loaddump.control.ControlManager;
import com.oceanbase.tools.loaddump.dumper.translator.AbstractRecordTranslator;
import com.oceanbase.tools.loaddump.parser.record.pos.Offset;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class PosRecordTranslator
extends AbstractRecordTranslator<ByteBasedStringBuilder> {
    private final List<Offset> offsets;
    private final String lineSep;
    private final Charset charset;
    private final boolean removeNewline;

    public PosRecordTranslator(TableInfo tableInfo, ControlManager ctrlManager, String lineSep, String charset, boolean removeNewline) {
        super(tableInfo, ctrlManager);
        this.offsets = this.controlManager.getOffsets(tableInfo.getSchema(), tableInfo.getTable());
        this.lineSep = lineSep;
        this.charset = Charset.forName(charset);
        this.removeNewline = removeNewline;
    }

    @Override
    protected ByteBasedStringBuilder buildRecordPattern(int columnCount) {
        return new ByteBasedStringBuilder(4096, this.charset);
    }

    @Override
    protected ByteBasedStringBuilder formatRecord(ByteBasedStringBuilder recordPattern, String columnValue, int index, boolean hasNext) {
        Offset offset = this.offsets.get(index);
        String str = this.formatFixedLengthString(columnValue, offset.getLength());
        if (offset.getType() == Offset.OffsetType.ABSOLUTE) {
            return recordPattern.replace(offset.getBeginIndex() - 1, offset.getLength(), str);
        }
        return recordPattern.append(str);
    }

    @Override
    protected ByteBasedStringBuilder appendLineSeparator(ByteBasedStringBuilder record) {
        return record.append(this.lineSep);
    }

    private String formatFixedLengthString(String input, int limits) {
        byte[] inputBytes;
        if (input == null) {
            byte[] bytes = new byte[limits];
            Arrays.fill(bytes, (byte)32);
            return new String(bytes, this.charset);
        }
        if (this.removeNewline) {
            input = input.replaceAll("[\r\n]", "");
        }
        if ((inputBytes = input.getBytes(this.charset)).length > limits) {
            int charPos = 0;
            int totalCharBytes = 0;
            char[] chars = input.toCharArray();
            for (int i = 0; i < chars.length; ++i) {
                if (Character.isSurrogate(chars[i])) {
                    if (!Character.isHighSurrogate(chars[i]) || i + 1 >= chars.length || !Character.isLowSurrogate(chars[i + 1])) continue;
                    char[] temp = new char[]{chars[i], chars[i + 1]};
                    int emojiBytes = new String(temp).getBytes(this.charset).length;
                    int tempCurrBytes = totalCharBytes + emojiBytes;
                    if (tempCurrBytes > limits) break;
                    charPos += 2;
                    totalCharBytes = tempCurrBytes;
                    continue;
                }
                int charBytes = String.valueOf(chars[i]).getBytes(this.charset).length;
                int tempCurrBytes = totalCharBytes + charBytes;
                if (tempCurrBytes > limits) break;
                ++charPos;
                totalCharBytes = tempCurrBytes;
            }
            String value = input.substring(0, charPos);
            return totalCharBytes < limits ? value + Strings.repeat((String)" ", (int)(limits - totalCharBytes)) : value;
        }
        byte[] resultBytes = new byte[limits];
        System.arraycopy(inputBytes, 0, resultBytes, 0, inputBytes.length);
        for (int i = inputBytes.length; i < limits; ++i) {
            resultBytes[i] = 32;
        }
        return new String(resultBytes, this.charset);
    }

    public static class ByteBasedStringBuilder {
        private final int capacity;
        private final Charset charset;
        private ByteBuffer buffer;

        public ByteBasedStringBuilder(int capacity, Charset charset) {
            this.charset = charset;
            this.capacity = capacity;
            this.buffer = ByteBuffer.allocate(capacity);
        }

        public ByteBasedStringBuilder append(String str) {
            if (StringUtils.isEmpty((CharSequence)str)) {
                return this;
            }
            byte[] buf = str.getBytes(this.charset);
            this.rollOverIfNeed(buf.length);
            this.buffer.put(buf);
            return this;
        }

        public ByteBasedStringBuilder replace(int offset, int length, String str) {
            Validate.isTrue((offset >= 0 ? 1 : 0) != 0);
            Validate.isTrue((length >= 0 ? 1 : 0) != 0);
            if (StringUtils.isEmpty((CharSequence)str)) {
                return this;
            }
            if (offset > this.buffer.position()) {
                throw new IndexOutOfBoundsException("offset > position()");
            }
            byte[] buf = str.getBytes(this.charset);
            int realLength = Math.min(length, buf.length);
            int tmp = realLength - this.buffer.position() + offset;
            if (tmp > 0) {
                this.rollOverIfNeed(tmp);
                this.buffer.position(offset);
                this.buffer.put(buf, 0, realLength);
            } else {
                int pos = this.buffer.position();
                this.buffer.position(offset);
                this.buffer.put(buf, 0, realLength);
                this.buffer.position(pos);
            }
            return this;
        }

        public String toString() {
            this.buffer.flip();
            byte[] strBuf = new byte[this.buffer.remaining()];
            this.buffer.get(strBuf);
            this.buffer.limit(this.buffer.capacity());
            return new String(strBuf, this.charset);
        }

        private void rollOverIfNeed(int length) {
            int leak = length - this.buffer.remaining();
            if (leak <= 0) {
                return;
            }
            ByteBuffer newBuffer = ByteBuffer.allocate(this.buffer.capacity() + Math.max(leak, this.capacity));
            this.buffer.flip();
            newBuffer.put(this.buffer);
            this.buffer = newBuffer;
        }
    }
}

