/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.dumper.typehandler;

import com.oceanbase.tools.loaddump.dumper.typehandler.BaseTypeHandler;
import java.sql.ResultSet;
import java.sql.SQLException;

public abstract class AbstractToStringTypeHandler
extends BaseTypeHandler<String> {
    private static final long serialVersionUID = -8156874307834849318L;
    private static final int ONE_MILLIS = 1000;
    private static final int ONE_MICROS = 1000000;

    @Override
    public String getNullableResult(ResultSet rs, String columnName) throws SQLException {
        throw new UnsupportedOperationException("Not implement");
    }

    @Override
    public String getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        throw new UnsupportedOperationException("Not implement");
    }

    public String formatNanoTime(int nanoValue) {
        if (nanoValue < 1) {
            return "";
        }
        if (nanoValue % 1000000 == 0) {
            return this.prependZeros(3, nanoValue / 1000000);
        }
        if (nanoValue % 1000 == 0) {
            return this.prependZeros(6, nanoValue / 1000);
        }
        return this.prependZeros(9, nanoValue);
    }

    public String prependZeros(int precision, int val) {
        char[] chars = new char[precision];
        for (int i = chars.length - 1; i >= 0; --i) {
            chars[i] = Character.forDigit(val % 10, 10);
            val /= 10;
        }
        return new String(chars);
    }
}

