/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.dumper.typehandler;

import com.oceanbase.tools.loaddump.common.constants.Constants;
import com.oceanbase.tools.loaddump.dumper.typehandler.AbstractToStringTypeHandler;
import com.oceanbase.tools.loaddump.utils.StringUtils;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.apache.commons.lang3.time.DateUtils;

public class DateTimeToStringTypeHandler
extends AbstractToStringTypeHandler {
    private static final long serialVersionUID = 4655946322100446176L;
    private static final String DEFAULT_ZERO_DATETIME_VALUE = "0000-00-00 00:00:00";
    private boolean preserveZeroDatetime;
    private boolean isMySqlMode;
    private int precision;
    private DateTimeFormatter dateTimeValueFormatter;
    private String defaultDateValue;
    private String dateFormat;

    public DateTimeToStringTypeHandler(String datetimeValuePattern, int precision, boolean preserveZeroDatetime, boolean isMySqlMode, String defaultDateValue, String dateFormat) {
        this.precision = precision;
        this.preserveZeroDatetime = preserveZeroDatetime;
        if (StringUtils.isNotBlank(datetimeValuePattern)) {
            this.dateTimeValueFormatter = DateTimeFormatter.ofPattern(datetimeValuePattern);
        }
        this.isMySqlMode = isMySqlMode;
        this.defaultDateValue = defaultDateValue;
        this.dateFormat = dateFormat;
    }

    @Override
    public String getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        return this.translateTo(rs.getTimestamp(columnIndex));
    }

    @Override
    public String getNullableResult(ResultSet rs, String columnName) throws SQLException {
        return this.translateTo(rs.getTimestamp(columnName));
    }

    @Override
    public String getResult(ResultSet rs, int columnIndex) throws SQLException {
        String result = this.getNullableResult(rs, columnIndex);
        if (result == null && rs.getMetaData().isNullable(columnIndex) == 0) {
            return this.preserveZeroDatetime ? DEFAULT_ZERO_DATETIME_VALUE : null;
        }
        return result;
    }

    @Override
    public String getResult(ResultSet rs, String columnName) throws SQLException {
        int columnIndex;
        int columnCount = rs.getMetaData().getColumnCount();
        for (columnIndex = 1; columnIndex <= columnCount && !rs.getMetaData().getColumnName(columnIndex).equals(columnName); ++columnIndex) {
        }
        return this.getResult(rs, columnIndex);
    }

    private String translateTo(Timestamp timestamp) {
        if (timestamp == null) {
            return null;
        }
        LocalDateTime ldt = timestamp.toLocalDateTime();
        return this.dateTimeValueFormatter == null ? this.localDatetimeToString(ldt) : this.dateTimeValueFormatter.format(ldt);
    }

    private String localDatetimeToString(LocalDateTime ldt) {
        StringBuilder sb = new StringBuilder(64);
        sb.append(Constants.DEFAULT_DATETIME_FORMATTER.format(ldt));
        if (this.precision == 0) {
            return sb.toString();
        }
        String nanoStr = super.formatNanoTime(ldt.getNano());
        sb.append('.').append(nanoStr);
        for (int i = this.precision - nanoStr.length(); i > 0; --i) {
            sb.append('0');
        }
        return sb.toString();
    }

    @Override
    public int setObject(Object value, int beginIndex, PreparedStatement psStmt) throws Exception {
        String parsedValue;
        if (this.defaultDateValue == null || value == null || !this.isMySqlMode) {
            return super.setObject(value, beginIndex, psStmt);
        }
        String origin = ((String)value).trim();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        try {
            parsedValue = format.format(DateUtils.parseDate((String)origin, (String[])new String[]{this.dateFormat}));
        }
        catch (Exception e) {
            parsedValue = this.defaultDateValue;
        }
        psStmt.setObject(beginIndex, parsedValue);
        return beginIndex + 1;
    }

    public DateTimeToStringTypeHandler() {
    }
}

