/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.dumper.typehandler;

import com.oceanbase.tools.loaddump.dumper.typehandler.AbstractToStringTypeHandler;
import com.oceanbase.tools.loaddump.utils.StringUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalQuery;
import java.time.temporal.ValueRange;
import lombok.NonNull;

public class TimeToStringTypeHandler
extends AbstractToStringTypeHandler {
    private static final long serialVersionUID = -2881706743781099387L;
    private static final String DEFAULT_ZERO_TIME_VALUE = "00:00:00";
    private int precision;
    private boolean preserveZeroDatetime;
    private DateTimeFormatter timeValueFormatter;

    public TimeToStringTypeHandler(String timeValuePattern, int precision, boolean preserveZeroDatetime) {
        this.precision = precision;
        this.preserveZeroDatetime = preserveZeroDatetime;
        if (StringUtils.isNotBlank(timeValuePattern)) {
            this.timeValueFormatter = DateTimeFormatter.ofPattern(timeValuePattern);
        }
    }

    @Override
    public String getNullableResult(ResultSet rs, String columnName) throws SQLException {
        return this.translateTo(rs.getString(columnName));
    }

    @Override
    public String getResult(ResultSet rs, int columnIndex) throws SQLException {
        String result = this.getNullableResult(rs, columnIndex);
        if (result == null && rs.getMetaData().isNullable(columnIndex) == 0) {
            return this.preserveZeroDatetime ? DEFAULT_ZERO_TIME_VALUE : null;
        }
        return result;
    }

    @Override
    public String getResult(ResultSet rs, String columnName) throws SQLException {
        int columnIndex;
        int columnCount = rs.getMetaData().getColumnCount();
        for (columnIndex = 1; columnIndex <= columnCount && !rs.getMetaData().getColumnName(columnIndex).equals(columnName); ++columnIndex) {
        }
        return this.getResult(rs, columnIndex);
    }

    @Override
    public String getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        return this.translateTo(rs.getString(columnIndex));
    }

    protected String translateTo(String rawValue) {
        if (rawValue == null) {
            return null;
        }
        boolean negative = rawValue.startsWith("-");
        if (negative) {
            rawValue = rawValue.substring(1);
        }
        String[] rawPart = rawValue.split(":");
        int hour = Integer.parseInt(rawPart[0]);
        int minutes = Integer.parseInt(rawPart[1]);
        int seconds = Integer.parseInt(rawPart[2].substring(0, 2));
        int nanoseconds = this.extractNanos(rawValue);
        LocalTime localTime = LocalTime.of(0, minutes, seconds, nanoseconds);
        DateTimeFormatter formatter = this.timeValueFormatter != null ? this.timeValueFormatter : DateTimeFormatter.ofPattern(this.getDefaultFormatPattern());
        String value = formatter.format(new MySQLTimeLocalTime(hour, localTime));
        return negative ? "-" + value : value;
    }

    private String getDefaultFormatPattern() {
        StringBuilder pattern = new StringBuilder("H:mm:ss");
        if (this.precision == 0) {
            return pattern.toString();
        }
        pattern.append(".");
        for (int i = 0; i < this.precision; ++i) {
            pattern.append("S");
        }
        return pattern.toString();
    }

    private int extractNanos(String timestring) {
        int index = timestring.indexOf(46);
        if (index == -1) {
            return 0;
        }
        int nanos = 0;
        for (int i = index + 1; i < index + 10; ++i) {
            int digit;
            if (i >= timestring.length()) {
                digit = 0;
            } else {
                char value = timestring.charAt(i);
                if (value < '0' || value > '9') {
                    throw new IllegalStateException("cannot parse sub-second part in timestamp string '" + timestring + "'");
                }
                digit = value - 48;
            }
            nanos = nanos * 10 + digit;
        }
        return nanos;
    }

    public TimeToStringTypeHandler() {
    }

    private static class MySQLTimeLocalTime
    implements TemporalAccessor {
        private final int hours;
        private final LocalTime delegate;

        public MySQLTimeLocalTime(int hours, @NonNull LocalTime delegate) {
            if (delegate == null) {
                throw new NullPointerException("delegate is marked non-null but is null");
            }
            this.hours = hours;
            this.delegate = delegate;
        }

        @Override
        public ValueRange range(TemporalField field) {
            return this.delegate.range(field);
        }

        @Override
        public int get(TemporalField field) {
            if (field == ChronoField.HOUR_OF_DAY) {
                return this.hours;
            }
            return this.delegate.get(field);
        }

        @Override
        public long getLong(TemporalField field) {
            if (field == ChronoField.HOUR_OF_DAY) {
                return this.hours;
            }
            return this.delegate.getLong(field);
        }

        @Override
        public <R> R query(TemporalQuery<R> query) {
            return this.delegate.query(query);
        }

        @Override
        public boolean isSupported(TemporalField field) {
            return this.delegate.isSupported(field);
        }
    }
}

