/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.dumper.typehandler;

import com.oceanbase.tools.loaddump.common.constants.Constants;
import com.oceanbase.tools.loaddump.dumper.typehandler.AbstractToStringTypeHandler;
import com.oceanbase.tools.loaddump.utils.StringUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

public class TimestampWithLocalTimeZoneToStringHandler
extends AbstractToStringTypeHandler {
    private static final long serialVersionUID = -1409710425258750679L;
    private int precision;
    private DateTimeFormatter timestampLtzValueFormatter;

    public TimestampWithLocalTimeZoneToStringHandler(String timestampLtzValuePattern, int precision) {
        this.precision = precision;
        if (StringUtils.isNotBlank(timestampLtzValuePattern)) {
            this.timestampLtzValueFormatter = DateTimeFormatter.ofPattern(timestampLtzValuePattern);
        }
    }

    @Override
    public String getNullableResult(ResultSet rs, String columnName) throws SQLException {
        return this.translateTo(rs.getTimestamp(columnName));
    }

    @Override
    public String getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        return this.translateTo(rs.getTimestamp(columnIndex));
    }

    private String translateTo(Timestamp timestamp) {
        if (timestamp == null) {
            return null;
        }
        LocalDateTime ldt = timestamp.toLocalDateTime();
        if (this.timestampLtzValueFormatter != null) {
            return this.timestampLtzValueFormatter.format(ldt);
        }
        StringBuilder sb = new StringBuilder(64);
        sb.append(Constants.DEFAULT_TIMESTAMP_LTZ_FORMATTER.format(ldt));
        if (this.precision > 0) {
            String nanoStr = super.formatNanoTime(ldt.getNano());
            sb.append('.').append(nanoStr);
            for (int i = this.precision - nanoStr.length(); i > 0; --i) {
                sb.append('0');
            }
        }
        return sb.toString();
    }
}

