/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.dumper.typehandler;

import com.oceanbase.tools.loaddump.common.model.AdvancedOption;
import com.oceanbase.tools.loaddump.common.model.datatype.DataType;
import com.oceanbase.tools.loaddump.common.model.datatype.ObTimeDataType;
import com.oceanbase.tools.loaddump.dumper.typehandler.BinaryToHexStringTypeHandler;
import com.oceanbase.tools.loaddump.dumper.typehandler.DateTimeToStringTypeHandler;
import com.oceanbase.tools.loaddump.dumper.typehandler.DateToStringTypeHandler;
import com.oceanbase.tools.loaddump.dumper.typehandler.SdoGeometryToStringTypeHandler;
import com.oceanbase.tools.loaddump.dumper.typehandler.TimeToStringTypeHandler;
import com.oceanbase.tools.loaddump.dumper.typehandler.TimestampToStringTypeHandler;
import com.oceanbase.tools.loaddump.dumper.typehandler.TimestampWithLocalTimeZoneToStringHandler;
import com.oceanbase.tools.loaddump.dumper.typehandler.TimestampWithTimeZoneToStringTypeHandler;
import com.oceanbase.tools.loaddump.dumper.typehandler.TinyintTypeHandler;
import com.oceanbase.tools.loaddump.dumper.typehandler.TypeHandler;
import com.oceanbase.tools.loaddump.dumper.typehandler.TypeHandlerRegistry;
import com.oceanbase.tools.loaddump.dumper.typehandler.YearTypeHandler;
import com.oceanbase.tools.loaddump.jdbc.JdbcType;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Locale;
import lombok.NonNull;

public class TypeHandlerFactory {
    public static TypeHandler<?> createTypeHandler(@NonNull DataType dataTypeObj, boolean isMySqlMode, @NonNull AdvancedOption option) {
        if (dataTypeObj == null) {
            throw new NullPointerException("dataTypeObj is marked non-null but is null");
        }
        if (option == null) {
            throw new NullPointerException("option is marked non-null but is null");
        }
        if (dataTypeObj instanceof ObTimeDataType) {
            int precision = ((ObTimeDataType)dataTypeObj).getPrecision();
            switch (dataTypeObj.getDataTypeName()) {
                case "date": {
                    return new DateToStringTypeHandler(option.getDateValuePattern(), isMySqlMode, option.isPreserveZeroDatetime(), option.getDefaultDateValue(), option.getDateFormat());
                }
                case "datetime": {
                    return new DateTimeToStringTypeHandler(option.getDatetimeValuePattern(), precision, option.isPreserveZeroDatetime(), isMySqlMode, option.getDefaultDateValue(), option.getDateFormat());
                }
                case "time": {
                    return new TimeToStringTypeHandler(option.getTimeValuePattern(), precision, option.isPreserveZeroDatetime());
                }
                case "timestamp": {
                    return new TimestampToStringTypeHandler(isMySqlMode, option.getTimestampValuePattern(), precision, option.isPreserveZeroDatetime());
                }
                case "timestamp with local time zone": {
                    return new TimestampWithLocalTimeZoneToStringHandler(option.getTimestampLtzValuePattern(), precision);
                }
                case "timestamp with time zone": {
                    return new TimestampWithTimeZoneToStringTypeHandler(option.getTimestampTzValuePattern(), precision);
                }
            }
        }
        String dataType = dataTypeObj.getDataTypeName();
        dataType = dataType.trim().toLowerCase(Locale.getDefault());
        TypeHandlerRegistry typeHandlerRegistry = TypeHandlerRegistry.getInstance();
        if (isMySqlMode) {
            int index = dataType.indexOf("unsigned");
            dataType = index > -1 ? dataType.substring(0, index).trim() : dataType;
        } else if ("float".equals(dataType)) {
            return typeHandlerRegistry.getTypeHandler(JdbcType.DECIMAL);
        }
        switch (dataType) {
            case "bool": 
            case "boolean": 
            case "int": 
            case "integer": 
            case "smallint": {
                if (isMySqlMode) {
                    return typeHandlerRegistry.getTypeHandler(JdbcType.BIGINT);
                }
                return typeHandlerRegistry.getTypeHandler(JdbcType.INTEGER);
            }
            case "tinyint": {
                return new TinyintTypeHandler();
            }
            case "double": {
                return typeHandlerRegistry.getTypeHandler(JdbcType.DOUBLE);
            }
            case "number": {
                if (isMySqlMode) {
                    return typeHandlerRegistry.getTypeHandler(JdbcType.DECIMAL);
                }
                return typeHandlerRegistry.getTypeHandler(JdbcType.CHAR);
            }
            case "numeric": 
            case "real": 
            case "decimal": 
            case "bigint": 
            case "bigdecimal": 
            case "binary_float": 
            case "binary_double": {
                return typeHandlerRegistry.getTypeHandler(JdbcType.DECIMAL);
            }
            case "sdo_geometry": {
                return new SdoGeometryToStringTypeHandler();
            }
            case "float": 
            case "char": 
            case "varchar": 
            case "varchar2": 
            case "json": 
            case "longvarchar": 
            case "tinytext": 
            case "text": 
            case "vector": 
            case "sparsevector": 
            case "mediumtext": 
            case "longtext": 
            case "set": 
            case "enum": 
            case "array": 
            case "map": 
            case "xmltype": 
            case "intervalym": 
            case "interval year to month": 
            case "interval year to second": 
            case "timestamp with time zone": {
                return typeHandlerRegistry.getTypeHandler(JdbcType.CHAR);
            }
            case "time": {
                return typeHandlerRegistry.getTypeHandler(Time.class);
            }
            case "timestamp": 
            case "timestamp with local time zone": 
            case "datetime": {
                return typeHandlerRegistry.getTypeHandler(Timestamp.class);
            }
            case "date": {
                return new DateToStringTypeHandler(isMySqlMode);
            }
            case "year": {
                return new YearTypeHandler(option.isPreserveZeroDatetime());
            }
            case "point": 
            case "linestring": 
            case "polygon": 
            case "multipoint": 
            case "multilinestring": 
            case "multipolygon": 
            case "geometry": 
            case "geometrycollection": 
            case "geomcollection": 
            case "bit": 
            case "raw": 
            case "longraw": 
            case "binary": 
            case "varbinary": 
            case "longvarbinary": 
            case "tinyblob": 
            case "blob": 
            case "roaringbitmap": 
            case "mediumblob": 
            case "longblob": {
                return new BinaryToHexStringTypeHandler();
            }
            case "clob": {
                return typeHandlerRegistry.getTypeHandler(JdbcType.CLOB);
            }
            case "nclob": {
                return typeHandlerRegistry.getTypeHandler(JdbcType.NCLOB);
            }
            case "cursor": {
                return typeHandlerRegistry.getTypeHandler(JdbcType.CURSOR);
            }
            case "nchar": 
            case "nvarchar": 
            case "nchar2": 
            case "nvarchar2": 
            case "longnvarchar": {
                return typeHandlerRegistry.getTypeHandler(JdbcType.NVARCHAR);
            }
        }
        return typeHandlerRegistry.getTypeHandler(JdbcType.OTHER);
    }
}

