/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.dumper.typehandler;

import com.oceanbase.tools.loaddump.dumper.typehandler.BaseTypeHandler;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Year;

public class YearTypeHandler
extends BaseTypeHandler<String> {
    private static final long serialVersionUID = 7864539688456760792L;
    private static final String DEFAULT_ZERO_YEAR_VALUE = "0000";
    private final boolean preserveZeroDatetime;

    public YearTypeHandler(boolean preserveZeroDatetime) {
        this.preserveZeroDatetime = preserveZeroDatetime;
    }

    @Override
    public String getResult(ResultSet rs, int columnIndex) throws SQLException {
        String result = this.getNullableResult(rs, columnIndex);
        if (result == null && rs.getMetaData().isNullable(columnIndex) == 0) {
            return this.preserveZeroDatetime ? DEFAULT_ZERO_YEAR_VALUE : null;
        }
        return result;
    }

    @Override
    public String getResult(ResultSet rs, String columnName) throws SQLException {
        int columnIndex;
        int columnCount = rs.getMetaData().getColumnCount();
        for (columnIndex = 1; columnIndex <= columnCount && !rs.getMetaData().getColumnName(columnIndex).equals(columnName); ++columnIndex) {
        }
        return this.getResult(rs, columnIndex);
    }

    @Override
    public String getNullableResult(ResultSet rs, String columnName) throws SQLException {
        int year = rs.getInt(columnName);
        return year == 0 && rs.wasNull() ? null : Year.of(year).toString();
    }

    @Override
    public String getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        int year = rs.getInt(columnIndex);
        return year == 0 && rs.wasNull() ? null : Year.of(year).toString();
    }
}

