/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.dumper.writer;

import com.oceanbase.tools.loaddump.common.model.storage.StorageConfig;
import com.oceanbase.tools.loaddump.dumper.writer.AbstractRollingFileWriterV2;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFsWriter
extends AbstractRollingFileWriterV2 {
    private static final Logger log = LoggerFactory.getLogger(AbstractFsWriter.class);
    protected final FileSystem fs;
    private final boolean retainEmpty;

    public AbstractFsWriter(String filePath, String fileName, String fileSuffix, boolean retainEmptyFile, long blockSize, int blockRow, int participant, StorageConfig storageConfig) {
        super(filePath, fileName, fileSuffix, blockSize, blockRow, participant, storageConfig);
        this.fs = storageConfig.getFileSystem();
        this.retainEmpty = retainEmptyFile;
    }

    @Override
    public void init() throws Exception {
        if (this.retainEmpty) {
            try {
                this.createEmptyInternal();
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot create file: " + this.currentFilePath, e);
            }
        }
    }

    @Override
    protected abstract void createEmptyInternal() throws Exception;

    @Override
    public void close() throws Exception {
        AbstractRollingFileWriterV2.FileMetaInfo fileMetaInfo;
        if (this.currentBlockRowCnt > 0L || this.retainEmpty) {
            log.info("Dump data to \"{}\" finished.", (Object)this.currentFilePath);
        }
        if ((fileMetaInfo = (AbstractRollingFileWriterV2.FileMetaInfo)this.fileName2MetaInfo.get(this.currentFilePath)) != null) {
            fileMetaInfo.setDone(true);
            fileMetaInfo.setRows(this.currentBlockRowCnt);
            fileMetaInfo.setSizeBytes(this.currentBlockSize);
        }
    }

    protected Path getFsPath() {
        this.fileName2MetaInfo.computeIfAbsent(this.currentFilePath, s -> new AbstractRollingFileWriterV2.FileMetaInfo((String)s, 0L, 0L, null, false));
        return new Path(this.currentFilePath);
    }
}

