/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.dumper.writer;

import com.oceanbase.tools.loaddump.common.model.storage.StorageConfig;
import com.oceanbase.tools.loaddump.dumper.writer.AbstractFileWriter;
import com.oceanbase.tools.loaddump.utils.FileUtils;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRollingFileWriterV2
extends AbstractFileWriter {
    private static final Logger log = LoggerFactory.getLogger(AbstractRollingFileWriterV2.class);
    protected static final long NOT_ROLL_FLAG = 0L;
    protected final AtomicInteger participant;
    protected String currentFilePath;
    protected int sequenceNo = 0;
    protected long blockSize;
    protected int blockRow;
    protected final Lock lock = new ReentrantLock();
    protected long currentBlockSize = 0L;
    protected long currentBlockRowCnt = 0L;
    protected final StorageConfig storageConfig;
    protected final Map<String, FileMetaInfo> fileName2MetaInfo = new ConcurrentHashMap<String, FileMetaInfo>();

    public AbstractRollingFileWriterV2(String filePath, String fileName, String fileSuffix, long blockSize, int blockRow, int participant, StorageConfig storageConfig) {
        super(filePath, fileName, fileSuffix);
        this.blockSize = blockSize;
        this.blockRow = blockRow;
        this.participant = new AtomicInteger(participant);
        this.storageConfig = storageConfig;
        this.currentFilePath = this.assembleSeqFilePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long write(Object line) throws Exception {
        this.lock.lock();
        try {
            long byteSize = this.writeInternal(line);
            this.currentBlockSize += byteSize;
            ++this.currentBlockRowCnt;
            if (this.blockSize != 0L && this.currentBlockSize >= this.blockSize) {
                this.rollover();
            } else if ((long)this.blockRow != 0L && this.currentBlockRowCnt >= (long)this.blockRow) {
                this.rollover();
            }
            long l = byteSize;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    protected abstract void createEmptyInternal() throws Exception;

    public void markDone() throws Exception {
        if (this.participant.decrementAndGet() == 0) {
            this.close();
        }
    }

    @Override
    public abstract void init() throws Exception;

    protected abstract long writeInternal(Object var1) throws Exception;

    protected void rollover() throws Exception {
        log.info("Dump data to \"{}\" finished.", (Object)this.currentFilePath);
        ++this.sequenceNo;
        FileMetaInfo fileMetaInfo = this.fileName2MetaInfo.get(this.currentFilePath);
        if (fileMetaInfo != null) {
            fileMetaInfo.setDone(true);
            fileMetaInfo.setRows(this.currentBlockRowCnt);
            fileMetaInfo.setSizeBytes(this.currentBlockSize);
        }
        this.currentBlockSize = 0L;
        this.currentBlockRowCnt = 0L;
        this.currentFilePath = this.assembleSeqFilePath();
    }

    protected String assembleSeqFilePath() {
        if ((long)this.blockRow == 0L && this.blockSize == 0L || this.sequenceNo == 0) {
            return this.storageConfig.getResourcePath(new Path(FileUtils.toPath(this.filePath, this.fileName + this.fileSuffix))).toString();
        }
        return this.storageConfig.getResourcePath(new Path(FileUtils.toPath(this.filePath, this.fileName + "." + (this.sequenceNo - 1) + this.fileSuffix))).toString();
    }

    public String getCurrentFilePath() {
        return this.currentFilePath;
    }

    public Map<String, FileMetaInfo> getFileName2MetaInfo() {
        return this.fileName2MetaInfo;
    }

    public static abstract class Builder {
        protected String filePath;
        protected String fileName;
        protected String fileSuffix;
        protected long blockSize;
        protected int blockRow;
        protected int participant;
        protected StorageConfig storageConfig;
        protected boolean retainEmptyFile;

        public Builder storageConfig(StorageConfig storageConfig) {
            this.storageConfig = storageConfig;
            return this;
        }

        public Builder filePath(String filePath) {
            this.filePath = filePath;
            return this;
        }

        public Builder fileName(String fileName) {
            this.fileName = fileName;
            return this;
        }

        public Builder fileSuffix(String fileSuffix) {
            this.fileSuffix = fileSuffix;
            return this;
        }

        public Builder blockSize(long blockSize) {
            this.blockSize = blockSize;
            return this;
        }

        public Builder blockRow(int blockRow) {
            this.blockRow = blockRow;
            return this;
        }

        public Builder participant(int participant) {
            this.participant = participant;
            return this;
        }

        public Builder retainEmptyFile(boolean retainEmptyFile) {
            this.retainEmptyFile = retainEmptyFile;
            return this;
        }

        protected abstract AbstractRollingFileWriterV2 construct() throws Exception;

        public AbstractRollingFileWriterV2 build() throws Exception {
            AbstractRollingFileWriterV2 writer = this.construct();
            writer.init();
            return writer;
        }
    }

    public static class FileMetaInfo {
        private String filePath;
        private long rows;
        private long sizeBytes;
        private String csvHeader;
        private boolean done;

        public void setFilePath(String filePath) {
            this.filePath = filePath;
        }

        public void setRows(long rows) {
            this.rows = rows;
        }

        public void setSizeBytes(long sizeBytes) {
            this.sizeBytes = sizeBytes;
        }

        public void setCsvHeader(String csvHeader) {
            this.csvHeader = csvHeader;
        }

        public void setDone(boolean done) {
            this.done = done;
        }

        public String getFilePath() {
            return this.filePath;
        }

        public long getRows() {
            return this.rows;
        }

        public long getSizeBytes() {
            return this.sizeBytes;
        }

        public String getCsvHeader() {
            return this.csvHeader;
        }

        public boolean isDone() {
            return this.done;
        }

        public FileMetaInfo(String filePath, long rows, long sizeBytes, String csvHeader, boolean done) {
            this.filePath = filePath;
            this.rows = rows;
            this.sizeBytes = sizeBytes;
            this.csvHeader = csvHeader;
            this.done = done;
        }
    }
}

