/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.dumper.writer;

import com.oceanbase.tools.loaddump.common.enums.DataFormat;
import com.oceanbase.tools.loaddump.common.model.datatype.DataType;
import com.oceanbase.tools.loaddump.common.model.storage.StorageConfig;
import com.oceanbase.tools.loaddump.dumper.writer.AbstractFsWriter;
import com.oceanbase.tools.loaddump.dumper.writer.AbstractRollingFileWriterV2;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.SchemaParseException;
import org.apache.avro.file.CodecFactory;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.hadoop.fs.Path;

public class AvroFileWriter
extends AbstractFsWriter {
    private final Schema schema;
    private final GenericDatumWriter<GenericRecord> datumWriter;
    private DataFileWriter<GenericRecord> writer;

    public AvroFileWriter(Schema schema, String filePath, String fileName, String fileSuffix, boolean retainEmptyFile, long blockSize, int blockRow, int participant, StorageConfig storageConfig) {
        super(filePath, fileName, fileSuffix, retainEmptyFile, blockSize, blockRow, participant, storageConfig);
        this.schema = schema;
        this.datumWriter = new GenericDatumWriter(schema);
    }

    @Override
    protected long writeInternal(Object line) throws Exception {
        if (this.writer == null) {
            this.writer = this.createAvroWriter();
        }
        long byteSize = 0L;
        GenericData.Record record = new GenericData.Record(this.schema);
        String[] row = (String[])line;
        for (int i = 0; i < this.schema.getFields().size(); ++i) {
            String value = row[i];
            if (value == null) continue;
            this.addValues(record, i, value);
            byteSize += (long)value.getBytes().length;
        }
        this.writer.append((Object)record);
        return byteSize;
    }

    @Override
    protected void createEmptyInternal() throws Exception {
        this.writer = this.createAvroWriter();
    }

    private DataFileWriter<GenericRecord> createAvroWriter() throws Exception {
        Path p = this.getFsPath();
        if (!this.fs.exists(p)) {
            this.fs.create(p).close();
        }
        return new DataFileWriter(this.datumWriter).setCodec(this.getCodecFactory()).create(this.schema, (OutputStream)this.fs.create(this.getFsPath()));
    }

    private CodecFactory getCodecFactory() {
        switch (this.storageConfig.getCompressor().getCompressAlgo()) {
            case SNAPPY: {
                return CodecFactory.snappyCodec();
            }
            case ZSTD: {
                return CodecFactory.zstandardCodec((int)this.storageConfig.getCompressor().getCompressLevel());
            }
            case GZIP: 
            case ZLIB: {
                return CodecFactory.deflateCodec((int)this.storageConfig.getCompressor().getCompressLevel());
            }
        }
        return CodecFactory.nullCodec();
    }

    private void addValues(GenericData.Record record, int colIdx, String value) {
        Schema fieldSchema = ((Schema.Field)this.schema.getFields().get(colIdx)).schema();
        if (fieldSchema.getType().equals((Object)Schema.Type.UNION)) {
            for (Schema sc : fieldSchema.getTypes()) {
                if (sc.getType().equals((Object)Schema.Type.NULL)) continue;
                fieldSchema = sc;
                break;
            }
        }
        switch (fieldSchema.getType()) {
            case INT: {
                record.put(colIdx, (Object)Integer.parseInt(value));
                break;
            }
            case LONG: {
                record.put(colIdx, (Object)Long.parseLong(value));
                break;
            }
            case FLOAT: {
                record.put(colIdx, (Object)Float.valueOf(Float.parseFloat(value)));
                break;
            }
            case DOUBLE: {
                record.put(colIdx, (Object)Double.parseDouble(value));
                break;
            }
            case BOOLEAN: {
                record.put(colIdx, (Object)Boolean.parseBoolean(value));
                break;
            }
            case STRING: {
                record.put(colIdx, (Object)value);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected Avro type: " + fieldSchema.getType());
            }
        }
    }

    @Override
    public void close() throws Exception {
        if (this.closed) {
            return;
        }
        if (this.writer != null) {
            this.writer.close();
            this.writer = null;
        }
        super.close();
        this.closed = true;
    }

    @Override
    protected void rollover() throws Exception {
        if (this.writer != null) {
            this.writer.close();
            this.writer = null;
        }
        super.rollover();
    }

    public static class Builder
    extends AbstractRollingFileWriterV2.Builder {
        private Schema schema;

        public Builder() {
            this.fileSuffix = DataFormat.AVRO.getFileSuffixes().get(0);
        }

        public Builder columnTypeMap(String schemaName, Map<String, DataType> colTypeMap) {
            ArrayList fields = new ArrayList();
            try {
                colTypeMap.forEach((columnName, columnType) -> {
                    Schema nullableSchema = Schema.createUnion(Arrays.asList(Schema.create((Schema.Type)Schema.Type.NULL), Builder.getMappedAvroType(columnType)));
                    Schema.Field field = new Schema.Field(columnName, nullableSchema, null, Schema.Field.NULL_DEFAULT_VALUE);
                    fields.add(field);
                });
            }
            catch (SchemaParseException e) {
                throw new IllegalArgumentException("Column name illegal in schema " + schemaName + ". Avro column names should composed by letters, numbers or underscores, and must starts with a letter or underscore.");
            }
            this.schema = Schema.createRecord((String)schemaName, null, null, (boolean)false, fields);
            return this;
        }

        static Schema getMappedAvroType(DataType columnType) {
            String dataType = columnType.getDataTypeName();
            int index = (dataType = dataType.trim().toLowerCase(Locale.getDefault())).indexOf("unsigned");
            switch (dataType = index > -1 ? dataType.substring(0, index).trim() : dataType) {
                case "int": 
                case "integer": 
                case "tinyint": 
                case "smallint": {
                    return Schema.create((Schema.Type)Schema.Type.INT);
                }
                case "bigint": {
                    return Schema.create((Schema.Type)Schema.Type.LONG);
                }
                case "float": {
                    return Schema.create((Schema.Type)Schema.Type.FLOAT);
                }
                case "double": {
                    return Schema.create((Schema.Type)Schema.Type.DOUBLE);
                }
                case "bool": 
                case "boolean": {
                    return Schema.create((Schema.Type)Schema.Type.BOOLEAN);
                }
            }
            return Schema.create((Schema.Type)Schema.Type.STRING);
        }

        @Override
        protected AvroFileWriter construct() throws Exception {
            return new AvroFileWriter(this.schema, this.filePath, this.fileName, this.fileSuffix, this.retainEmptyFile, this.blockSize, this.blockRow, this.participant, this.storageConfig);
        }
    }
}

