/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.dumper.writer;

import com.oceanbase.tools.loaddump.common.model.storage.StorageConfig;
import com.oceanbase.tools.loaddump.dumper.writer.CsvWriter;
import com.oceanbase.tools.loaddump.dumper.writer.FlatFileWriterV2;

public class CsvFileWriter
extends FlatFileWriterV2
implements CsvWriter {
    private String header;

    protected CsvFileWriter(String filePath, String fileName, String fileSuffix, String fileEncoding, boolean retainEmptyFile, long blockSize, int blockRow, int participant, StorageConfig storageConfig) {
        super(filePath, fileName, fileSuffix, fileEncoding, retainEmptyFile, blockSize, blockRow, participant, storageConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long write(Object line) throws Exception {
        this.lock.lock();
        try {
            if (this.currentBlockSize == 0L) {
                this.writeInternal(this.header);
            }
            long l = super.write(line);
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    protected void rollover() throws Exception {
        this.fileName2MetaInfo.forEach((key, value) -> value.setCsvHeader(this.header));
        super.rollover();
    }

    @Override
    public void close() throws Exception {
        this.fileName2MetaInfo.forEach((key, value) -> value.setCsvHeader(this.header));
        super.close();
    }

    @Override
    public void setCsvHeader(String header) {
        this.header = header;
    }

    public static class Builder
    extends FlatFileWriterV2.Builder {
        @Override
        protected CsvFileWriter construct() throws Exception {
            return new CsvFileWriter(this.filePath, this.fileName, this.fileSuffix, this.fileEncoding, this.retainEmptyFile, this.blockSize, this.blockRow, this.participant, this.storageConfig);
        }
    }
}

