/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.dumper.writer;

import com.oceanbase.tools.loaddump.common.JavaOpts;
import com.oceanbase.tools.loaddump.common.enums.DataFormat;
import com.oceanbase.tools.loaddump.common.model.datatype.DataType;
import com.oceanbase.tools.loaddump.common.model.storage.StorageConfig;
import com.oceanbase.tools.loaddump.compress.CompressAlgo;
import com.oceanbase.tools.loaddump.dumper.writer.AbstractRollingFileWriterV2;
import com.oceanbase.tools.loaddump.dumper.writer.AvroFileWriter;
import com.oceanbase.tools.loaddump.dumper.writer.CsvFileWriter;
import com.oceanbase.tools.loaddump.dumper.writer.FlatFileWriterV2;
import com.oceanbase.tools.loaddump.dumper.writer.OrcFileWriterV2;
import com.oceanbase.tools.loaddump.dumper.writer.ParquetFileWriterV2;
import com.oceanbase.tools.loaddump.dumper.writer.SqlFileWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileWriterManager {
    private static final Logger log = LoggerFactory.getLogger(FileWriterManager.class);
    HashMap<String, AbstractRollingFileWriterV2> instances;
    String filePath;
    String fileName;
    String fileSuffix;
    String fileEncoding;
    long blockSize;
    int blockRow;
    DataFormat dataFormat;
    StorageConfig storageConfig;
    int commitSize;
    boolean enableParallelWrite;
    AtomicLong groupNoAdder;
    CompressAlgo compressAlgo;
    int compressLevel;
    boolean retainEmptyFile;

    private FileWriterManager() {
    }

    public AbstractRollingFileWriterV2 getFileWriter(String tableName, Map<String, DataType> colMap, int participant) throws Exception {
        String realFileName;
        String string = realFileName = this.fileName == null ? tableName : this.fileName;
        if (this.enableParallelWrite) {
            return this.createNewFileWriter(tableName, realFileName + "." + this.groupNoAdder.incrementAndGet(), colMap, 1);
        }
        return this.instances.computeIfAbsent(tableName, t -> this.createNewFileWriter((String)t, realFileName, colMap, participant));
    }

    private AbstractRollingFileWriterV2 createNewFileWriter(String tableName, String fileName, Map<String, DataType> colMap, int participant) {
        AbstractRollingFileWriterV2.Builder builder;
        switch (this.dataFormat) {
            case AVRO: {
                builder = new AvroFileWriter.Builder().columnTypeMap(tableName, colMap);
                break;
            }
            case ORC: {
                builder = new OrcFileWriterV2.Builder().columnTypeMap(colMap);
                break;
            }
            case PAR: {
                builder = new ParquetFileWriterV2.Builder().columnTypeMap(tableName, colMap);
                break;
            }
            case CSV: {
                builder = new CsvFileWriter.Builder().fileEncoding(this.fileEncoding);
                break;
            }
            case SQL: {
                builder = new SqlFileWriter.Builder().commitSize(this.commitSize).fileEncoding(this.fileEncoding);
                break;
            }
            default: {
                builder = new FlatFileWriterV2.Builder().fileEncoding(this.fileEncoding);
            }
        }
        try {
            return builder.filePath(this.filePath).fileName(fileName).participant(participant).fileSuffix(this.fileSuffix).retainEmptyFile(this.retainEmptyFile).blockRow(this.blockRow).blockSize(this.blockSize).storageConfig(this.storageConfig).build();
        }
        catch (Exception e) {
            throw new RuntimeException("Create file writer failed.", e);
        }
    }

    public void close() {
        if (this.instances == null) {
            return;
        }
        this.instances.values().forEach(afw -> {
            try {
                afw.close();
            }
            catch (Exception e) {
                log.error("Close file writer failed.", (Throwable)e);
            }
        });
        this.instances.clear();
    }

    public static Builder builder() {
        return new Builder();
    }

    public long getBlockSize() {
        return this.blockSize;
    }

    public int getBlockRow() {
        return this.blockRow;
    }

    public static class Builder {
        String filePath;
        String fileName;
        String fileSuffix;
        String fileEncoding;
        long blockSize;
        String blockSizeUnit;
        DataFormat dataFormat;
        int commitSize;
        StorageConfig storageConfig;
        CompressAlgo compressAlgo;
        int compressLevel;
        boolean retainEmptyFile;

        public Builder filePath(String filePath) {
            this.filePath = filePath;
            return this;
        }

        public Builder fileName(String fileName) {
            this.fileName = fileName;
            return this;
        }

        public Builder fileSuffix(String fileSuffix) {
            this.fileSuffix = fileSuffix;
            return this;
        }

        public Builder fileEncoding(String fileEncoding) {
            this.fileEncoding = fileEncoding;
            return this;
        }

        public Builder blockSize(long blockSize) {
            this.blockSize = blockSize;
            return this;
        }

        public Builder dataFormat(DataFormat dataFormat) {
            this.dataFormat = dataFormat;
            return this;
        }

        public Builder blockSizeUnit(String blockSizeUnit) {
            this.blockSizeUnit = blockSizeUnit;
            return this;
        }

        public Builder commitSize(int commitSize) {
            this.commitSize = commitSize;
            return this;
        }

        public Builder storageConfig(StorageConfig storageConfig) {
            this.storageConfig = storageConfig;
            return this;
        }

        public Builder compressAlgo(CompressAlgo compressAlgo) {
            this.compressAlgo = compressAlgo;
            return this;
        }

        public Builder compressLevel(int compressLevel) {
            this.compressLevel = compressLevel;
            return this;
        }

        public Builder retainEmptyFile(boolean retainEmptyFile) {
            this.retainEmptyFile = retainEmptyFile;
            return this;
        }

        public FileWriterManager build() {
            FileWriterManager fwf = new FileWriterManager();
            fwf.filePath = this.filePath;
            fwf.fileName = this.fileName;
            fwf.fileEncoding = this.fileEncoding;
            fwf.dataFormat = this.dataFormat;
            fwf.commitSize = this.commitSize;
            fwf.storageConfig = this.storageConfig;
            fwf.compressAlgo = this.compressAlgo;
            fwf.compressLevel = this.compressLevel;
            fwf.retainEmptyFile = this.retainEmptyFile;
            fwf.fileSuffix = this.dataFormat.isBinary() ? this.fileSuffix : this.fileSuffix + this.storageConfig.getCompressor().getCompressSuffix();
            fwf.enableParallelWrite = JavaOpts.enableParallelWrite != null ? JavaOpts.enableParallelWrite : this.dataFormat == DataFormat.PAR || this.dataFormat == DataFormat.ORC;
            log.info("Parallel write is set to {}.", (Object)fwf.enableParallelWrite);
            if (fwf.enableParallelWrite) {
                fwf.groupNoAdder = new AtomicLong(0L);
            } else {
                fwf.instances = new HashMap();
            }
            if ("ROW".equals(this.blockSizeUnit)) {
                fwf.blockRow = (int)this.blockSize;
            } else if ("MB".equals(this.blockSizeUnit)) {
                fwf.blockSize = this.blockSize;
            } else {
                throw new IllegalStateException("Unexpected block size unit: " + this.blockSizeUnit);
            }
            return fwf;
        }
    }
}

