/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.dumper.writer;

import com.oceanbase.tools.loaddump.common.model.storage.StorageConfig;
import com.oceanbase.tools.loaddump.dumper.writer.AbstractFsWriter;
import com.oceanbase.tools.loaddump.dumper.writer.AbstractRollingFileWriterV2;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.apache.hadoop.fs.Path;

public class FlatFileWriterV2
extends AbstractFsWriter {
    protected BufferedWriter bw;
    protected final String fileEncoding;

    protected FlatFileWriterV2(String filePath, String fileName, String fileSuffix, String fileEncoding, boolean retainEmptyFile, long blockSize, int blockRow, int participant, StorageConfig storageConfig) {
        super(filePath, fileName, fileSuffix, retainEmptyFile, blockSize, blockRow, participant, storageConfig);
        this.fileEncoding = fileEncoding;
    }

    @Override
    protected void createEmptyInternal() throws Exception {
        Path p = this.getFsPath();
        if (this.fs.exists(p)) {
            this.fs.delete(p, false);
        }
        this.fs.create(p).close();
    }

    @Override
    public void close() throws Exception {
        if (this.closed) {
            return;
        }
        if (this.bw != null) {
            this.bw.close();
            this.bw = null;
        }
        super.close();
        this.closed = true;
    }

    @Override
    protected long writeInternal(Object line) throws Exception {
        if (this.bw == null) {
            this.bw = this.createBufferWriter();
        }
        if (line == null) {
            return 0L;
        }
        String raw = line.toString();
        this.bw.write(raw);
        return raw.getBytes().length;
    }

    @Override
    protected void rollover() throws Exception {
        this.bw.close();
        this.bw = null;
        super.rollover();
    }

    protected BufferedWriter createBufferWriter() throws IOException {
        Object os = this.fs.create(this.getFsPath(), true);
        os = this.storageConfig.getCompressor().compress((OutputStream)os);
        return new BufferedWriter(new OutputStreamWriter((OutputStream)os, this.fileEncoding), 0x100000);
    }

    public static class Builder
    extends AbstractRollingFileWriterV2.Builder {
        protected String fileEncoding;

        public Builder fileEncoding(String fileEncoding) {
            this.fileEncoding = fileEncoding;
            return this;
        }

        @Override
        protected AbstractRollingFileWriterV2 construct() throws Exception {
            return new FlatFileWriterV2(this.filePath, this.fileName, this.fileSuffix, this.fileEncoding, this.retainEmptyFile, this.blockSize, this.blockRow, this.participant, this.storageConfig);
        }
    }
}

