/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.dumper.writer;

import com.oceanbase.tools.loaddump.common.enums.DataFormat;
import com.oceanbase.tools.loaddump.common.model.datatype.DataType;
import com.oceanbase.tools.loaddump.common.model.storage.StorageConfig;
import com.oceanbase.tools.loaddump.dumper.writer.AbstractFsWriter;
import com.oceanbase.tools.loaddump.dumper.writer.AbstractRollingFileWriterV2;
import java.io.Flushable;
import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.orc.CompressionKind;
import org.apache.orc.OrcConf;
import org.apache.orc.OrcFile;
import org.apache.orc.TypeDescription;
import org.apache.orc.Writer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrcFileWriterV2
extends AbstractFsWriter
implements Flushable {
    private static final Logger log = LoggerFactory.getLogger(OrcFileWriterV2.class);
    private Writer orcWriter;
    private final Configuration conf;
    private final TypeDescription schema;
    private VectorizedRowBatch batch;

    public OrcFileWriterV2(String filePath, String fileName, String fileSuffix, boolean retainEmptyFile, long blockSize, int blockRow, int participant, Configuration conf, TypeDescription schema, StorageConfig storageConfig) {
        super(filePath, fileName, fileSuffix, retainEmptyFile, blockSize, blockRow, participant, storageConfig);
        this.conf = conf;
        this.schema = schema;
    }

    @Override
    protected long writeInternal(Object line) throws Exception {
        if (this.orcWriter == null) {
            this.orcWriter = this.createOrcWriterV2();
        }
        if (this.batch == null) {
            this.batch = this.orcWriter.getSchema().createRowBatchV2();
        }
        String[] rowValues = (String[])line;
        int rowIdx = this.batch.size++;
        long byteSize = 0L;
        for (int i = 0; i < this.schema.getChildren().size(); ++i) {
            String value = rowValues[i];
            ColumnVector vec = this.batch.cols[i];
            if (value == null) {
                vec.isNull[rowIdx] = true;
                vec.noNulls = false;
                continue;
            }
            this.addValues(vec, rowIdx, i, value);
            byteSize += (long)value.getBytes().length;
        }
        if (this.batch.size == this.batch.getMaxSize()) {
            this.flush();
        }
        return byteSize;
    }

    @Override
    protected void createEmptyInternal() throws Exception {
        this.orcWriter = this.createOrcWriterV2();
        this.orcWriter.close();
        this.orcWriter = null;
    }

    @Override
    public void flush() throws IOException {
        if (this.batch.size == 0) {
            return;
        }
        this.orcWriter.addRowBatch(this.batch);
        this.batch.reset();
    }

    @Override
    public void close() throws Exception {
        if (this.closed) {
            return;
        }
        if (this.batch != null) {
            this.flush();
            this.batch = null;
        }
        if (this.orcWriter != null) {
            this.orcWriter.close();
            this.orcWriter = null;
        }
        super.close();
        this.closed = true;
    }

    @Override
    protected void rollover() throws Exception {
        this.flush();
        this.orcWriter.close();
        this.orcWriter = null;
        this.batch = null;
        super.rollover();
    }

    private void addValues(ColumnVector vec, int rowIdx, int colIdx, String value) throws Exception {
        TypeDescription type = (TypeDescription)this.schema.getChildren().get(colIdx);
        switch (type.getCategory()) {
            case LONG: {
                ((LongColumnVector)vec).vector[rowIdx] = Long.parseLong(value);
                break;
            }
            case DOUBLE: {
                ((DoubleColumnVector)vec).vector[rowIdx] = Double.parseDouble(value);
                break;
            }
            case DECIMAL: {
                ((DecimalColumnVector)vec).set(rowIdx, HiveDecimal.create((String)value));
                break;
            }
            case BOOLEAN: {
                ((LongColumnVector)vec).vector[rowIdx] = Boolean.parseBoolean(value) ? 1L : 0L;
                break;
            }
            default: {
                ((BytesColumnVector)vec).setVal(rowIdx, this.getBytes(value, "UTF-8"));
            }
        }
    }

    private Writer createOrcWriterV2() throws Exception {
        Path p = this.getFsPath();
        if (!this.fs.exists(p)) {
            this.fs.create(p).close();
        }
        OrcFile.WriterOptions opts = OrcFile.writerOptions((Configuration)this.conf).fileSystem(this.fs).setSchema(this.schema).overwrite(true).bufferSize(262144).stripeSize(0x1000000L).blockSize(0x8000000L).encodingStrategy(OrcFile.EncodingStrategy.COMPRESSION).compress(this.getCompressionKind()).version(OrcFile.Version.V_0_12);
        return OrcFile.createWriter((Path)p, (OrcFile.WriterOptions)opts);
    }

    private CompressionKind getCompressionKind() {
        switch (this.storageConfig.getCompressor().getCompressAlgo()) {
            case GZIP: 
            case ZLIB: {
                return CompressionKind.ZLIB;
            }
            case SNAPPY: {
                return CompressionKind.SNAPPY;
            }
        }
        return CompressionKind.ZSTD;
    }

    public static class Builder
    extends AbstractRollingFileWriterV2.Builder {
        private Map<String, DataType> columnTypeMap;

        public Builder() {
            this.fileSuffix = DataFormat.ORC.getFileSuffixes().get(0);
        }

        public Builder columnTypeMap(Map<String, DataType> columnTypeMap) {
            this.columnTypeMap = columnTypeMap;
            return this;
        }

        static TypeDescription assembleTypeDescription(DataType dataTypeObj) {
            String dataType = dataTypeObj.getDataTypeName();
            int index = (dataType = dataType.trim().toLowerCase(Locale.getDefault())).indexOf("unsigned");
            switch (dataType = index > -1 ? dataType.substring(0, index).trim() : dataType) {
                case "bool": 
                case "boolean": {
                    return TypeDescription.createBoolean();
                }
                case "int": 
                case "integer": 
                case "tinyint": 
                case "smallint": 
                case "bigint": {
                    return TypeDescription.createLong();
                }
                case "float": 
                case "double": {
                    return TypeDescription.createDouble();
                }
                case "number": 
                case "numeric": 
                case "real": 
                case "decimal": 
                case "bigdecimal": 
                case "binary_float": 
                case "binary_double": {
                    return TypeDescription.createDecimal();
                }
                case "bit": 
                case "raw": 
                case "longraw": 
                case "binary": 
                case "varbinary": 
                case "longvarbinary": 
                case "tinyblob": 
                case "blob": 
                case "mediumblob": 
                case "clob": 
                case "nclob": 
                case "longblob": {
                    return TypeDescription.createBinary();
                }
            }
            return TypeDescription.createString();
        }

        @Override
        protected OrcFileWriterV2 construct() throws Exception {
            TypeDescription schema = TypeDescription.createStruct();
            this.columnTypeMap.forEach((columnName, columnType) -> schema.addField(columnName, Builder.assembleTypeDescription(columnType)));
            Configuration conf = this.storageConfig.getFsConf();
            conf.setDouble(OrcConf.MEMORY_POOL.getAttribute(), 0.5);
            conf.set(OrcConf.COMPRESSION_STRATEGY.getAttribute(), OrcFile.CompressionStrategy.COMPRESSION.name());
            conf.setInt(OrcConf.ROW_BATCH_SIZE.getAttribute(), 2048);
            conf.set(OrcConf.DICTIONARY_IMPL.getAttribute(), "hash");
            conf.set(OrcConf.ROWS_BETWEEN_CHECKS.getAttribute(), String.valueOf(1000));
            return new OrcFileWriterV2(this.filePath, this.fileName, this.fileSuffix, this.retainEmptyFile, this.blockSize, this.blockRow, this.participant, conf, schema, this.storageConfig);
        }
    }
}

