/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.jdbc;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.oceanbase.tools.loaddump.common.SessionManager;
import com.oceanbase.tools.loaddump.jdbc.JdbcExecutor;
import com.oceanbase.tools.loaddump.jdbc.JdbcOperation;
import com.oceanbase.tools.loaddump.jdbc.ResultHandler;
import com.oceanbase.tools.loaddump.jdbc.ResultMapHandler;
import com.oceanbase.tools.loaddump.jdbc.ResultsHandler;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcTemplate
implements JdbcOperation {
    private static final Logger log = LoggerFactory.getLogger(JdbcTemplate.class);
    private final SessionManager sessionManager;

    public JdbcTemplate(SessionManager sessionManager) {
        this.sessionManager = sessionManager;
    }

    @Override
    public void execute(String sql) throws SQLException {
        try (Connection conn = this.sessionManager.getPooledBizConnection();){
            JdbcExecutor.execute(conn, sql);
        }
        catch (Exception ex) {
            log.error("SQL: " + sql, (Throwable)ex);
            throw new SQLException(ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> T query(String sql, Object[] args, ResultHandler<T> handler) throws SQLException {
        try (Connection conn = this.sessionManager.getPooledBizConnection();){
            T t = JdbcExecutor.query(conn, sql, args, handler);
            return t;
        }
        catch (Exception ex) {
            log.error("SQL: " + sql, (Throwable)ex);
            throw new SQLException(ex);
        }
    }

    public <T> T query(String sql, ResultHandler<T> handler) throws SQLException {
        return this.query(sql, null, handler);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> T queryFromSysTable(String sql, Object[] args, ResultHandler<T> handler) throws SQLException {
        if (!this.sessionManager.isSupportSys()) {
            log.error("Query object from system table failed as without xxx@sys");
            return null;
        }
        ArrayList argList = Lists.newArrayList((Object[])new Object[]{this.sessionManager.getConnectionKey().getTenant()});
        if (args != null) {
            argList.addAll(Arrays.stream(args).collect(Collectors.toList()));
        }
        try (Connection conn = this.sessionManager.getPooledSysConnection();){
            T t = JdbcExecutor.query(conn, sql, argList.toArray(), handler);
            return t;
        }
        catch (Exception ex) {
            log.error("SQL: " + sql, (Throwable)ex);
            throw new SQLException(ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> List<T> queryList(String sql, Object[] args, ResultsHandler<T> handler) throws SQLException {
        try (Connection conn = this.sessionManager.getPooledBizConnection();){
            List<T> list = JdbcExecutor.queryList(conn, sql, args, handler);
            return list;
        }
        catch (Exception ex) {
            log.error("SQL: " + sql, (Throwable)ex);
            throw new SQLException(ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> List<T> queryListFromSysTable(String sql, Object[] args, ResultsHandler<T> handler) throws SQLException {
        if (!this.sessionManager.isSupportSys()) {
            log.error("Query object list from system table failed as without xxx@sys");
            return Lists.newArrayList();
        }
        ArrayList argList = Lists.newArrayList((Object[])new Object[]{this.sessionManager.getConnectionKey().getTenant()});
        if (args != null) {
            argList.addAll(Arrays.stream(args).collect(Collectors.toList()));
        }
        try (Connection conn = this.sessionManager.getPooledSysConnection();){
            List<T> list = JdbcExecutor.queryList(conn, sql, argList.toArray(), handler);
            return list;
        }
        catch (Exception ex) {
            log.error("SQL: " + sql, (Throwable)ex);
            throw new SQLException(ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <K, V> Map<K, V> queryMap(String sql, Object[] args, ResultMapHandler<K, V> handler) throws SQLException {
        try (Connection conn = this.sessionManager.getPooledBizConnection();){
            Map<K, V> map = JdbcExecutor.queryMap(conn, sql, args, handler);
            return map;
        }
        catch (Exception ex) {
            log.error("SQL: " + sql, (Throwable)ex);
            throw new SQLException(ex);
        }
    }

    public <K, V> Map<K, V> queryMap(String sql, ResultMapHandler<K, V> handler) throws SQLException {
        return this.queryMap(sql, null, handler);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <K, V> Map<K, V> queryMapFromSysTable(String sql, Object[] args, ResultMapHandler<K, V> handler) throws SQLException {
        if (!this.sessionManager.isSupportSys()) {
            log.error("Query object map from system table failed as without xxx@sys");
            return Maps.newLinkedHashMap();
        }
        ArrayList argList = Lists.newArrayList((Object[])new Object[]{this.sessionManager.getConnectionKey().getTenant()});
        if (args != null) {
            argList.addAll(Arrays.stream(args).collect(Collectors.toList()));
        }
        try (Connection conn = this.sessionManager.getPooledSysConnection();){
            Map<K, V> map = JdbcExecutor.queryMap(conn, sql, argList.toArray(), handler);
            return map;
        }
        catch (Exception ex) {
            log.error("SQL: " + sql, (Throwable)ex);
            throw new SQLException(ex);
        }
    }

    public SessionManager getSessionManager() {
        return this.sessionManager;
    }
}

