/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.loader;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.oceanbase.tools.loaddump.common.TaskContext;
import com.oceanbase.tools.loaddump.common.enums.State;
import com.oceanbase.tools.loaddump.common.model.LoadParameter;
import com.oceanbase.tools.loaddump.common.model.Progress;
import com.oceanbase.tools.loaddump.common.model.RuntimeMetrics;
import com.oceanbase.tools.loaddump.common.model.SubFile;
import com.oceanbase.tools.loaddump.common.model.Summary;
import com.oceanbase.tools.loaddump.common.model.TaskDetail;
import com.oceanbase.tools.loaddump.loader.ILoader;
import com.oceanbase.tools.loaddump.utils.CollectionUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLoader
extends TaskContext
implements ILoader {
    private static final Logger log = LoggerFactory.getLogger(AbstractLoader.class);
    protected State state = State.INITIAL;
    protected final AtomicBoolean supervisor;
    protected final LoadParameter parameter;
    protected final List<TaskDetail> taskDetailList;
    private final List<SubFile> subFiles;

    protected AbstractLoader(LoadParameter parameter) {
        this.parameter = parameter;
        this.supervisor = new AtomicBoolean(true);
        this.subFiles = new ArrayList<SubFile>(16);
        this.taskDetailList = new ArrayList<TaskDetail>(16);
    }

    protected void checkState() throws Exception {
        Preconditions.checkState((this.state != State.INITIAL ? 1 : 0) != 0, (Object)"Not prepared");
        Preconditions.checkState((this.state != State.RUNNING ? 1 : 0) != 0, (Object)"It's already running");
        Preconditions.checkState((this.state != State.TERMINATE ? 1 : 0) != 0, (Object)"It's already terminated");
    }

    @Override
    public ILoader prepare() throws Exception {
        this.subFiles.addAll(this.generateSubFiles());
        return this.doPrepare(this.subFiles);
    }

    @Override
    public TaskContext loadRecordAsync() throws Exception {
        return this.doLoadRecordAsync(this.subFiles);
    }

    @Override
    public TaskContext loadSchemaAsync() throws Exception {
        return this.doLoadSchemaAsync(this.subFiles);
    }

    protected abstract ILoader doPrepare(List<SubFile> var1) throws Exception;

    protected abstract TaskContext doLoadRecordAsync(List<SubFile> var1) throws Exception;

    protected abstract TaskContext doLoadSchemaAsync(List<SubFile> var1) throws Exception;

    protected abstract String getLoadTaskType();

    protected abstract List<SubFile> generateSubFiles() throws Exception;

    @Override
    public Summary getSummary() {
        return new Summary("All Load Tasks Finished", this.getAllTaskDetails());
    }

    @Override
    public Progress getProgress() {
        double totalPercent = 0.0;
        int loadedFiles = 0;
        int totalFiles = this.subFiles.size();
        for (SubFile subFile : this.subFiles) {
            if (subFile.isFinished()) {
                ++loadedFiles;
            }
            totalPercent += subFile.getProgress();
        }
        BigDecimal per = new BigDecimal(totalPercent / (double)totalFiles);
        double percent = per.setScale(2, RoundingMode.HALF_UP).doubleValue();
        percent = percent > 100.0 ? 99.99 : percent;
        return new Progress(loadedFiles, totalFiles - loadedFiles, percent);
    }

    @Override
    public Collection<TaskDetail> getAllTaskDetails() {
        return Collections.unmodifiableCollection(this.taskDetailList);
    }

    @Override
    public Collection<TaskDetail> getFailureTaskDetails() {
        List<TaskDetail> taskDetails = this.taskDetailList;
        if (CollectionUtils.isEmpty(taskDetails)) {
            log.warn("{} task details are empty, please check it....", (Object)this.getLoadTaskType());
            return Lists.newArrayList();
        }
        return taskDetails.stream().filter(e -> e != null && e.isFailure()).collect(Collectors.toList());
    }

    @Override
    public boolean isAllTasksFinished() {
        List<TaskDetail> taskDetails = this.taskDetailList;
        if (CollectionUtils.isEmpty(taskDetails)) {
            log.warn("{} task details are empty, please check it....", (Object)this.getLoadTaskType());
            return false;
        }
        return taskDetails.stream().allMatch(e -> e != null && e.isFinished());
    }

    @Override
    public boolean isAllTasksSuccessed() {
        List<TaskDetail> taskDetails = this.taskDetailList;
        if (CollectionUtils.isEmpty(taskDetails)) {
            log.warn("{} task details are empty, please check it....", (Object)this.getLoadTaskType());
            return false;
        }
        return taskDetails.stream().allMatch(e -> e != null && e.isSuccess());
    }

    @Override
    public RuntimeMetrics getRuntimeMetrics() {
        RuntimeMetrics runtimeMetrics = new RuntimeMetrics();
        runtimeMetrics.setThroughput(0L);
        runtimeMetrics.setMeanThroughputRate(0.0);
        runtimeMetrics.setProgress(this.getProgress().getProgress());
        runtimeMetrics.setCount(this.taskDetailList.stream().mapToLong(TaskDetail::getCount).sum());
        runtimeMetrics.setTotal(this.taskDetailList.stream().mapToLong(TaskDetail::getTotal).sum());
        return runtimeMetrics;
    }

    @Override
    public void syncTasksStateFinally() {
    }
}

