/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.loader;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Sets;
import com.oceanbase.tools.loaddump.common.SessionManager;
import com.oceanbase.tools.loaddump.common.TaskContext;
import com.oceanbase.tools.loaddump.common.constants.Constants;
import com.oceanbase.tools.loaddump.common.enums.DataFormat;
import com.oceanbase.tools.loaddump.common.enums.ObjectType;
import com.oceanbase.tools.loaddump.common.enums.ServerMode;
import com.oceanbase.tools.loaddump.common.enums.State;
import com.oceanbase.tools.loaddump.common.enums.StorageType;
import com.oceanbase.tools.loaddump.common.enums.TaskType;
import com.oceanbase.tools.loaddump.common.exception.NoTaskGeneratedException;
import com.oceanbase.tools.loaddump.common.metadata.MetadataProvider;
import com.oceanbase.tools.loaddump.common.model.ConnectionKey;
import com.oceanbase.tools.loaddump.common.model.Database;
import com.oceanbase.tools.loaddump.common.model.LoadParameter;
import com.oceanbase.tools.loaddump.common.model.RuntimeMetrics;
import com.oceanbase.tools.loaddump.common.model.SubFile;
import com.oceanbase.tools.loaddump.common.model.TableInfo;
import com.oceanbase.tools.loaddump.common.model.TaskDetail;
import com.oceanbase.tools.loaddump.common.model.TaskState;
import com.oceanbase.tools.loaddump.common.model.storage.StorageConfig;
import com.oceanbase.tools.loaddump.common.thread.ExecutorTemplate;
import com.oceanbase.tools.loaddump.common.thread.NamedThreadFactory;
import com.oceanbase.tools.loaddump.common.thread.ThreadPoolBuilder;
import com.oceanbase.tools.loaddump.compress.CompressAlgo;
import com.oceanbase.tools.loaddump.loader.AbstractLoader;
import com.oceanbase.tools.loaddump.loader.AdaptiveBatchStrategy;
import com.oceanbase.tools.loaddump.loader.ILoader;
import com.oceanbase.tools.loaddump.loader.LoadContext;
import com.oceanbase.tools.loaddump.loader.partition.PartitionCalculator;
import com.oceanbase.tools.loaddump.loader.reader.RecordFileReader;
import com.oceanbase.tools.loaddump.loader.writer.AbstractOceanBaseWriter;
import com.oceanbase.tools.loaddump.metrics.Meter;
import com.oceanbase.tools.loaddump.metrics.MetricRegistry;
import com.oceanbase.tools.loaddump.resource.ResourceFinderV2;
import com.oceanbase.tools.loaddump.resource.ResourceV2;
import com.oceanbase.tools.loaddump.ringbuffer.RingBufferGroup;
import com.oceanbase.tools.loaddump.throttle.DummyGCThrottle;
import com.oceanbase.tools.loaddump.throttle.LoadThreadStartUpThrottle;
import com.oceanbase.tools.loaddump.throttle.MemoryThrottle;
import com.oceanbase.tools.loaddump.throttle.OBServerLoadThrottle;
import com.oceanbase.tools.loaddump.throttle.RateLimiterThrottle;
import com.oceanbase.tools.loaddump.throttle.RingBufferThrottle;
import com.oceanbase.tools.loaddump.throttle.ThrottleCenter;
import com.oceanbase.tools.loaddump.utils.FileUtils;
import com.oceanbase.tools.loaddump.utils.NumberUtils;
import com.oceanbase.tools.loaddump.utils.SerializeUtils;
import com.oceanbase.tools.loaddump.utils.SqlNotesUtil;
import com.oceanbase.tools.loaddump.utils.TimeUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRecordFileLoader
extends AbstractLoader {
    private static final Logger log = LoggerFactory.getLogger(AbstractRecordFileLoader.class);
    private static final int SCHEMA_REFRESH_TIME = 10000;
    private static final int MAX_FILE_COPIES = 40000;
    private RingBufferGroup bufferGroup;
    private ExecutorService readerExecutor;
    private ScheduledExecutorService logReporterExecutor;
    protected LoadContext loadCtx;
    protected PartitionCalculator partitionCalculator;
    protected final ConnectionKey connectionKey;
    protected final SessionManager sessionManager;
    protected final Database database;
    protected final ThrottleCenter throttleCenter;
    private final Meter dequeueMeter;
    private final String filePath;
    private final MetricRegistry registry = new MetricRegistry();
    private final long blockSize;
    private final String checkpointPath;
    private final LoadThreadStartUpThrottle threadThrottle = new LoadThreadStartUpThrottle();
    private final List<AbstractOceanBaseWriter> oceanBaseWriters = new ArrayList<AbstractOceanBaseWriter>();

    public AbstractRecordFileLoader(LoadParameter parameter) {
        super(parameter);
        this.filePath = parameter.getFilePath();
        this.database = parameter.getDatabase();
        this.blockSize = parameter.getBlockSize();
        this.checkpointPath = parameter.getCheckpointPath();
        this.dequeueMeter = this.registry.meter("2. Dequeue Performance Monitor: ");
        this.connectionKey = parameter.getConnectionKey();
        this.throttleCenter = this.createThrottleCenter(parameter);
        this.sessionManager = parameter.getConnectionKey().getSessionManager();
    }

    @Override
    public TaskContext doLoadSchemaAsync(List<SubFile> subFiles) {
        throw new UnsupportedOperationException("Load schema is unsupported");
    }

    @Override
    protected ILoader doPrepare(List<SubFile> subFiles) throws Exception {
        ExecutorTemplate.setPoolSize(this.parameter.getThreads());
        if (!this.parameter.isRetry()) {
            this.truncateTableIfNecessary();
        }
        if (CollectionUtils.isEmpty(subFiles)) {
            throw new NoTaskGeneratedException("No sub-files are generated from path: " + this.filePath);
        }
        this.loadCtx = new LoadContext(this.parameter, subFiles, this.throttleCenter);
        if (!this.parameter.isRetry()) {
            try {
                SerializeUtils.serializeListByKryo(subFiles, this.checkpointPath);
            }
            catch (Exception e) {
                this.parameter.setCanWrite(false);
                log.warn("Unable to serialize the checkpoint file. But it won't affect the data integrity. Reason: {}.", (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            }
        }
        this.initPkOrUkForReplace();
        this.partitionCalculator = this.buildPartitionCalculator();
        this.readerExecutor = new ThreadPoolBuilder().setCorePoolSize(this.getReaderThreads()).setMaximumPoolSize(this.getReaderThreads()).setQueueSize(subFiles.size()).setThreadPrefixName("record-file-loader-thread-").build();
        this.logReporterExecutor = new ScheduledThreadPoolExecutor(1, new NamedThreadFactory("log-reporter-"), new ThreadPoolExecutor.DiscardOldestPolicy());
        this.state = State.PREPARE;
        return this;
    }

    @Override
    public TaskContext doLoadRecordAsync(List<SubFile> subFiles) throws Exception {
        this.checkState();
        List<SubFile> shuffledSubFiles = this.shuffleSubFiles(subFiles);
        this.startWriter(this.dequeueMeter);
        Meter enqueueMeter = this.registry.meter("1. Enqueue Performance Monitor: ");
        this.startReader(shuffledSubFiles, enqueueMeter);
        this.startLogReporter(this.logReporterExecutor, this.registry);
        this.logReporterExecutor.scheduleAtFixedRate(() -> {
            log.info(this.throttleCenter.toLogString());
            log.info(this.threadThrottle.toLogString());
        }, 0L, 5L, TimeUnit.SECONDS);
        this.state = State.RUNNING;
        return this;
    }

    public int getReaderThreads() {
        int threads = this.parameter.getThreads();
        return (int)Math.max(this.parameter.getReadWriteRatio() * (double)threads, 1.0);
    }

    protected int getWriterThreads() {
        return Math.max(this.parameter.getThreads(), 1);
    }

    @Override
    public boolean isThreadPoolAlive() {
        return this.isAlive(this.readerExecutor);
    }

    @Override
    public void shutdown() throws Exception {
        this.supervisor.compareAndSet(true, false);
        if (this.bufferGroup != null) {
            this.bufferGroup.drainAndHalt();
        }
        this.shutdownInternal(false, this.readerExecutor);
        this.throttleCenter.close();
        this.shutdownInternal(true, this.logReporterExecutor);
        this.oceanBaseWriters.forEach(AbstractOceanBaseWriter::shutdown);
        this.state = State.TERMINATE;
    }

    @Override
    public void shutdownNow() throws Exception {
        this.supervisor.compareAndSet(true, false);
        if (this.bufferGroup != null) {
            this.bufferGroup.halt();
        }
        this.shutdownInternal(true, this.readerExecutor);
        this.throttleCenter.close();
        this.shutdownInternal(true, this.logReporterExecutor);
        this.state = State.TERMINATE;
    }

    @Override
    public RuntimeMetrics getRuntimeMetrics() {
        RuntimeMetrics runtimeMetrics = super.getRuntimeMetrics();
        runtimeMetrics.setThroughput(this.dequeueMeter.getThroughput());
        runtimeMetrics.setMeanThroughputRate(this.dequeueMeter.getMeanThroughputRate());
        return runtimeMetrics;
    }

    @Override
    protected List<SubFile> generateSubFiles() throws Exception {
        return this.parameter.isRetry() ? this.generateSubFilesForRetry() : this.generateSubFilesForNonRetry();
    }

    protected Set<String> getTablesWithNonEmptyDatafiles() {
        return Sets.newHashSet(this.database.getTableNames()).stream().filter(table -> {
            if (!this.database.getTableInfo((String)table).isWithNonEmptyDatafiles()) {
                log.debug("Ignore table: \"{}\" without datafiles.", table);
                return false;
            }
            return true;
        }).collect(Collectors.toSet());
    }

    protected ThrottleCenter createThrottleCenter(LoadParameter parameter) {
        return new ThrottleCenter(Arrays.asList(new OBServerLoadThrottle(parameter), new DummyGCThrottle(), new RingBufferThrottle(), new MemoryThrottle(), new RateLimiterThrottle(parameter.getTpsLimit())));
    }

    protected abstract List<SubFile> shuffleSubFiles(List<SubFile> var1);

    protected abstract AbstractOceanBaseWriter[] assembleWriters(Meter var1, RingBufferGroup var2);

    protected abstract PartitionCalculator buildPartitionCalculator() throws Exception;

    protected abstract void startLogReporter(ScheduledExecutorService var1, MetricRegistry var2);

    private void initPkOrUkForReplace() {
        boolean queryPkFlag;
        ServerMode serverMode = this.database.getServerMode();
        boolean bl = queryPkFlag = !serverMode.isOracleMode() || !serverMode.isPrevious("2.2.76");
        if (queryPkFlag) {
            log.info("Querying primary/unique constraints metadata for data replacing...");
            ExecutorTemplate queryConstraintExecutor = new ExecutorTemplate("query-table-constraints-", this.parameter.getThreads());
            this.database.getTableInfoMap().values().forEach(tableInfo -> queryConstraintExecutor.submit(() -> this.preparePrimaryForReplace((TableInfo)tableInfo, serverMode)));
            queryConstraintExecutor.waitForResult();
        }
    }

    private void preparePrimaryForReplace(TableInfo tableInfo, ServerMode serverMode) {
        MetadataProvider metadataProvider = this.parameter.getConnectionKey().getMetadataProvider();
        try {
            tableInfo.setPrimaryCols(metadataProvider.queryPrimaryKeyList(serverMode, tableInfo.getSchema(), tableInfo.getTable()));
            if (CollectionUtils.isEmpty(tableInfo.getPrimaryCols()) && (this.parameter.isReplaceData() && serverMode.isOracleMode() || this.parameter.isRetry())) {
                Map<String, List<String>> uniqueKeys = metadataProvider.queryUniqueKeyMap(serverMode, tableInfo.getSchema(), tableInfo.getTable());
                uniqueKeys.entrySet().removeIf(i -> ((List)i.getValue()).stream().anyMatch(tableInfo::isNullable));
                tableInfo.setNotNullUniqueKeyMap(uniqueKeys);
            }
        }
        catch (Exception e) {
            log.error("Querying primary/unique key failed. Reason: ", (Throwable)e);
        }
        tableInfo.preparePrimaryForReplace();
    }

    private void startReader(List<SubFile> subFiles, Meter enqueueMeter) {
        int readerThreads = this.getReaderThreads();
        AdaptiveBatchStrategy adaptiveBatchStrategy = new AdaptiveBatchStrategy();
        for (SubFile tempSubFile : subFiles) {
            String table = tempSubFile.getObjectName();
            TableInfo tableInfo = this.database.getTableInfo(table);
            tableInfo.setIgnoreUnhex(this.parameter.isIgnoreUnhex());
            RecordFileReader reader = new RecordFileReader(this.parameter, subFiles, this.partitionCalculator);
            reader.setSubFile(tempSubFile);
            reader.setMeter(enqueueMeter);
            reader.setTableInfo(tableInfo);
            reader.setSupervisor(this.supervisor);
            reader.setBufferGroup(this.bufferGroup);
            reader.setLoadCtx(this.loadCtx);
            reader.setThreadThrottle(this.threadThrottle);
            reader.setAdaptiveBatchStrategy(adaptiveBatchStrategy);
            this.taskDetailList.add(tempSubFile.getTaskDetail());
            this.readerExecutor.submit(reader);
        }
        log.info("Start {} readers for {} threads succeed.", (Object)subFiles.size(), (Object)readerThreads);
    }

    private void startWriter(Meter dequeueMeter) {
        Set<String> tableNames = this.getTablesWithNonEmptyDatafiles();
        Set leaderServers = this.partitionCalculator.getTableName2PartId2LeaderServer(tableNames).values().stream().flatMap(m -> m.values().stream()).collect(Collectors.toSet());
        Preconditions.checkState((boolean)CollectionUtils.isNotEmpty(leaderServers), (Object)"Writers is empty");
        int threads = this.getWriterThreads();
        int leaderBuffer = this.parameter.getBufferSize() / Math.max(leaderServers.size(), 1);
        int capacity = NumberUtils.computeTheNearestPowerOfTwo(leaderBuffer, 8, 8192);
        this.bufferGroup = new RingBufferGroup(capacity, threads);
        for (String leaderServer : leaderServers) {
            AbstractOceanBaseWriter[] writers = this.assembleWriters(dequeueMeter, this.bufferGroup);
            this.oceanBaseWriters.addAll(Arrays.asList(writers));
            this.bufferGroup.register(leaderServer, writers, new ThreadPoolBuilder().setCorePoolSize(threads).setMaximumPoolSize(threads).setQueueSize(this.bufferGroup.getCapacity()).setThreadPrefixName(leaderServer.replace(':', '-') + "-writer-thread-").build());
            log.info("Start {} writers for {} threads and leader server [{}] succeed.", new Object[]{writers.length, threads, leaderServer});
        }
    }

    private String generateTruncateLiteral(TableInfo tableInfo) {
        String sql = this.parameter.isTruncatable() ? "truncate table " + tableInfo.getSchemaTable() : "delete from " + tableInfo.getSchemaTable();
        return SqlNotesUtil.addLoaderDumperNotes(sql);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean doTruncateTable(TableInfo tableInfo) {
        String ddl = this.generateTruncateLiteral(tableInfo);
        try (Connection conn = this.sessionManager.getPooledBizConnection();){
            try (PreparedStatement ps = conn.prepareStatement(SqlNotesUtil.addLoaderDumperNotes(ddl));){
                ps.execute();
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            log.error("Exec \"{}\" failed. Error: {}", (Object)ddl, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            return false;
        }
    }

    private void truncateTableIfNecessary() {
        if (!this.parameter.isTruncatable() && !this.parameter.isDeleteable()) {
            log.debug("Ignore to clean any tables as --truncate-table or --delete-from-table is not specified");
            return;
        }
        HashSet tableInfoCopies = Sets.newHashSet(this.database.getTableInfoMap().values());
        int size = tableInfoCopies.size();
        AtomicLong remain = new AtomicLong(tableInfoCopies.size());
        Iterator iter = tableInfoCopies.iterator();
        while (iter.hasNext()) {
            TableInfo tableInfo = (TableInfo)iter.next();
            if (!tableInfo.isEmptyTable() && tableInfo.isWithDatafiles()) continue;
            iter.remove();
            remain.decrementAndGet();
            log.info("Ignore to clean the empty table [{}] or table without data files [{}]: {}. Remain: [{}/{}]", new Object[]{tableInfo.isEmptyTable(), !tableInfo.isWithDatafiles(), tableInfo.getSchemaTable(), remain, size});
        }
        if (remain.get() <= 0L) {
            log.debug("Ignore to clean any tables as they are all empty in the schema");
            return;
        }
        ExecutorTemplate truncateTableExecutor = new ExecutorTemplate("truncate-table-");
        for (TableInfo tableInfoCopy : tableInfoCopies) {
            Stopwatch elapsed = Stopwatch.createStarted();
            if (!this.doTruncateTable(tableInfoCopy)) continue;
            remain.decrementAndGet();
            log.info("Exec \"{}\" finished. Elapsed: {}. Remain: [{}/{}]", new Object[]{this.generateTruncateLiteral(tableInfoCopy), elapsed.stop(), remain, size});
        }
        List results = truncateTableExecutor.waitForResult();
        if (results.stream().anyMatch(e -> e == false)) {
            throw new RuntimeException("Truncate some tables failed.");
        }
        int refreshTime = tableInfoCopies.size() > 10 ? 10000 : 5000;
        TimeUtils.sleep(TimeUnit.MILLISECONDS, refreshTime);
        log.info("Wait {} ms for observer to refresh schema finished", (Object)refreshTime);
    }

    private List<SubFile> splitLargeSubFiles(List<ResourceV2> resources) {
        long newBlockSize = this.resetBlockSize(resources);
        log.info("Splitting data files into {} logical chunks...", (Object)FileUtils.byteCountToDisplaySize((long)newBlockSize));
        Stopwatch stopwatch = Stopwatch.createStarted();
        ExecutorTemplate<List> template = new ExecutorTemplate<List>("large-file-splitter-", Constants.AVAILABLE_CPUS);
        for (ResourceV2 resource : resources) {
            template.submit(() -> this.splitLargeSubFile(resource, newBlockSize));
        }
        List result = template.waitForResult();
        AtomicInteger uidGenerator = new AtomicInteger(0);
        List<SubFile> subFiles = result.stream().filter(CollectionUtils::isNotEmpty).flatMap(e -> e.stream().filter(Objects::nonNull)).peek(s -> s.setUid(uidGenerator.getAndIncrement())).collect(Collectors.toList());
        log.info("Split {} data files to {} logical chunks success. Elapsed: {}", new Object[]{resources.size(), subFiles.size(), stopwatch});
        return subFiles;
    }

    private List<SubFile> splitLargeSubFile(ResourceV2 resource, long blockSize) throws Exception {
        if (this.parameter.getDataFormat() == DataFormat.CSV) {
            if ("SAFE".equalsIgnoreCase(System.getProperty("file.split"))) {
                return FileUtils.splitCsvFileSafely(resource, blockSize, this.parameter.initCsvFormatMap().get(resource.getObjectName()));
            }
            return FileUtils.splitCsvFileUnsafely(resource, blockSize, this.parameter.initCsvFormatMap().get(resource.getObjectName()));
        }
        if (this.parameter.getDataFormat() == DataFormat.SQL) {
            return FileUtils.splitSqlFile(resource, blockSize, this.connectionKey.getServerMode());
        }
        if (this.parameter.getDataFormat() == DataFormat.CUT || this.parameter.getDataFormat() == DataFormat.POS) {
            DataFormat dataFormat = this.parameter.getDataFormat();
            boolean skipHeader = this.parameter.isSkipHeader();
            boolean skipFooter = this.parameter.isSkipFooter();
            return FileUtils.splitTxtFileUnsafely(resource, blockSize, dataFormat, skipHeader, skipFooter, this.parameter.getLineSeparator());
        }
        if (this.parameter.getDataFormat() == DataFormat.ORC) {
            return FileUtils.splitOrcFile(resource, this.parameter);
        }
        throw new IllegalArgumentException("Unsupported data format: " + (Object)((Object)this.parameter.getDataFormat()));
    }

    private long resetBlockSize(List<ResourceV2> resources) {
        if (this.blockSize > 0L && CollectionUtils.isNotEmpty(resources)) {
            int largeFileCount = 40000;
            long totalFileSize = 0L;
            for (ResourceV2 resource : resources) {
                long totalMegaByteSize = resource.getTotalSize();
                if (totalMegaByteSize > this.blockSize) {
                    totalFileSize += totalMegaByteSize;
                    continue;
                }
                --largeFileCount;
            }
            if (totalFileSize / this.blockSize > 40000L && largeFileCount > 0) {
                long newBlockSize = NumberUtils.powerOfTwo(totalFileSize / (long)largeFileCount);
                String rawUnit = FileUtils.byteCountToDisplaySize((long)this.blockSize);
                String newUnit = FileUtils.byteCountToDisplaySize((long)newBlockSize);
                log.info("Reset block size from {} to {} avoid generating too many logical chunks....", (Object)rawUnit, (Object)newUnit);
                return newBlockSize;
            }
        }
        return this.blockSize;
    }

    private void findDataFilesForSpecifiedTables(List<ResourceV2> resources) {
        if (new File(this.filePath).isFile()) {
            List<String> tableNames = this.parameter.getDatabase().getTableNames();
            boolean isSingleTable = tableNames != null && tableNames.size() == 1;
            Preconditions.checkArgument((boolean)isSingleTable, (String)"Specified table count=(%s) is unexpected. As -f/--file is a file.", (int)tableNames.size());
            Preconditions.checkArgument((resources.size() == 1 ? 1 : 0) != 0, (String)"Searched resource count=(%s) is unexpected. As -f/--file is a file.", (int)resources.size());
            TableInfo tableInfo = this.parameter.getDatabase().getTableInfo(tableNames.get(0));
            tableInfo.setWithDatafiles(true);
            tableInfo.setWithNonEmptyDatafiles(resources.get(0).getTotalSize() > 0L);
            return;
        }
        for (ResourceV2 resource : resources) {
            String tableName = resource.getObjectName();
            TableInfo tableInfo = this.parameter.getDatabase().getTableInfo(tableName);
            tableInfo.setWithDatafiles(tableName != null);
            tableInfo.setWithNonEmptyDatafiles(tableInfo.isWithNonEmptyDatafiles() || tableName != null && resource.getTotalSize() > 0L);
        }
    }

    private List<SubFile> generateSubFilesForRetry() throws Exception {
        File checkpoint = new File(this.checkpointPath);
        if (!checkpoint.exists() || checkpoint.isDirectory()) {
            throw new FileNotFoundException("The file: \"" + this.checkpointPath + "\" is missing");
        }
        List<SubFile> persistFiles = SerializeUtils.deserializeListByKryo(this.checkpointPath);
        ArrayList<SubFile> recoveryFiles = new ArrayList<SubFile>();
        for (SubFile persistFile : persistFiles) {
            if (TaskState.SUCCESS == persistFile.getTaskState()) continue;
            persistFile.getParsedCount().set(0L);
            persistFile.getLoadedCount().set(0L);
            persistFile.getResource().setStorageConfig(this.parameter.getStorageConfig());
            persistFile.setMessage(null);
            recoveryFiles.add(persistFile);
        }
        for (SubFile item : recoveryFiles) {
            TableInfo tableInfo = this.parameter.getDatabase().getTableInfo(item.getObjectName());
            if (tableInfo == null) {
                throw new IllegalArgumentException("The file: '" + item.getFilePath() + "' has a binding table: '" + item.getObjectName() + "', but the table could not be found.");
            }
            tableInfo.setWithDatafiles(true);
            tableInfo.setWithNonEmptyDatafiles(true);
        }
        log.info("Recovery {} non-success subfiles finished", (Object)recoveryFiles.size());
        return recoveryFiles;
    }

    private List<SubFile> generateSubFilesForNonRetry() throws Exception {
        List<SubFile> subFiles;
        DataFormat dataFormat = this.parameter.getDataFormat();
        ResourceFinderV2 finder = new ResourceFinderV2(this.parameter);
        List<ResourceV2> resources = finder.listRecordResources(false);
        this.findDataFilesForSpecifiedTables(resources);
        resources = resources.stream().filter(i -> i.getTotalSize() > 0L).collect(Collectors.toList());
        StorageConfig storageConfig = this.parameter.getStorageConfig();
        if (storageConfig.getStorageType() == StorageType.LOCAL_DISK && dataFormat.isReadable() && storageConfig.getCompressor().getCompressAlgo() == CompressAlgo.NONE || dataFormat == DataFormat.ORC) {
            subFiles = this.splitLargeSubFiles(resources);
        } else {
            AtomicInteger uidGenerator = new AtomicInteger(0);
            subFiles = resources.stream().map(r -> new SubFile((ResourceV2)r, 0, 0L, r.getTotalSize(), dataFormat, r.getParentDirNames())).peek(s -> s.setUid(uidGenerator.getAndIncrement())).collect(Collectors.toList());
        }
        for (SubFile subFile : subFiles) {
            subFile.setTaskState(TaskState.INITIAL);
            subFile.setObjectType(ObjectType.TABLE.getName());
            subFile.setSchemaName(this.database.getSchemaName());
            subFile.setTaskDetail(new TaskDetail());
            subFile.getTaskDetail().setState(TaskState.INITIAL);
            subFile.getTaskDetail().setTaskType(TaskType.LOAD_RECORD);
            subFile.getTaskDetail().setObject(subFile.getObjectName());
            subFile.getTaskDetail().setType(ObjectType.TABLE.getName());
        }
        return subFiles;
    }
}

