/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.loader;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.oceanbase.tools.loaddump.common.constants.Constants;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdaptiveBatchStrategy {
    private static final Logger log;
    private static final long MAX_BATCH_BYTE_SIZE = 65536L;
    static final TreeMap<Integer, Integer> ADAPTIVE_TREE_MAP;
    private final long maxBatchByteSize;
    private final LoadingCache<Tuple, Integer> consistencyCache;

    public AdaptiveBatchStrategy() {
        this(65536L);
    }

    private AdaptiveBatchStrategy(long maxBatchByteSize) {
        this.maxBatchByteSize = maxBatchByteSize;
        this.consistencyCache = this.createConsistencyCache(maxBatchByteSize);
    }

    LoadingCache<Tuple, Integer> createConsistencyCache(long maxBatchByteSize) {
        return CacheBuilder.newBuilder().initialCapacity(64).maximumSize(100000L).concurrencyLevel(Constants.AVAILABLE_CPUS).build((CacheLoader)new AdaptiveBatchCacheLoader(maxBatchByteSize));
    }

    public int getBatchSize(String tableName, long firstRowSize, int columnCount, int defaultBatch) {
        if (defaultBatch > 0) {
            return defaultBatch;
        }
        if (firstRowSize < 1L || firstRowSize >= 65536L) {
            return 1;
        }
        try {
            return (Integer)this.consistencyCache.get((Object)new Tuple(tableName, columnCount, firstRowSize));
        }
        catch (Exception e) {
            log.debug("Get adaptive batch size failed. Error: {}", (Object)e.getMessage());
            return 1;
        }
    }

    static {
        int i;
        log = LoggerFactory.getLogger(AdaptiveBatchStrategy.class);
        ADAPTIVE_TREE_MAP = new TreeMap();
        for (i = 0; i < 100; ++i) {
            ADAPTIVE_TREE_MAP.put(i, i == 0 ? 1 : i);
        }
        i = 100;
        int j = 1;
        while (i <= 2000) {
            ADAPTIVE_TREE_MAP.put(i, i);
            i = j * 100;
            ++j;
        }
    }

    static class AdaptiveBatchCacheLoader
    extends CacheLoader<Tuple, Integer> {
        private final long maxBatchByteSize;

        public AdaptiveBatchCacheLoader(long maxBatchByteSize) {
            this.maxBatchByteSize = maxBatchByteSize;
        }

        @NotNull
        public Integer load(@NotNull Tuple key) {
            long firstRowSize = key.getFirstRowSize();
            int realBatchSize = (int)(this.maxBatchByteSize / firstRowSize);
            Map.Entry<Integer, Integer> entry = ADAPTIVE_TREE_MAP.floorEntry(realBatchSize);
            return entry == null ? 1 : Math.min(entry.getValue(), 65534 / key.getColumnCount());
        }
    }

    static class Tuple {
        private final String tableName;
        private final int columnCount;
        private final long firstRowSize;

        public Tuple(String tableName, int columnCount, long firstRowSize) {
            this.tableName = tableName;
            this.columnCount = columnCount;
            this.firstRowSize = firstRowSize;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Tuple)) {
                return false;
            }
            Tuple tuple = (Tuple)o;
            return Objects.equals(this.tableName, tuple.tableName);
        }

        public int hashCode() {
            return Objects.hash(this.tableName);
        }

        public String getTableName() {
            return this.tableName;
        }

        public int getColumnCount() {
            return this.columnCount;
        }

        public long getFirstRowSize() {
            return this.firstRowSize;
        }

        public String toString() {
            return "AdaptiveBatchStrategy.Tuple(tableName=" + this.getTableName() + ", columnCount=" + this.getColumnCount() + ", firstRowSize=" + this.getFirstRowSize() + ")";
        }
    }
}

