/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.loader;

import com.alipay.oceanbase.rpc.ObGlobal;
import com.alipay.oceanbase.rpc.protocol.payload.impl.ObLoadDupActionType;
import com.oceanbase.tools.loaddump.common.enums.DirectLoadType;
import com.oceanbase.tools.loaddump.common.model.ConnectionKey;
import com.oceanbase.tools.loaddump.common.model.LoadParameter;
import com.oceanbase.tools.loaddump.common.model.SubFile;
import com.oceanbase.tools.loaddump.common.model.TaskDetail;
import com.oceanbase.tools.loaddump.common.model.TaskState;
import com.oceanbase.tools.loaddump.directpath.DirectPathConnection;
import com.oceanbase.tools.loaddump.loader.AbstractRecordFileLoader;
import com.oceanbase.tools.loaddump.loader.ILoader;
import com.oceanbase.tools.loaddump.loader.partition.DummyPartitionCalculator;
import com.oceanbase.tools.loaddump.loader.partition.PartitionCalculator;
import com.oceanbase.tools.loaddump.loader.writer.AbstractOceanBaseWriter;
import com.oceanbase.tools.loaddump.loader.writer.DirectPathWriter;
import com.oceanbase.tools.loaddump.metrics.Meter;
import com.oceanbase.tools.loaddump.metrics.MetricRegistry;
import com.oceanbase.tools.loaddump.metrics.Slf4jReporter;
import com.oceanbase.tools.loaddump.ringbuffer.RingBufferGroup;
import com.oceanbase.tools.loaddump.throttle.DummyGCThrottle;
import com.oceanbase.tools.loaddump.throttle.MemoryThrottle;
import com.oceanbase.tools.loaddump.throttle.RateLimiterThrottle;
import com.oceanbase.tools.loaddump.throttle.RingBufferThrottle;
import com.oceanbase.tools.loaddump.throttle.ThrottleCenter;
import com.oceanbase.tools.loaddump.utils.DBUtils;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectPathRecordFileLoader
extends AbstractRecordFileLoader {
    private static final Logger log = LoggerFactory.getLogger(DirectPathRecordFileLoader.class);
    private final Map<String, DirectPathConnection> directLoadConnMap = new ConcurrentHashMap<String, DirectPathConnection>();

    public DirectPathRecordFileLoader(LoadParameter parameter) {
        super(parameter);
    }

    @Override
    public void shutdown() throws Exception {
        super.shutdown();
        this.taskDetailList.stream().filter(t -> t.getState() == TaskState.FAILURE).map(TaskDetail::getObject).flatMap(name -> this.taskDetailList.stream().filter(t -> name.equals(t.getObject()))).forEach(t -> {
            t.setState(TaskState.FAILURE);
            t.setCount(0L);
        });
        this.directLoadConnMap.values().forEach(c -> {
            log.info("[Timer] Table: {}, Write Elapsed: {}, Commit Elapsed: {}, Total Elapsed: {}", new Object[]{c.getTableName(), c.getWriteElapsed(), c.getCommitElapsed(), c.getTotalElapsed()});
            c.close();
        });
        this.directLoadConnMap.clear();
    }

    @Override
    protected ILoader doPrepare(List<SubFile> subFiles) throws Exception {
        ILoader loader = super.doPrepare(subFiles);
        this.directLoadConnMap.putAll(this.buildDirectLoadConnMaps(subFiles));
        this.loadCtx.setDirectLoadConnMap(this.directLoadConnMap);
        return loader;
    }

    @Override
    protected String getLoadTaskType() {
        return "Load record";
    }

    @Override
    protected List<SubFile> shuffleSubFiles(List<SubFile> subFiles) {
        return subFiles.stream().collect(Collectors.groupingBy(SubFile::getObjectName)).entrySet().stream().sorted(Comparator.comparingInt(entry -> -((List)entry.getValue()).size())).flatMap(entry -> ((List)entry.getValue()).stream()).collect(Collectors.toList());
    }

    @Override
    protected PartitionCalculator buildPartitionCalculator() {
        return new DummyPartitionCalculator();
    }

    @Override
    protected ThrottleCenter createThrottleCenter(LoadParameter parameter) {
        return new ThrottleCenter(Arrays.asList(new DummyGCThrottle(), new MemoryThrottle(), new RingBufferThrottle(), new RateLimiterThrottle(parameter.getTpsLimit())));
    }

    @Override
    protected void startLogReporter(ScheduledExecutorService executorService, MetricRegistry registry) {
        Supplier<Boolean> stopEvent = () -> !this.directLoadConnMap.isEmpty() && this.directLoadConnMap.values().stream().allMatch(t -> t.isClosed() || t.isCommitting());
        Slf4jReporter.forRegistry(registry).scheduleOn(executorService).shutdownExecutorOnStop(true).build().start(5L, TimeUnit.SECONDS, stopEvent);
    }

    @Override
    protected AbstractOceanBaseWriter[] assembleWriters(Meter dequeueMeter, RingBufferGroup bufferGroup) {
        int writerNum = this.getWriterThreads();
        AbstractOceanBaseWriter[] writers = new DirectPathWriter[writerNum];
        for (int i = 0; i < writerNum; ++i) {
            writers[i] = new DirectPathWriter(this.parameter, this.directLoadConnMap);
            writers[i].setMeter(dequeueMeter);
            writers[i].setBufferGroup(bufferGroup);
            writers[i].setLoadCtx(this.loadCtx);
        }
        return writers;
    }

    private Map<String, DirectPathConnection> buildDirectLoadConnMaps(List<SubFile> subFileList) {
        ConcurrentHashMap<String, DirectPathConnection> objectName2DirectConn = new ConcurrentHashMap<String, DirectPathConnection>();
        Map<String, List<SubFile>> subFileMap = subFileList.stream().collect(Collectors.groupingBy(SubFile::getObjectName));
        boolean incDirectLoadSupported = this.parameter.getDatabase().getServerMode().isSubsequent("4.3.2.0");
        if (incDirectLoadSupported) {
            ConnectionKey connectionKey = this.parameter.getConnectionKey();
            connectionKey.getMetadataProvider().markEmptyTables(connectionKey.getServerMode().isOracleMode(), this.parameter.getDatabase().getTableInfoMap());
        }
        ObLoadDupActionType dupAction = this.parameter.isReplaceData() ? ObLoadDupActionType.REPLACE : (this.parameter.getMaxDiscards() < 0 ? ObLoadDupActionType.IGNORE : ObLoadDupActionType.STOP_ON_DUP);
        Pattern pattern = Pattern.compile("(\\d+)\\.(\\d+)\\.(\\d+)\\.(\\d+)");
        Matcher matcher = pattern.matcher(this.connectionKey.getServerMode().getVersion());
        if (matcher.find() && ObGlobal.OB_VERSION == 0L) {
            ObGlobal.OB_VERSION = ObGlobal.calcVersion((int)Integer.parseInt(matcher.group(1)), (short)((short)Integer.parseInt(matcher.group(2))), (byte)((byte)Integer.parseInt(matcher.group(3))), (byte)((byte)Integer.parseInt(matcher.group(4))));
        }
        subFileMap.forEach((t, subFiles) -> {
            try {
                DirectLoadType directLoadType = DirectLoadType.FULL;
                if (incDirectLoadSupported && !this.parameter.getDatabase().getTableInfo((String)t).isEmptyTable()) {
                    directLoadType = this.parameter.isReplaceData() ? DirectLoadType.INC_REPLACE : DirectLoadType.INC;
                }
                log.info("Direct load method for Table: '{}' is '{}'", t, (Object)directLoadType.getText());
                String directUser = DBUtils.extractObjectName(this.parameter.getConnectUser(), this.parameter.getDatabase().getServerMode());
                String directDatabase = DBUtils.extractObjectName(this.parameter.getConnectDatabaseName(), this.parameter.getDatabase().getServerMode());
                DirectPathConnection conn = new DirectPathConnection.Builder().host(this.parameter.getHost()).port(this.parameter.getRpcPort()).tenant(this.parameter.getTenant()).user(directUser).password(Optional.ofNullable(this.parameter.getPassword()).orElse("")).cluster(this.parameter.getCluster()).publicCloud(this.parameter.isPubCloud()).schema(directDatabase).table((String)t).parallel(this.parameter.getParallel()).thread(this.parameter.getThreads()).maxErrorCount(this.parameter.getMaxErrors()).duplicateKeyAction(dupAction).loadMethod(directLoadType.getText()).directPathConfig(this.parameter.getSessionConfig().getDirectPathLoad()).build();
                objectName2DirectConn.put((String)t, conn);
            }
            catch (Exception e) {
                log.error("Cannot establish connection to server. Table: {}. Reason: {}", t, (Object)e.getMessage());
                throw new IllegalStateException(e);
            }
        });
        return objectName2DirectConn;
    }
}

