/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.loader;

import com.oceanbase.tools.loaddump.common.model.LoadParameter;
import com.oceanbase.tools.loaddump.common.model.Record;
import com.oceanbase.tools.loaddump.common.model.SubFile;
import com.oceanbase.tools.loaddump.common.model.TableInfo;
import com.oceanbase.tools.loaddump.common.thread.ExecutorTemplate;
import com.oceanbase.tools.loaddump.loader.AbstractRecordFileLoader;
import com.oceanbase.tools.loaddump.loader.partition.DummyPartitionCalculator;
import com.oceanbase.tools.loaddump.loader.partition.PartitionCalculator;
import com.oceanbase.tools.loaddump.loader.partition.RealPartitionCalculator;
import com.oceanbase.tools.loaddump.loader.writer.AbstractOceanBaseWriter;
import com.oceanbase.tools.loaddump.loader.writer.JdbcClientWriter;
import com.oceanbase.tools.loaddump.metrics.Meter;
import com.oceanbase.tools.loaddump.metrics.MetricRegistry;
import com.oceanbase.tools.loaddump.metrics.Slf4jReporter;
import com.oceanbase.tools.loaddump.parser.record.AbstractRecordParser;
import com.oceanbase.tools.loaddump.parser.record.RecordWithFieldInfo;
import com.oceanbase.tools.loaddump.ringbuffer.RingBufferGroup;
import com.oceanbase.tools.loaddump.utils.SqlUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcClientRecordFileLoader
extends AbstractRecordFileLoader {
    private static final Logger log = LoggerFactory.getLogger(JdbcClientRecordFileLoader.class);

    public JdbcClientRecordFileLoader(LoadParameter parameter) {
        super(parameter);
    }

    @Override
    protected String getLoadTaskType() {
        return "Load record";
    }

    @Override
    protected PartitionCalculator buildPartitionCalculator() throws Exception {
        boolean flag = this.parameter.enablePartitionCalculation();
        log.info("Partition calculation flag is {}", (Object)flag);
        return flag ? new RealPartitionCalculator(this.parameter) : new DummyPartitionCalculator();
    }

    @Override
    protected void startLogReporter(ScheduledExecutorService executorService, MetricRegistry registry) {
        Slf4jReporter.forRegistry(registry).scheduleOn(executorService).shutdownExecutorOnStop(true).build().start(5L, TimeUnit.SECONDS);
    }

    @Override
    protected AbstractOceanBaseWriter[] assembleWriters(Meter dequeueMeter, RingBufferGroup bufferGroup) {
        int writerNum = this.getWriterThreads();
        AbstractOceanBaseWriter[] writers = new JdbcClientWriter[writerNum];
        for (int i = 0; i < writerNum; ++i) {
            writers[i] = new JdbcClientWriter(this.supervisor, this.parameter);
            writers[i].setMeter(dequeueMeter);
            writers[i].setBufferGroup(bufferGroup);
            writers[i].setLoadCtx(this.loadCtx);
            ((JdbcClientWriter)writers[i]).setConnectionFuture(CompletableFuture.supplyAsync(() -> {
                try {
                    return this.sessionManager.createNewConnection();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }));
        }
        return writers;
    }

    @Override
    protected List<SubFile> shuffleSubFiles(List<SubFile> subFiles) {
        return this.parameter.enablePartitionCalculation() ? this.shuffleSubFilesByRecordPartition(subFiles) : subFiles;
    }

    private List<SubFile> shuffleSubFilesByRecordPartition(List<SubFile> subFiles) {
        if (this.getTablesWithNonEmptyDatafiles().isEmpty()) {
            return subFiles;
        }
        log.info("Waiting to calculate leader for {} sub-files....", (Object)subFiles.size());
        ExecutorTemplate parseFirstRecordExecutor = new ExecutorTemplate("parse-first-record", this.parameter.getThreads());
        subFiles.stream().filter(Objects::nonNull).forEach(subFile -> parseFirstRecordExecutor.submit(() -> Pair.of((Object)this.getLeaderServerOfFirstRecord((SubFile)subFile), (Object)subFile)));
        ArrayList<SubFile> orderedSubFiles = new ArrayList<SubFile>();
        HashMap locationMap = new HashMap(16);
        parseFirstRecordExecutor.waitForResult().forEach(i -> {
            if (i.getLeft() == null) {
                orderedSubFiles.add((SubFile)i.getRight());
            } else {
                List list = locationMap.computeIfAbsent(i.getLeft(), key -> new ArrayList());
                list.add(i.getRight());
            }
        });
        parseFirstRecordExecutor.destroyExecutor();
        if (CollectionUtils.isNotEmpty(orderedSubFiles)) {
            Collections.shuffle(orderedSubFiles);
        }
        locationMap.values().stream().filter(Objects::nonNull).forEach(Collections::sort);
        ArrayList subfieldsGroup = new ArrayList(locationMap.values());
        while (!subfieldsGroup.isEmpty()) {
            int idx = 0;
            while (idx < subfieldsGroup.size()) {
                if (((List)subfieldsGroup.get(idx)).isEmpty()) {
                    subfieldsGroup.remove(idx);
                    continue;
                }
                SubFile subFile2 = (SubFile)((List)subfieldsGroup.get(idx)).get(0);
                orderedSubFiles.add(subFile2);
                ((List)subfieldsGroup.get(idx)).remove(0);
                ++idx;
            }
        }
        return orderedSubFiles;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private RecordWithFieldInfo getFirstRecord(SubFile subFile) {
        try (AbstractRecordParser recordParser = subFile.createRecordParser(this.parameter);){
            Iterator<Record> iter = recordParser.iterator();
            RecordWithFieldInfo recordWithFieldInfo = iter.hasNext() ? new RecordWithFieldInfo(iter.next(), recordParser.getFieldIndexMapping()) : null;
            return recordWithFieldInfo;
        }
        catch (Exception e) {
            log.warn("Ignore parse first record. File: \"{}\". Error: {}", (Object)subFile.getUniquePath(), (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            return null;
        }
    }

    private String getLeaderServerOfFirstRecord(SubFile subFile) {
        Record firstRecord;
        RecordWithFieldInfo firstRecordWithFieldInfo = this.getFirstRecord(subFile);
        if (firstRecordWithFieldInfo == null) {
            log.warn("Ignore the first null record. File: {}", (Object)subFile.getUniquePath());
            return null;
        }
        String table = subFile.getObjectName();
        if (this.parameter.isAutoColumnMapping()) {
            Set<String> fieldNames = firstRecordWithFieldInfo.getFieldIndexMapping().keySet();
            boolean atLeastOneColumnNameMatch = Arrays.stream(this.database.getTableInfoMap().get(table).getCsvHeaders()).anyMatch(fieldNames::contains);
            if (!atLeastOneColumnNameMatch) {
                subFile.setMessage("No column name matches table structure, check file content");
                return "0.0.0.0";
            }
        }
        if ((firstRecord = firstRecordWithFieldInfo.getRecord()).isParsed() && StringUtils.isNotBlank((CharSequence)firstRecord.getOriginContent())) {
            List<Record> recordList = SqlUtils.parseStatement(firstRecord, this.database.getTableInfoMap().get(table));
            firstRecord = recordList.get(0);
        }
        TableInfo tableInfo = this.database.getTableInfo(table);
        long partId = this.partitionCalculator.calculatePartIdForRecord(firstRecord, tableInfo, firstRecordWithFieldInfo.getFieldIndexMapping());
        subFile.setPartitionId(partId);
        return this.partitionCalculator.getLeaderServer(table, partId);
    }
}

