/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.loader;

import com.google.common.base.Preconditions;
import com.oceanbase.tools.loaddump.common.TaskContext;
import com.oceanbase.tools.loaddump.common.enums.DataFormat;
import com.oceanbase.tools.loaddump.common.enums.ServerMode;
import com.oceanbase.tools.loaddump.common.enums.State;
import com.oceanbase.tools.loaddump.common.model.LoadParameter;
import com.oceanbase.tools.loaddump.common.model.SubFile;
import com.oceanbase.tools.loaddump.common.model.TaskDetail;
import com.oceanbase.tools.loaddump.common.model.TaskState;
import com.oceanbase.tools.loaddump.common.thread.ExecutorTemplate;
import com.oceanbase.tools.loaddump.common.thread.ThreadPoolBuilder;
import com.oceanbase.tools.loaddump.loader.AbstractLoader;
import com.oceanbase.tools.loaddump.loader.ILoader;
import com.oceanbase.tools.loaddump.loader.reader.SchemaFileReaderV2;
import com.oceanbase.tools.loaddump.resource.ResourceFinderV2;
import com.oceanbase.tools.loaddump.resource.ResourceV2;
import com.oceanbase.tools.loaddump.utils.DBUtils;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;

public class SchemaFileLoader
extends AbstractLoader {
    private ExecutorService writerExecutor;

    public SchemaFileLoader(LoadParameter parameter) {
        super(parameter);
    }

    @Override
    protected ILoader doPrepare(List<SubFile> subFiles) {
        ExecutorTemplate.setPoolSize(this.parameter.getThreads());
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(subFiles), (Object)"The -schema.sql files are not found.");
        String databaseName = this.parameter.getDatabaseName();
        ServerMode serverMode = this.parameter.getDatabase().getServerMode();
        String schemaName = DBUtils.extractObjectName(databaseName, serverMode);
        for (SubFile subFile : subFiles) {
            subFile.setSchemaName(schemaName);
            subFile.setTaskState(TaskState.INITIAL);
            subFile.setTaskDetail(new TaskDetail());
            this.taskDetailList.add(subFile.getTaskDetail());
        }
        this.writerExecutor = new ThreadPoolBuilder().setCorePoolSize(1).setMaximumPoolSize(1).setQueueSize(subFiles.size()).setThreadPrefixName("load-schema-thread-").build();
        this.state = State.PREPARE;
        return this;
    }

    @Override
    protected TaskContext doLoadRecordAsync(List<SubFile> subFiles) {
        throw new UnsupportedOperationException("Load record is unsupported");
    }

    @Override
    public TaskContext doLoadSchemaAsync(List<SubFile> subFiles) throws Exception {
        super.checkState();
        SchemaFileReaderV2 reader = new SchemaFileReaderV2(this.parameter, subFiles);
        reader.setSupervisor(this.supervisor);
        this.writerExecutor.submit(reader);
        this.state = State.RUNNING;
        return this;
    }

    @Override
    protected List<SubFile> generateSubFiles() throws Exception {
        DataFormat dataFormat = this.parameter.getDataFormat();
        ResourceFinderV2 finder = new ResourceFinderV2(this.parameter);
        List<ResourceV2> resources = finder.listSchemaResources();
        return resources.stream().map(r -> new SubFile((ResourceV2)r, 0, 0L, r.getTotalSize(), dataFormat == DataFormat.MIX ? dataFormat : DataFormat.DDL)).collect(Collectors.toList());
    }

    @Override
    protected String getLoadTaskType() {
        return "Load schema";
    }

    @Override
    public boolean isThreadPoolAlive() {
        return this.isAlive(this.writerExecutor);
    }

    @Override
    public void shutdown() throws Exception {
        this.shutdownInternal(false, this.writerExecutor);
        this.supervisor.compareAndSet(true, false);
        this.state = State.TERMINATE;
    }

    @Override
    public void shutdownNow() throws Exception {
        this.supervisor.compareAndSet(true, false);
        this.shutdownInternal(true, this.writerExecutor);
        this.state = State.TERMINATE;
    }
}

