/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.loader.divider;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import com.oceanbase.tools.loaddump.common.constants.Constants;
import com.oceanbase.tools.loaddump.common.enums.DataFormat;
import com.oceanbase.tools.loaddump.common.enums.ServerMode;
import com.oceanbase.tools.loaddump.common.model.SubFile;
import com.oceanbase.tools.loaddump.loader.divider.AbstractFlatFileDivider;
import com.oceanbase.tools.loaddump.resource.ResourceV2;
import java.io.File;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.List;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlFileDivider
extends AbstractFlatFileDivider {
    private static final Logger log = LoggerFactory.getLogger(SqlFileDivider.class);

    public SqlFileDivider(long blockSize, char escape, char quoteChar) {
        super(blockSize, escape, quoteChar);
    }

    public static SqlFileDivider build(long blockSize, ServerMode serverMode) {
        if (serverMode == ServerMode.ORACLE) {
            return new SqlFileDivider(blockSize, '\ufffe', Constants.CsvConsts.SINGLE_QUOTE_CHAR.charValue());
        }
        return new SqlFileDivider(blockSize, '\\', Constants.CsvConsts.SINGLE_QUOTE_CHAR.charValue());
    }

    @Override
    public List<SubFile> divideFile(@NonNull ResourceV2 resource) throws Exception {
        long end;
        long start;
        if (resource == null) {
            throw new NullPointerException("resource is marked non-null but is null");
        }
        Stopwatch stopwatch = Stopwatch.createStarted();
        String table = resource.getObjectName();
        String path = resource.getPath();
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)table), (Object)"Input table is null");
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)path), (Object)("Input file path is null. Table: %s" + table));
        Preconditions.checkArgument((this.blockSize >= 1L ? 1 : 0) != 0, (String)"Invalid block size: %s. Table: %s", (long)this.blockSize, (Object)table);
        try (RandomAccessFile raf = new RandomAccessFile(new File(path), "r");){
            long length = raf.length();
            if (length <= this.blockSize) {
                ArrayList arrayList = Lists.newArrayList((Object[])new SubFile[]{new SubFile(resource, 0, 0L, length, DataFormat.SQL)});
                return arrayList;
            }
        }
        long[] realPos = this.divideInternal(resource);
        ArrayList<SubFile> subFiles = new ArrayList<SubFile>();
        for (int i = 1; i <= this.chunkNum && (start = realPos[i - 1]) != (end = realPos[i]); ++i) {
            subFiles.add(new SubFile(resource, i, start, end, DataFormat.SQL));
        }
        log.info("File: \"{}\" has been splitted into {} copies. Elapsed: {}", new Object[]{path, subFiles.size(), stopwatch});
        return subFiles;
    }
}

