/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.loader.partition;

import com.alibaba.druid.pool.DruidDataSource;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.oceanbase.partition.calculator.ObPartIdCalculator;
import com.oceanbase.partition.calculator.cache.ObTableCache;
import com.oceanbase.partition.calculator.helper.TableEntryExtractor;
import com.oceanbase.partition.calculator.model.TableEntry;
import com.oceanbase.partition.calculator.model.TableEntryKey;
import com.oceanbase.tools.loaddump.common.SessionManager;
import com.oceanbase.tools.loaddump.common.model.ConnectionKey;
import com.oceanbase.tools.loaddump.common.model.Database;
import com.oceanbase.tools.loaddump.common.model.LoadParameter;
import com.oceanbase.tools.loaddump.common.model.Record;
import com.oceanbase.tools.loaddump.common.model.TableInfo;
import com.oceanbase.tools.loaddump.common.thread.ExecutorTemplate;
import com.oceanbase.tools.loaddump.loader.partition.PartitionCalculator;
import com.oceanbase.tools.loaddump.utils.DBUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import lombok.NonNull;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RealPartitionCalculator
implements PartitionCalculator {
    private static final Logger log = LoggerFactory.getLogger(RealPartitionCalculator.class);
    private boolean noAuthOnQueryLeaderLocation;
    private final LoadParameter parameter;
    private final Map<String, ObPartIdCalculator> tableName2Calculator;
    private final TableEntryExtractor tableEntryExtractor = new TableEntryExtractor();
    private final Map<String, TableEntry> tableEntryMap;
    private final Map<String, Map<Long, String>> tableName2PartId2LeaderServer;

    public RealPartitionCalculator(@NonNull LoadParameter parameter) throws Exception {
        if (parameter == null) {
            throw new NullPointerException("parameter is marked non-null but is null");
        }
        this.parameter = parameter;
        this.tableName2Calculator = new HashMap<String, ObPartIdCalculator>();
        this.tableEntryMap = new HashMap<String, TableEntry>();
        this.tableName2PartId2LeaderServer = new ConcurrentHashMap<String, Map<Long, String>>();
        Set<String> tableNames = this.getTablesWithNonEmptyDatafiles();
        List tableEntries = this.preloadTableEntryCollection(tableNames).stream().filter(Objects::nonNull).collect(Collectors.toList());
        boolean subsequentV4 = parameter.getDatabase().isSubsequentV4();
        for (TableEntry tableEntry : tableEntries) {
            String tblName = tableEntry.getTableName();
            this.tableEntryMap.put(tblName, tableEntry);
            this.tableName2Calculator.put(tblName, parameter.getConnectionKey().createPartitionIdCalculator(tableEntry, subsequentV4));
        }
        this.tableName2PartId2LeaderServer.putAll(this.queryTableLeaderMap(tableNames));
    }

    @Override
    public Long calculatePartIdForRecord(@NonNull Record record, @NonNull TableInfo tableInfo, Map<String, Integer> fieldIndexMapping) {
        if (record == null) {
            throw new NullPointerException("record is marked non-null but is null");
        }
        if (tableInfo == null) {
            throw new NullPointerException("tableInfo is marked non-null but is null");
        }
        ObPartIdCalculator calculator = this.tableName2Calculator.get(tableInfo.getTable());
        if (calculator == null) {
            return Long.MIN_VALUE;
        }
        return DBUtils.calculatePartitionId(tableInfo, calculator, record, fieldIndexMapping);
    }

    @Override
    public String getLeaderServer(@NonNull String table, @NonNull Long partId) {
        if (table == null) {
            throw new NullPointerException("table is marked non-null but is null");
        }
        if (partId == null) {
            throw new NullPointerException("partId is marked non-null but is null");
        }
        Map<Long, String> partLeaderMap = this.tableName2PartId2LeaderServer.get(table);
        Preconditions.checkState((boolean)MapUtils.isNotEmpty(partLeaderMap), (String)"Leader server is empty. Table: \"%s\"", (Object)table);
        String leaderServer = partLeaderMap.get(partId);
        if (leaderServer == null) {
            String errMsg = String.format("Leader server is null. Table: \"%s\", Part: %s", table, partId);
            return (String)((Map.Entry)partLeaderMap.entrySet().stream().findFirst().orElseThrow(() -> new IllegalStateException(errMsg))).getValue();
        }
        return leaderServer;
    }

    @Override
    public Map<String, Map<Long, String>> getTableName2PartId2LeaderServer(@NonNull Set<String> tableNames) {
        if (tableNames == null) {
            throw new NullPointerException("tableNames is marked non-null but is null");
        }
        return this.tableName2PartId2LeaderServer.entrySet().stream().filter(e -> tableNames.contains(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private Set<String> getTablesWithNonEmptyDatafiles() {
        Database database = this.parameter.getDatabase();
        return Sets.newHashSet(database.getTableNames()).stream().filter(table -> {
            if (!database.getTableInfo((String)table).isWithNonEmptyDatafiles()) {
                log.debug("Ignore table: \"{}\" without datafiles.", table);
                return false;
            }
            return true;
        }).collect(Collectors.toSet());
    }

    private List<TableEntry> preloadTableEntryCollection(Set<String> tableNames) {
        Database database = this.parameter.getDatabase();
        int size = tableNames.size();
        AtomicLong remain = new AtomicLong(tableNames.size());
        if (remain.get() <= 0L) {
            log.info("Ignore to query table entry for any tables as they are all without datafiles");
            return Collections.emptyList();
        }
        ExecutorTemplate<TableEntry> preLoadTableExecutor = new ExecutorTemplate<TableEntry>("preload-table-entry-", this.parameter.getThreads());
        for (String tableName : tableNames) {
            TableInfo tableInfo = database.getTableInfo(tableName);
            preLoadTableExecutor.submit(() -> {
                TableEntry tableEntry = this.loadTableEntry(tableInfo);
                long r = remain.decrementAndGet();
                log.info("Query entry for table: \"{}\" finished. Remain: [{}/{}]", new Object[]{tableInfo.getTable(), r, size});
                return tableEntry;
            });
        }
        return preLoadTableExecutor.waitForResult();
    }

    private Map<Long, String> buildInValidPartId2LeaderServer() {
        HashMap<Long, String> partId2LeaderServer = new HashMap<Long, String>();
        partId2LeaderServer.put(Long.MIN_VALUE, "0.0.0.0");
        return partId2LeaderServer;
    }

    private Map<String, Map<Long, String>> queryTableLeaderMap(Set<String> tableNames) throws Exception {
        boolean subsequentV4 = !this.parameter.getDatabase().getServerMode().isPrevious("4.0.0.0");
        int size = tableNames.size();
        AtomicInteger remain = new AtomicInteger(tableNames.size());
        if (remain.get() <= 0) {
            log.info("Ignore to shuffle data files for any tables as they are all without datafiles");
            return new HashMap<String, Map<Long, String>>();
        }
        HashMap<String, Map<Long, String>> tablePartLeaderMap = new HashMap<String, Map<Long, String>>();
        if (this.parameter.getConnectionKey().hasNoSysPrivileges() && !subsequentV4) {
            tableNames.forEach(table -> tablePartLeaderMap.put((String)table, this.buildInValidPartId2LeaderServer()));
            return tablePartLeaderMap;
        }
        ExecutorTemplate<Pair> queryLeaderServerExecutor = new ExecutorTemplate<Pair>("query-leader-location-", this.parameter.getThreads());
        SessionManager sessionManager = this.parameter.getConnectionKey().getSessionManager();
        if (subsequentV4) {
            DruidDataSource dataSource = sessionManager.getBusinessDataSource();
            for (String table2 : tableNames) {
                queryLeaderServerExecutor.submit(() -> {
                    Pair pair;
                    try {
                        pair = Pair.of((Object)table2, this.doQueryTableLeaderMapForOB4x((DataSource)dataSource, table2));
                        remain.decrementAndGet();
                    }
                    catch (Throwable throwable) {
                        remain.decrementAndGet();
                        log.info("Query leader location of table: \"{}\" finished. Remain: [{}/{}]", new Object[]{table2, remain, size});
                        throw throwable;
                    }
                    log.info("Query leader location of table: \"{}\" finished. Remain: [{}/{}]", new Object[]{table2, remain, size});
                    return pair;
                });
            }
        } else {
            DruidDataSource dataSource = sessionManager.getSystemDataSource();
            for (String table3 : tableNames) {
                queryLeaderServerExecutor.submit(() -> {
                    Pair pair;
                    try {
                        pair = Pair.of((Object)table3, this.doQueryTableLeaderMap((DataSource)dataSource, table3));
                        remain.decrementAndGet();
                    }
                    catch (Throwable throwable) {
                        remain.decrementAndGet();
                        log.info("Query leader location of table: \"{}\" finished. Remain: [{}/{}]", new Object[]{table3, remain, size});
                        throw throwable;
                    }
                    log.info("Query leader location of table: \"{}\" finished. Remain: [{}/{}]", new Object[]{table3, remain, size});
                    return pair;
                });
            }
        }
        queryLeaderServerExecutor.waitForResult().forEach(p -> {
            Map cfr_ignored_0 = (Map)tablePartLeaderMap.put((String)p.getLeft(), (Map<Long, String>)p.getRight());
        });
        return tablePartLeaderMap;
    }

    private Map<Long, String> doQueryTableLeaderMapForOB4x(DataSource dataSource, String table) throws SQLException {
        TableEntry tableEntry = this.tableEntryMap.get(table);
        if (tableEntry == null) {
            return this.buildInValidPartId2LeaderServer();
        }
        Throwable throwable = null;
        try (Connection conn = dataSource.getConnection();){
            HashMap<Long, String> hashMap = new HashMap<Long, String>(this.tableEntryExtractor.queryLeaderLocationMap(conn, tableEntry, (List)Lists.newArrayList(tableEntry.getPartIdNameMap().keySet()), true));
            return hashMap;
        }
        catch (Exception e) {
            if (!this.noAuthOnQueryLeaderLocation) {
                log.warn("No authorized to query system tables/views, partition calculation will be disabled. Detail message: {}", (Object)e.getMessage());
                this.noAuthOnQueryLeaderLocation = true;
            }
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        return this.buildInValidPartId2LeaderServer();
    }

    private Map<Long, String> doQueryTableLeaderMap(DataSource dataSource, String table) throws Exception {
        TableEntry tableEntry = this.tableEntryMap.get(table);
        if (tableEntry == null) {
            return this.buildInValidPartId2LeaderServer();
        }
        try (Connection conn = dataSource.getConnection();){
            HashMap<Long, String> hashMap = new HashMap<Long, String>(this.tableEntryExtractor.queryLeaderLocationMap(conn, tableEntry, (List)Lists.newArrayList(tableEntry.getPartIdNameMap().keySet())));
            return hashMap;
        }
    }

    private TableEntry getTableEntryForPubCloud(TableEntryKey tableEntryKey) {
        TableEntry tableEntry = new TableEntry();
        tableEntry.setPartitionNum(Long.valueOf(1L));
        tableEntry.setTableName(tableEntryKey.getTableName());
        tableEntry.setTenantName(tableEntryKey.getTenantName());
        tableEntry.setClusterName(tableEntryKey.getClusterName());
        tableEntry.setDatabaseName(tableEntryKey.getSchemaName());
        tableEntry.setServerMode(tableEntryKey.getServerMode());
        return tableEntry;
    }

    private TableEntry loadTableEntry(TableInfo tableInfo) throws Exception {
        TableEntry table;
        ConnectionKey connectionKey = this.parameter.getConnectionKey();
        SessionManager sessionManager = this.parameter.getConnectionKey().getSessionManager();
        TableEntryKey key = connectionKey.createTableEntryKey(tableInfo.getTable());
        boolean isSubsequentV4 = connectionKey.getServerMode().isSubsequent("4.0.0.0");
        if (connectionKey.hasNoSysPrivileges() && !isSubsequentV4) {
            table = this.getTableEntryForPubCloud(key);
        } else if (isSubsequentV4) {
            try {
                table = this.tableEntryExtractor.queryTableEntry(sessionManager.getBusinessDataSource(), key, true);
            }
            catch (Exception e) {
                table = null;
                if (!this.noAuthOnQueryLeaderLocation) {
                    this.noAuthOnQueryLeaderLocation = true;
                }
            }
        } else {
            table = this.tableEntryExtractor.queryTableEntry(sessionManager.getSystemDataSource(), key, false);
        }
        ObTableCache.getInstance().addTableEntry(table);
        return table;
    }
}

