/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.loader.reader;

import com.oceanbase.tools.loaddump.common.model.ConnectionKey;
import com.oceanbase.tools.loaddump.common.model.LoadParameter;
import com.oceanbase.tools.loaddump.common.model.SubFile;
import com.oceanbase.tools.loaddump.common.model.TaskDetail;
import com.oceanbase.tools.loaddump.loader.reader.IReader;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFileReader
implements IReader {
    private static final Logger log = LoggerFactory.getLogger(AbstractFileReader.class);
    protected static final Logger BAD_RECORD_LOGGER = LoggerFactory.getLogger((String)"BadRecordLogger");
    protected LoadParameter parameter;
    protected String fileEncoding;
    protected String checkpointPath;
    protected boolean subsequentV4;
    protected AtomicBoolean supervisor;
    protected ConnectionKey connectionKey;
    protected List<? extends SubFile> subFiles;

    public AbstractFileReader(@NonNull LoadParameter parameter) {
        if (parameter == null) {
            throw new NullPointerException("parameter is marked non-null but is null");
        }
        this.parameter = parameter;
        this.fileEncoding = parameter.getFileEncoding();
        this.checkpointPath = parameter.getCheckpointPath();
        this.connectionKey = parameter.getConnectionKey();
        this.subsequentV4 = parameter.getDatabase().isSubsequentV4();
    }

    protected void updateTaskDetail(@NonNull SubFile subFile) {
        if (subFile == null) {
            throw new NullPointerException("subFile is marked non-null but is null");
        }
        TaskDetail taskDetail = subFile.getTaskDetail();
        taskDetail.setSchema(subFile.getSchemaName());
        taskDetail.setObject(subFile.getObjectName());
        taskDetail.setType(subFile.getObjectType());
        taskDetail.setState(subFile.getTaskState());
        taskDetail.setError(subFile.getMessage());
        taskDetail.setErrorCounts(subFile.getErrorCounts());
        taskDetail.setTotal(subFile.getParsedCount().get());
        taskDetail.setCount(subFile.getLoadedCount().get());
    }

    protected int runInternal(boolean isShouldRetry) throws Exception {
        throw new UnsupportedOperationException("not implement");
    }

    public void setSupervisor(AtomicBoolean supervisor) {
        this.supervisor = supervisor;
    }
}

