/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.loader.reader;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.lmax.disruptor.RingBuffer;
import com.oceanbase.tools.loaddump.common.model.Insertion;
import com.oceanbase.tools.loaddump.common.model.LoadParameter;
import com.oceanbase.tools.loaddump.common.model.MapObject;
import com.oceanbase.tools.loaddump.common.model.Payload;
import com.oceanbase.tools.loaddump.common.model.Record;
import com.oceanbase.tools.loaddump.common.model.SubFile;
import com.oceanbase.tools.loaddump.common.model.TableInfo;
import com.oceanbase.tools.loaddump.common.model.TaskState;
import com.oceanbase.tools.loaddump.control.ControlManager;
import com.oceanbase.tools.loaddump.loader.AdaptiveBatchStrategy;
import com.oceanbase.tools.loaddump.loader.LoadContext;
import com.oceanbase.tools.loaddump.loader.partition.PartitionCalculator;
import com.oceanbase.tools.loaddump.loader.reader.AbstractFileReader;
import com.oceanbase.tools.loaddump.metrics.Meter;
import com.oceanbase.tools.loaddump.ringbuffer.RingBufferGroup;
import com.oceanbase.tools.loaddump.throttle.LoadThreadStartUpThrottle;
import com.oceanbase.tools.loaddump.utils.CollectionUtils;
import com.oceanbase.tools.loaddump.utils.ExceptionUtils;
import com.oceanbase.tools.loaddump.utils.SerializeUtils;
import com.oceanbase.tools.loaddump.utils.SqlUtils;
import java.lang.invoke.LambdaMetafactory;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecordFileReader
extends AbstractFileReader {
    private static final Logger log = LoggerFactory.getLogger(RecordFileReader.class);
    private TableInfo tableInfo;
    private RingBufferGroup bufferGroup;
    private SubFile subFile;
    private Meter meter;
    private AdaptiveBatchStrategy adaptiveBatchStrategy;
    private int batchSize;
    private LoadContext loadCtx;
    private LoadThreadStartUpThrottle threadThrottle;
    private final boolean canWrite;
    private final ControlManager controlManager;
    private final PartitionCalculator partitionCalculator;

    public RecordFileReader(LoadParameter parameter, List<SubFile> subFiles, PartitionCalculator partitionCalculator) {
        super(parameter);
        this.subFiles = subFiles;
        this.batchSize = parameter.getBatchSize();
        this.canWrite = parameter.isCanWrite();
        this.partitionCalculator = partitionCalculator;
        this.controlManager = parameter.getControlManager();
    }

    @Override
    public void run() {
        try {
            boolean isShouldRetry;
            if (this.subFile.isFailure()) {
                throw new IllegalArgumentException(this.subFile.getMessage());
            }
            if (this.subFile.isSuccess()) {
                return;
            }
            int totalBatch = 0;
            this.subFile.setTaskState(TaskState.RUNNING);
            if (!this.subFile.isVisited()) {
                this.subFile.setVisited(true);
                this.updateCheckpoint();
            }
            boolean bl = isShouldRetry = this.parameter.isRetry() && this.subFile.isVisited();
            if (isShouldRetry) {
                Preconditions.checkState((CollectionUtils.isNotEmpty(this.tableInfo.getPrimaryCols()) || MapUtils.isNotEmpty(this.tableInfo.getNotNullUniqueKeyMap()) ? 1 : 0) != 0, (Object)("Table: " + this.subFile.getObjectName() + " doesn't have primary key or non-null unique keys, so it can not be retried"));
            }
            totalBatch = this.runInternal(isShouldRetry);
            log.info("File: \"{}\" has been read finished.", (Object)this.subFile.getUniquePath());
            if (this.supervisor.get()) {
                this.loadCtx.waitForAllBatchesConsumed(this.subFile, totalBatch);
            }
        }
        catch (Throwable e) {
            String cause = ExceptionUtils.getRootCauseMessage(e);
            this.subFile.setMessage(cause);
            this.subFile.setTaskState(TaskState.FAILURE);
            log.error("Load data file: \"{}\" failed.", (Object)this.subFile.getUniquePath(), (Object)e);
        }
        finally {
            this.updateCurrentTaskState();
            this.updateCheckpoint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected int runInternal(boolean isShouldRetry) throws Exception {
        if (!this.threadThrottle.tryAcquire(new Payload(), this.parameter.getMaxWaitTimeMillis(), TimeUnit.MILLISECONDS)) {
            throw new IllegalStateException("Throttle is blocked too long, waiting " + this.parameter.getMaxWaitTimeMillis() + " ms");
        }
        totalBatch = 0;
        payloadMap = new HashMap<Long, Payload>(16);
        currentRecordParser = this.subFile.createRecordParser(this.parameter);
        var5_5 = null;
        try {
            fullColumnNameList = Arrays.asList(this.tableInfo.getCsvHeaders());
            iter = currentRecordParser.iterator();
            autoColumnMapping = this.parameter.isAutoColumnMapping();
            fieldNameList = currentRecordParser.getFieldNameList();
            columnCount = fullColumnNameList.size();
            isFirstRecord = true;
lbl15:
            // 2 sources

            while (true) {
                block36: {
                    block38: {
                        block37: {
                            if (!this.supervisor.get() || this.subFile.isFailure() || !iter.hasNext()) break block36;
                            if (this.loadCtx.shouldFail(this.tableInfo.getTable())) {
                                var12_15 = totalBatch;
                                return var12_15;
                            }
                            record = iter.next();
                            if (this.subFile.isSkipFooter() && !iter.hasNext()) {
                                footer = record == null ? "<No Footer>" : (record.isValid() != false ? record.getValues().toString() : record.getOriginContent());
                                RecordFileReader.log.debug("Skip footer: \"{}\" finish", (Object)footer);
                                continue;
                            }
                            recordList = new ArrayList();
                            if (!record.isParsed()) break block37;
                            if (record.isValid()) {
                                recordList = Lists.newArrayList((Object[])new Record[]{record});
                                break block38;
                            } else if (StringUtils.isNotBlank((CharSequence)record.getOriginContent())) {
                                recordList = SqlUtils.parseStatement(record, this.tableInfo);
                            }
                            break block38;
                        }
                        recordList = Lists.newArrayList((Object[])new Record[]{record});
                    }
                    this.subFile.addParsedCount(recordList.size());
                    var14_18 = recordList.iterator();
                    break;
                }
                if (payloadMap.isEmpty() != false) return totalBatch;
                var12_14 = payloadMap.entrySet().iterator();
                while (var12_14.hasNext() != false) {
                    entry = var12_14.next();
                    if (((Payload)entry.getValue()).getRecordCount() <= 0) continue;
                    this.enqueue((Payload)entry.getValue(), (Long)entry.getKey(), isShouldRetry, fieldNameList, fullColumnNameList);
                    ++totalBatch;
                }
                return totalBatch;
            }
        }
        catch (Throwable var6_8) {
            var5_5 = var6_8;
            throw var6_8;
        }
        finally {
            payloadMap.clear();
            this.threadThrottle.release(new Payload());
        }
        while (true) {
            if (var14_18.hasNext()) ** break;
            ** continue;
            var15_20 = (Record)var14_18.next();
            byteSize = var15_20.getByteSize(this.fileEncoding);
            if (isFirstRecord) {
                this.batchSize = this.adaptiveBatchStrategy.getBatchSize(this.tableInfo.getTable(), byteSize, columnCount, this.parameter.getBatchSize());
                isFirstRecord = false;
                if (!Objects.equals(this.batchSize, this.parameter.getBatchSize())) {
                    RecordFileReader.log.info("Reset batch size [{}->{}] for table \"{}\".", new Object[]{this.parameter.getBatchSize(), this.batchSize, this.tableInfo.getTable()});
                }
            }
            partId = this.partitionCalculator.calculatePartIdForRecord(var15_20, this.tableInfo, currentRecordParser.getFieldIndexMapping());
            var15_19 = this.doCleaning(this.tableInfo.getSchema(), this.tableInfo.getTable(), var15_20);
            singleRecordSize = var15_19.getValues() == null ? 0 : var15_19.getValues().size();
            fieldNameListSize = fieldNameList == null ? 0 : fieldNameList.size();
            v0 = columnCountMismatchFlag = autoColumnMapping != false && singleRecordSize != fieldNameListSize || autoColumnMapping == false && singleRecordSize != columnCount;
            if (!var15_19.isValid() || columnCountMismatchFlag) {
                insertSql = CollectionUtils.isEmpty(var15_19.getValues()) != false ? var15_19.getOriginContent() : this.tableInfo.toInsertSql(var15_19, fieldNameList);
                RecordFileReader.BAD_RECORD_LOGGER.error("{}\nCause: {}\n", (Object)insertSql, (Object)(StringUtils.isEmpty((CharSequence)var15_19.getBadCause()) != false ? "The number of columns parsed does not match the number of columns in the table" : var15_19.getBadCause()));
                if (!this.loadCtx.incrementAndIsExceedMaxErrors(this.tableInfo.getTable())) continue;
                this.subFile.setMessage("Too many bad records were found in file: " + this.subFile.getFilePath() + ". See the bad record in \"ob-loader-dumper.bad\"");
                var23_27 = totalBatch;
                return var23_27;
            }
            payload = payloadMap.computeIfAbsent(partId, (Function<Long, Payload>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$runInternal$0(java.lang.Long ), (Ljava/lang/Long;)Lcom/oceanbase/tools/loaddump/common/model/Payload;)()).addRecord(var15_19).addByteSize(byteSize);
            if (!this.shouldCommit(payload)) continue;
            this.enqueue(payload, partId, isShouldRetry, fieldNameList, fullColumnNameList);
            ++totalBatch;
        }
    }

    private void enqueue(Payload payload, long partId, boolean isRetryMode, List<String> fieldNameList, List<String> fullColumnNameList) throws Exception {
        Insertion insertion = new Insertion(this.subFile, partId, isRetryMode);
        insertion.setRecordList(payload.getRecordList());
        insertion.setFieldNameList(fieldNameList);
        insertion.setFullColumnNameList(fullColumnNameList);
        insertion.setByteSize(payload.getByteSize());
        insertion.setLeaderServer(this.partitionCalculator.getLeaderServer(this.tableInfo.getTable(), partId));
        payload.reset();
        this.enqueue(insertion);
    }

    private boolean shouldCommit(Payload payload) {
        int recordCount = payload.getRecordCount();
        return recordCount > 0 && recordCount % this.batchSize == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void enqueue(Insertion insertion) throws Exception {
        this.threadThrottle.release(new Payload(insertion));
        String leaderServer = insertion.getLeaderServer();
        RingBuffer<Insertion> buffer = this.bufferGroup.getBuffer(leaderServer);
        this.loadCtx.batchProduced(insertion, buffer);
        long sequence = buffer.next();
        try {
            Insertion event = (Insertion)buffer.get(sequence);
            event.setRetry(insertion.isRetry());
            event.setSubFile(insertion.getSubFile());
            event.setByteSize(insertion.getByteSize());
            event.setRecordList(insertion.getRecordList());
            event.setFullColumnNameList(insertion.getFullColumnNameList());
            event.setFieldNameList(insertion.getFieldNameList());
            event.setPartitionId(insertion.getPartitionId());
            event.setLeaderServer(insertion.getLeaderServer());
            event.setCommit(insertion.isCommit());
            long produced = (long)buffer.getBufferSize() - buffer.remainingCapacity();
            this.meter.mark(leaderServer, insertion.getRecordCount(), insertion.getByteSize(), produced);
        }
        finally {
            buffer.publish(sequence);
        }
    }

    protected Record doCleaning(String schemaName, String tableName, Record record) {
        if (this.controlManager == null || !this.controlManager.isControlDefined(schemaName, tableName) || !record.isValid()) {
            return record;
        }
        String schemaTable = this.tableInfo.getSchemaTable();
        Map<String, MapObject> columnIndexMapping = this.tableInfo.getColumnIndexMapping();
        ArrayList newValues = Lists.newArrayListWithCapacity((int)columnIndexMapping.size());
        try {
            for (Map.Entry<String, MapObject> entry : columnIndexMapping.entrySet()) {
                String columnName = entry.getKey();
                MapObject mapObj = entry.getValue();
                Integer srcOffset = mapObj.getSource();
                if (srcOffset == null && mapObj.getGeneratedDefine() != null) {
                    newValues.add(mapObj.getGeneratedDefine().getValue());
                    continue;
                }
                Preconditions.checkArgument((srcOffset != null ? 1 : 0) != 0, (String)"Cannot find a match for column %s of table %s. It may caused by invalid definitions in control file", (Object)columnName, (Object)schemaTable);
                newValues.add(this.controlManager.transform(schemaName, tableName, columnName, record.getString(srcOffset)));
            }
            record.replaceAll(newValues);
        }
        catch (Exception e) {
            record.setParsed(false);
            record.setBadCause(ExceptionUtils.getRootCauseMessage(e));
            log.error("Clean data failed. Record: [{}]. Reason: {}.", (Object)record, (Object)ExceptionUtils.getRootCauseMessage(e));
        }
        return record;
    }

    protected void updateCurrentTaskState() {
        long failedRecordCnt = this.subFile.getParsedCount().get() - this.subFile.getLoadedCount().get();
        if (StringUtils.isNotBlank((CharSequence)this.subFile.getMessage())) {
            this.subFile.compareAndSetState(TaskState.RUNNING, TaskState.FAILURE);
            log.error("Fatal error occurred while loading data from \"{}\" into table {}. Reason: {}", new Object[]{this.subFile.getFilePath(), this.tableInfo.getSchemaTable(), this.subFile.getMessage()});
        } else if (failedRecordCnt > 0L) {
            String errMsg = MessageFormat.format("Failed to load {0} records from \"{1}\" into table {2}. Check \"ob-loader-dumper.bad\" and \"ob-loader-dumper.discard\" for details", failedRecordCnt, this.subFile.getFilePath(), this.tableInfo.getSchemaTable());
            log.warn(errMsg);
            if (StringUtils.isEmpty((CharSequence)this.subFile.getMessage())) {
                this.subFile.setMessage(errMsg);
            }
            this.subFile.compareAndSetState(TaskState.RUNNING, this.loadCtx.isStrict() ? TaskState.FAILURE : TaskState.SUCCESS);
        } else {
            this.subFile.compareAndSetState(TaskState.RUNNING, TaskState.SUCCESS);
        }
        this.updateTaskDetail(this.subFile);
    }

    private void updateCheckpoint() {
        if (this.canWrite) {
            try {
                SerializeUtils.serializeListByKryo(this.subFiles, this.checkpointPath);
            }
            catch (Throwable e) {
                log.warn("Unable to serialize the checkpoint file. But it won't affect the data integrity. Reason: {}", (Object)ExceptionUtils.getRootCauseMessage(e));
            }
        }
    }

    public void setTableInfo(TableInfo tableInfo) {
        this.tableInfo = tableInfo;
    }

    public void setBufferGroup(RingBufferGroup bufferGroup) {
        this.bufferGroup = bufferGroup;
    }

    public void setSubFile(SubFile subFile) {
        this.subFile = subFile;
    }

    public void setMeter(Meter meter) {
        this.meter = meter;
    }

    public void setAdaptiveBatchStrategy(AdaptiveBatchStrategy adaptiveBatchStrategy) {
        this.adaptiveBatchStrategy = adaptiveBatchStrategy;
    }

    public void setLoadCtx(LoadContext loadCtx) {
        this.loadCtx = loadCtx;
    }

    public void setThreadThrottle(LoadThreadStartUpThrottle threadThrottle) {
        this.threadThrottle = threadThrottle;
    }

    private static /* synthetic */ Payload lambda$runInternal$0(Long v) {
        return new Payload();
    }
}

