/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.loader.writer;

import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.WorkHandler;
import com.oceanbase.tools.loaddump.common.model.Insertion;
import com.oceanbase.tools.loaddump.common.model.LoadParameter;
import com.oceanbase.tools.loaddump.loader.LoadContext;
import com.oceanbase.tools.loaddump.loader.writer.IWriter;
import com.oceanbase.tools.loaddump.metrics.Meter;
import com.oceanbase.tools.loaddump.ringbuffer.RingBufferGroup;

public abstract class AbstractOceanBaseWriter
implements IWriter,
WorkHandler<Insertion> {
    protected LoadContext loadCtx;
    protected Meter meter;
    protected RingBufferGroup bufferGroup;
    protected LoadParameter parameter;

    public AbstractOceanBaseWriter(LoadParameter parameter) {
        this.parameter = parameter;
    }

    public void shutdown() {
    }

    public abstract void onEvent(Insertion var1) throws Exception;

    protected long getConsumedSlots(String leaderServer) {
        RingBuffer<Insertion> buffer = this.bufferGroup.getBuffer(leaderServer);
        return (long)buffer.getBufferSize() - buffer.remainingCapacity();
    }

    public LoadContext getLoadCtx() {
        return this.loadCtx;
    }

    public void setLoadCtx(LoadContext loadCtx) {
        this.loadCtx = loadCtx;
    }

    public void setMeter(Meter meter) {
        this.meter = meter;
    }

    public void setBufferGroup(RingBufferGroup bufferGroup) {
        this.bufferGroup = bufferGroup;
    }
}

