/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.loader.writer;

import com.lmax.disruptor.WorkHandler;
import com.oceanbase.tools.loaddump.common.JavaOpts;
import com.oceanbase.tools.loaddump.common.model.Insertion;
import com.oceanbase.tools.loaddump.common.model.LoadParameter;
import com.oceanbase.tools.loaddump.common.model.Record;
import com.oceanbase.tools.loaddump.common.model.SubFile;
import com.oceanbase.tools.loaddump.common.model.TaskState;
import com.oceanbase.tools.loaddump.directpath.DirectPathConnection;
import com.oceanbase.tools.loaddump.directpath.DirectPathPreparedStatement;
import com.oceanbase.tools.loaddump.loader.writer.AbstractOceanBaseWriter;
import com.oceanbase.tools.loaddump.utils.CollectionUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectPathWriter
extends AbstractOceanBaseWriter
implements WorkHandler<Insertion> {
    private static final Logger log = LoggerFactory.getLogger(DirectPathWriter.class);
    private final Map<String, DirectPathConnection> directLoadConnMap;

    public DirectPathWriter(LoadParameter parameter, Map<String, DirectPathConnection> directLoadConnMap) {
        super(parameter);
        this.directLoadConnMap = directLoadConnMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onEvent(Insertion insertion) throws Exception {
        SubFile subFile = insertion.getSubFile();
        if (subFile.getTaskState() == TaskState.FAILURE) {
            this.loadCtx.batchConsumed(insertion);
            return;
        }
        String tableName = insertion.getTable();
        List<Record> recordList = insertion.getRecordList();
        if (JavaOpts.isDryRunMode) {
            int size = Optional.ofNullable(recordList).map(List::size).orElse(0);
            this.meter.mark(insertion.getLeaderServer(), size, insertion.getByteSize(), this.getConsumedSlots(insertion.getLeaderServer()));
            subFile.addLoadedCount(size);
            subFile.addLoadedBytes(insertion.getByteSize());
            this.loadCtx.batchConsumed(insertion);
            return;
        }
        List<String> fieldNameList = insertion.getFieldNameList();
        List<String> fullColumnNameList = insertion.getFullColumnNameList();
        HashMap<Integer, Integer> targetToSourceIndexMap = new HashMap<Integer, Integer>();
        if (CollectionUtils.isNotEmpty(fieldNameList)) {
            HashMap<String, Integer> fieldIndexMap = new HashMap<String, Integer>();
            int j = 0;
            for (String string : fieldNameList) {
                fieldIndexMap.put(string, j++);
            }
            j = 0;
            for (String throwable : fullColumnNameList) {
                Integer index = (Integer)fieldIndexMap.get(throwable);
                if (index != null) {
                    targetToSourceIndexMap.put(j, index);
                }
                ++j;
            }
        }
        DirectPathConnection conn = this.directLoadConnMap.get(tableName);
        try {
            if (conn.isInit()) {
                conn.begin();
            }
            DirectPathPreparedStatement stmt = conn.createStatement();
            Object object = null;
            try {
                for (Record record : recordList) {
                    stmt.addBatch(record.getValues(), fieldNameList, fullColumnNameList.size(), targetToSourceIndexMap);
                }
                long l = System.currentTimeMillis();
                int[] result = stmt.executeBatch();
                if (JavaOpts.isDebugable) {
                    log.info("[{}] Insert {} rows success. Elapsed: {} ms", new Object[]{Thread.currentThread().getName(), Arrays.stream(result).sum(), System.currentTimeMillis() - l});
                }
                stmt.clearBatch();
                this.meter.mark(insertion.getLeaderServer(), result.length, insertion.getByteSize(), this.getConsumedSlots(insertion.getLeaderServer()));
                subFile.addLoadedCount(result.length);
                subFile.addLoadedBytes(insertion.getByteSize());
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (stmt != null) {
                    if (object != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        stmt.close();
                    }
                }
            }
        }
        catch (Throwable ex) {
            subFile.setMessage("Write into table \"" + tableName + "\" failed. " + ex.getMessage());
            subFile.setTaskState(TaskState.FAILURE);
            this.getLoadCtx().markTableFail(tableName);
        }
        finally {
            this.loadCtx.batchConsumed(insertion);
        }
    }
}

