/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.loader.writer;

import com.github.rholder.retry.Retryer;
import com.github.rholder.retry.RetryerBuilder;
import com.github.rholder.retry.StopStrategy;
import com.github.rholder.retry.WaitStrategies;
import com.google.common.base.Stopwatch;
import com.oceanbase.tools.loaddump.common.JavaOpts;
import com.oceanbase.tools.loaddump.common.exception.NonRetryableException;
import com.oceanbase.tools.loaddump.common.exception.RetryableException;
import com.oceanbase.tools.loaddump.common.model.ConnectionKey;
import com.oceanbase.tools.loaddump.common.model.Database;
import com.oceanbase.tools.loaddump.common.model.Insertion;
import com.oceanbase.tools.loaddump.common.model.LoadParameter;
import com.oceanbase.tools.loaddump.common.model.Record;
import com.oceanbase.tools.loaddump.common.model.SqlContext;
import com.oceanbase.tools.loaddump.common.model.SubFile;
import com.oceanbase.tools.loaddump.common.model.TableInfo;
import com.oceanbase.tools.loaddump.common.model.TaskState;
import com.oceanbase.tools.loaddump.loader.LoadContext;
import com.oceanbase.tools.loaddump.loader.SmartStopStrategy;
import com.oceanbase.tools.loaddump.loader.writer.AbstractOceanBaseWriter;
import com.oceanbase.tools.loaddump.utils.CollectionUtils;
import com.oceanbase.tools.loaddump.utils.ExceptionUtils;
import com.oceanbase.tools.loaddump.utils.JdbcUtils;
import com.oceanbase.tools.loaddump.utils.SqlNotesUtil;
import com.oceanbase.tools.loaddump.utils.SqlUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.NonNull;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcClientWriter
extends AbstractOceanBaseWriter {
    private static final Logger log = LoggerFactory.getLogger(JdbcClientWriter.class);
    private static final int MIN_RETRY_TIMES = 1;
    private static final int MAX_RETRY_TIMES = 5;
    private static final Logger BAD_RECORD_LOGGER = LoggerFactory.getLogger((String)"BadRecordLogger");
    private static final Logger DIS_RECORD_LOGGER = LoggerFactory.getLogger((String)"DisRecordLogger");
    protected final Retryer<Boolean> retryer;
    protected final RetryCallback retryCallback;
    protected Database database;
    protected boolean replaceData;
    protected AtomicBoolean supervisor;
    protected ConnectionKey connectionKey;
    protected Connection connectionHolder;
    protected CompletableFuture<Connection> connectionFuture;

    public JdbcClientWriter(AtomicBoolean supervisor, LoadParameter parameter) {
        super(parameter);
        this.connectionKey = parameter.getConnectionKey();
        this.supervisor = supervisor;
        this.retryCallback = new RetryCallback(this);
        this.database = parameter.getDatabase();
        this.replaceData = parameter.isReplaceData();
        this.retryer = this.createRetryer(parameter.isFailFast() ? 1 : 5);
    }

    private Retryer<Boolean> createRetryer(int maxAttempts) {
        return RetryerBuilder.newBuilder().retryIfExceptionOfType(RetryableException.class).withWaitStrategy(WaitStrategies.exponentialWait((long)1L, (long)60L, (TimeUnit)TimeUnit.SECONDS)).withStopStrategy((StopStrategy)new SmartStopStrategy(this.supervisor, maxAttempts)).build();
    }

    @Override
    public void onEvent(Insertion insertion) {
        String table = insertion.getTable();
        SubFile subFile = insertion.getSubFile();
        try {
            if (this.loadCtx.isExceedMaxErrors(table)) {
                this.loadCtx.batchConsumed(insertion);
                return;
            }
            this.retryer.call((Callable)this.retryCallback.withInsertion(insertion));
        }
        catch (Throwable ex) {
            subFile.setTaskState(TaskState.FAILURE);
            subFile.setMessage(MessageFormat.format("Load data into \"{0}\".\"{1}\" failed! {2}", subFile.getSchemaName(), subFile.getObjectName(), ExceptionUtils.getRootCauseMessage(ex)));
            this.loadCtx.batchConsumed(insertion);
        }
    }

    public Connection getConnection() {
        try {
            if (this.connectionFuture != null) {
                this.connectionHolder = this.connectionFuture.get();
            }
            if (this.connectionHolder != null && !this.connectionHolder.isClosed()) {
                Connection connection = this.connectionHolder;
                return connection;
            }
            this.resetConnection();
            Connection connection = this.connectionHolder;
            return connection;
        }
        catch (Throwable e) {
            if (e instanceof InterruptedException) {
                throw new NonRetryableException(e);
            }
            throw new RetryableException(e);
        }
        finally {
            this.connectionFuture = null;
        }
    }

    public void resetConnection() throws Throwable {
        if (this.connectionHolder == null || this.connectionHolder.isClosed()) {
            JdbcUtils.close(this.connectionHolder);
            log.warn("The connection holder is invalid or closed, reset a new direct connection now...");
            try {
                Stopwatch stopwatch = Stopwatch.createStarted();
                this.connectionHolder = this.connectionKey.getSessionManager().getPooledBizConnection();
                log.warn("Reset a new direct connection and init session variables finished. Elapsed: {}", (Object)stopwatch);
            }
            catch (Exception e) {
                throw ExceptionUtils.getRootCause((Throwable)e);
            }
        }
    }

    @Override
    public void shutdown() {
        try {
            if (this.connectionFuture != null) {
                this.connectionFuture.cancel(true);
            }
            if (this.connectionHolder != null && !this.connectionHolder.isClosed()) {
                this.connectionHolder.close();
            }
        }
        catch (Exception ex) {
            log.debug("Shutdown connection failed. Reason: {}", (Object)ExceptionUtils.getRootCauseMessage(ex));
        }
    }

    public void setConnectionFuture(CompletableFuture<Connection> connectionFuture) {
        this.connectionFuture = connectionFuture;
    }

    public static class RetryCallback
    implements Callable<Boolean> {
        protected JdbcClientWriter writer;
        protected Insertion insertion;

        public RetryCallback(JdbcClientWriter writer) {
            this.writer = writer;
        }

        public RetryCallback withInsertion(Insertion insertion) {
            this.insertion = insertion;
            return this;
        }

        @Override
        public Boolean call() throws Exception {
            Boolean result = this.doCall();
            this.writer.loadCtx.batchConsumed(this.insertion);
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Boolean doCall() throws Exception {
            List<Record> recordList = this.insertion.getRecordList();
            if (CollectionUtils.isEmpty(recordList)) {
                return true;
            }
            SubFile subFile = this.insertion.getSubFile();
            String table = this.insertion.getTable();
            TableInfo tableInfo = this.writer.database.getTableInfo(table);
            boolean status = true;
            int affectRows = 0;
            int recordCount = recordList.size();
            if (this.writer.loadCtx.isExceedMaxErrors(table)) {
                log.error("Too many errors occurred while loading into table \"{}\"", (Object)table);
                subFile.setTaskState(TaskState.FAILURE);
                return true;
            }
            Connection conn = this.writer.getConnection();
            if (this.writer.replaceData) {
                if (tableInfo.isMySqlMode()) {
                    tableInfo.switchToReplaceIntoPrefix();
                } else if (!this.insertion.isRetried() && tableInfo.getServer().isPrevious("2.2.76") && (tableInfo.hasPrimaryKey() || tableInfo.hasUniqueKey())) {
                    SqlContext ctx = this.buildBatchDeleteSqlContext(tableInfo, recordList);
                    affectRows = this.executeUpdate(conn, ctx);
                    log.info("Delete {} duplicated records with --replace-data success", (Object)affectRows);
                }
            }
            long begin = 0L;
            if (JavaOpts.isDebugable || log.isDebugEnabled()) {
                begin = System.nanoTime();
            }
            if (Insertion.Mode.BATCH == this.insertion.getMode()) {
                SqlContext ctx = this.buildBatchSqlContext(tableInfo, recordList);
                if (JavaOpts.isDryRunMode) {
                    affectRows = ctx.getCount();
                } else {
                    try {
                        affectRows = this.writer.database.isLogicalDatabase() ? this.executeBatch(conn, ctx) : this.executeUpdate(conn, ctx);
                    }
                    catch (Exception ex) {
                        this.translateBatchModeException(tableInfo, ex);
                    }
                }
                status = ctx.isCompleted();
            } else {
                for (SqlContext ctx : this.buildSerialSqlContext(tableInfo, recordList)) {
                    status &= ctx.isCompleted();
                    try {
                        affectRows += Math.min(this.executeUpdate(conn, ctx), 1);
                    }
                    catch (Exception ex) {
                        this.translateSerialModeException(tableInfo, ctx.getBatchArgs(), this.insertion.getFieldNameList(), affectRows, ex);
                    }
                    finally {
                        ctx.clearAll();
                    }
                }
            }
            if (JavaOpts.isDebugable || log.isDebugEnabled()) {
                String schemaTable = tableInfo.getSchemaTable();
                String threadName = Thread.currentThread().getName();
                long elapsed = (System.nanoTime() - begin) / 1000000L;
                log.info("[{}] JDBC insert {} rows elapsed: {} ms. Table: {}", new Object[]{threadName, recordCount, elapsed, schemaTable});
            }
            int loadedCount = Math.min(affectRows, recordCount);
            long byteSize = this.insertion.getByteSize();
            String leaderServer = this.insertion.getLeaderServer();
            long consumed = this.writer.getConsumedSlots(leaderServer);
            this.writer.meter.mark(leaderServer, loadedCount, byteSize, consumed);
            subFile.addLoadedBytes(byteSize);
            subFile.addLoadedCount(loadedCount);
            return status;
        }

        protected List<SqlContext> buildSerialSqlContext(TableInfo tableInfo, List<Record> recordList) {
            if (this.writer.replaceData && tableInfo.isOracleMode() && !tableInfo.getServer().isPrevious("2.2.76") && (CollectionUtils.isNotEmpty(tableInfo.getPrimaryCols()) || MapUtils.isNotEmpty(tableInfo.getNotNullUniqueKeyMap()))) {
                return SqlUtils.translateMergeIntoSingleStatement(tableInfo, recordList, this.insertion.getFieldNameList());
            }
            return SqlUtils.translateInsertSingleValueSqlContext(tableInfo, recordList, this.insertion.getFieldNameList());
        }

        protected SqlContext buildBatchSqlContext(TableInfo tableInfo, List<Record> recordList) {
            SqlContext ctx = this.insertion.getSqlContext();
            if (ctx != null && this.insertion.isRetried() && !this.writer.replaceData) {
                return ctx;
            }
            List<String> fieldNameList = this.insertion.getFieldNameList();
            if (this.writer.database.isLogicalDatabase()) {
                ctx = SqlUtils.translateInsertBatchValueSqlContext(tableInfo, recordList, fieldNameList);
            } else {
                try {
                    ctx = SqlUtils.translateInsertMultiValuesSqlContext(tableInfo, recordList, fieldNameList);
                }
                catch (Exception e) {
                    ctx = SqlUtils.translateInsertBatchValueSqlContext(tableInfo, recordList, fieldNameList);
                }
            }
            this.insertion.setRetried(true);
            this.insertion.setSqlContext(ctx);
            return this.insertion.getSqlContext();
        }

        protected SqlContext buildBatchDeleteSqlContext(TableInfo tableInfo, List<Record> recordList) {
            SqlContext ctx = this.insertion.getSqlContext();
            if (ctx != null && this.insertion.isRetried() && this.writer.replaceData) {
                return ctx;
            }
            ctx = SqlUtils.translateDeleteSqlContext(tableInfo, recordList);
            this.insertion.setRetried(true);
            this.insertion.setSqlContext(ctx);
            return this.insertion.getSqlContext();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public int executeUpdate(Connection conn, SqlContext ctx) throws Exception {
            if (ctx.getCount() == 0) {
                return 0;
            }
            String sql = ctx.getSql();
            List<List<Object>> batchArgs = ctx.getBatchArgs();
            try (PreparedStatement pstmt = conn.prepareStatement(SqlNotesUtil.addLoaderDumperNotes(sql));){
                pstmt.clearParameters();
                int index = 1;
                for (List<Object> args : batchArgs) {
                    for (int i = 0; i < args.size(); ++i) {
                        index = ctx.getPsStmtSetters().get(i).setObject(args.get(i), index, pstmt);
                    }
                }
                int n = pstmt.executeUpdate();
                return n;
            }
            catch (Exception ex) {
                if (!log.isDebugEnabled()) throw new SQLException(ex);
                log.debug("SQL: {}, args: {}", (Object)sql, batchArgs);
                throw new SQLException(ex);
            }
        }

        /*
         * Exception decompiling
         */
        public int executeBatch(Connection conn, SqlContext ctx) throws Exception {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private void translateBatchModeException(@NonNull TableInfo tableInfo, @NonNull Exception ex) throws Exception {
            if (tableInfo == null) {
                throw new NullPointerException("tableInfo is marked non-null but is null");
            }
            if (ex == null) {
                throw new NullPointerException("ex is marked non-null but is null");
            }
            if (ex instanceof NonRetryableException) {
                throw ex;
            }
            int count = this.insertion.getRecordCount();
            String message = ExceptionUtils.getRootCauseMessage(ex);
            if (ExceptionUtils.isBadRecord(message) || ExceptionUtils.isDiscardRecord(message)) {
                boolean shouldRetry;
                if (count < 2 && !this.writer.replaceData) {
                    this.translateSerialModeException(tableInfo, this.insertion.getSqlContext().getBatchArgs(), this.insertion.getFieldNameList(), 1, ex);
                    throw new NonRetryableException(ex);
                }
                boolean bl = shouldRetry = !tableInfo.isOracleMode() || !tableInfo.getServer().isPrevious("2.2.76");
                if (shouldRetry) {
                    this.insertion.setRetry(true);
                    this.insertion.setRetried(false);
                    this.insertion.setMode(Insertion.Mode.SERIAL);
                }
            } else if ((ExceptionUtils.isObserverError(message) || ExceptionUtils.isNetworkError(message)) && CollectionUtils.isNotEmpty(tableInfo.getPrimaryCols())) {
                this.insertion.setMode(Insertion.Mode.BATCH);
                this.insertion.setRetried(true);
                this.insertion.setRetry(true);
            } else {
                log.error("Other Error: ", (Throwable)ex);
                throw new NonRetryableException(ex);
            }
            String table = this.insertion.getTable();
            long partId = this.insertion.getPartitionId();
            Insertion.Mode mode = this.insertion.getMode();
            log.warn("Retry Table: \"{}\", Partition: {}. Records: {}. Error: {}. Retry Mode: {}.", new Object[]{table, partId, count, message, mode});
            throw new RetryableException(ex);
        }

        private void translateSerialModeException(TableInfo tableInfo, List<List<Object>> batchArgs, List<String> columnNameList, int affectRows, Exception ex) throws Exception {
            if (ex instanceof NonRetryableException) {
                throw ex;
            }
            String message = ExceptionUtils.getRootCauseMessage(ex);
            SubFile subFile = this.insertion.getSubFile();
            LoadContext ctx = this.writer.loadCtx;
            StringBuilder insertSql = tableInfo.toInsertSql(new Record(batchArgs.get(0)), columnNameList);
            if (ExceptionUtils.isDiscardRecord(message)) {
                DIS_RECORD_LOGGER.error("{}\nCause: {}\n", (Object)insertSql, (Object)ExceptionUtils.getRootCauseMessage(ex));
                if (ctx.incrementAndIsExceedMaxDiscards(tableInfo.getTable())) {
                    subFile.addLoadedBytes(this.insertion.getByteSize());
                    subFile.addLoadedCount(affectRows);
                    throw new NonRetryableException("Too many discard records. Table: {}", tableInfo.getSchemaTable());
                }
            } else if (ExceptionUtils.isBadRecord(message)) {
                BAD_RECORD_LOGGER.error("{}\nCause: {}\n", (Object)insertSql, (Object)ExceptionUtils.getRootCauseMessage(ex));
                if (ctx.incrementAndIsExceedMaxErrors(tableInfo.getTable())) {
                    subFile.addLoadedBytes(this.insertion.getByteSize());
                    subFile.addLoadedCount(affectRows);
                    throw new NonRetryableException("Too many bad records. Table: {}", tableInfo.getSchemaTable());
                }
            } else {
                log.error("Other Error: \"{}\". SQL: {};", (Object)message, (Object)insertSql);
                throw new NonRetryableException(ex);
            }
        }

        private static /* synthetic */ int lambda$executeBatch$0(int s) {
            return s == -2 ? 1 : (s == -3 ? 0 : s);
        }
    }
}

