/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.parser.compatilble.mysqldump;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.oceanbase.tools.loaddump.common.enums.ServerMode;
import com.oceanbase.tools.loaddump.parser.compatilble.Callback;
import com.oceanbase.tools.loaddump.parser.compatilble.DefaultCallback;
import com.oceanbase.tools.loaddump.parser.compatilble.SqlText;
import com.oceanbase.tools.loaddump.parser.compatilble.Unsupported;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MySqlDumpParser
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(MySqlDumpParser.class);
    private static final String DEFAULT_DELIMITER = ";";
    private static final String DELIMITER_TOKEN = "DELIMITER";
    private static final Pattern COMMIT_STATEMENT_PATTERN = Pattern.compile("(\\s*)commit(\\s*)(;*)(\\s*)", 2);
    private static final Set<String> OBMYSQL_3323_SUPPORTED_CHARSET = new HashSet<String>();
    private static final Set<String> MYSQL_80_SUPPORTED_CHARSET = new HashSet<String>();
    private static final Set<String> MYSQL_80_SUPPORTED_COLLATE = new HashSet<String>();
    private static final Set<String> OBMYSQL_3323_SUPPORTED_COLLATE = new HashSet<String>();
    private final BufferedReader br;
    private final ServerMode serverMode;
    private final boolean ignoreComment;
    private boolean closed;
    private boolean eof;
    private String delimiter;
    private boolean compatibleWith3rd;

    private MySqlDumpParser(BufferedReader br, boolean ignoreComment, ServerMode serverMode) {
        this.br = br;
        this.eof = false;
        this.serverMode = serverMode;
        this.delimiter = DEFAULT_DELIMITER;
        this.ignoreComment = ignoreComment;
    }

    public static MySqlDumpParser createParser(InputStream is, String fileEncoding, boolean ignoreComment, ServerMode serverMode) throws Exception {
        Preconditions.checkArgument((is != null ? 1 : 0) != 0, (Object)"Input stream is null");
        return new MySqlDumpParser(new BufferedReader(new InputStreamReader(is, fileEncoding)), ignoreComment, serverMode);
    }

    private boolean isEscapedChar(int ch) throws Exception {
        this.br.mark(1);
        if (this.br.read() == ch) {
            return true;
        }
        this.br.reset();
        return false;
    }

    private boolean isStmtTerminated(char ch, String delimiter) throws Exception {
        int len = delimiter.length();
        if (len == 1) {
            return ch == delimiter.charAt(0);
        }
        this.br.mark(len - 1);
        boolean isEnd = ch == delimiter.charAt(0);
        for (int i = 1; isEnd && i < len; ++i) {
            isEnd = (char)this.br.read() == delimiter.charAt(i);
        }
        if (isEnd) {
            this.br.skip(len - 1);
        } else {
            this.br.reset();
        }
        return isEnd;
    }

    public List<SqlText> parseStmt() throws Exception {
        DefaultCallback callback = new DefaultCallback();
        this.parseStmt(callback);
        return callback.getSqlTextList();
    }

    public void parseStmt(Callback callback) throws Exception {
        int flag;
        Preconditions.checkState((!this.eof ? 1 : 0) != 0, (Object)"Recreate parser instance as it has already parsed.");
        StringBuilder ct = new StringBuilder(256);
        StringBuilder sb = new StringBuilder(256);
        LinkedList<Character> stack = new LinkedList<Character>();
        block4: while (!this.closed && (flag = this.br.read()) != -1) {
            char ch = (char)flag;
            if (sb.length() == 0 && Character.isWhitespace(ch)) {
                if (ct.length() <= 0) continue;
                ct.append(ch);
                continue;
            }
            if (stack.isEmpty()) {
                String line;
                if (ch == '-') {
                    this.br.mark(1);
                    if ((char)this.br.read() == '-') {
                        line = this.br.readLine();
                        if (sb.length() == 0) {
                            ct.append(this.ignoreComment ? "\n" : "--" + line + "\n");
                            continue;
                        }
                        sb.append(this.ignoreComment ? "\n" : "--" + line + "\n");
                        continue;
                    }
                    this.br.reset();
                } else if (ch == '/') {
                    this.br.mark(2);
                    char[] buf = new char[2];
                    int ret = this.br.read(buf);
                    if (buf[0] == '*' && buf[1] != '!' && buf[1] != '+') {
                        if (!this.ignoreComment) {
                            (sb.length() == 0 ? ct : sb).append(ch).append(buf[0]);
                        }
                        int flag1 = buf[1];
                        do {
                            char temp1;
                            if ((temp1 = (char)flag1) == '*') {
                                this.br.mark(1);
                                if ((char)this.br.read() == '/') {
                                    (sb.length() == 0 ? ct : sb).append(this.ignoreComment ? "" : "*/");
                                    continue block4;
                                }
                                if (!this.ignoreComment) {
                                    (sb.length() == 0 ? ct : sb).append(temp1);
                                }
                                this.br.reset();
                                continue;
                            }
                            if (this.ignoreComment) continue;
                            (sb.length() == 0 ? ct : sb).append(temp1);
                        } while ((flag1 = this.br.read()) != -1);
                    } else {
                        this.br.reset();
                    }
                } else if (ch == '#') {
                    line = this.br.readLine();
                    if (sb.length() == 0) {
                        ct.append(this.ignoreComment ? "\n" : "#" + line + "\n");
                        continue;
                    }
                    sb.append(this.ignoreComment ? "\n" : "#" + line + "\n");
                    continue;
                }
            }
            switch (ch) {
                case '\\': {
                    if (this.serverMode != ServerMode.MYSQL) break;
                    sb.append(ch).append((char)this.br.read());
                    continue block4;
                }
                case '\"': 
                case '\'': 
                case '`': {
                    if (this.isEscapedChar(ch)) {
                        sb.append(ch);
                        break;
                    }
                    if (stack.isEmpty()) {
                        stack.push(Character.valueOf(ch));
                        break;
                    }
                    if (((Character)stack.peek()).charValue() != ch) break;
                    stack.pop();
                    break;
                }
            }
            if (sb.length() == DELIMITER_TOKEN.length() && StringUtils.equalsIgnoreCase((CharSequence)sb, (CharSequence)DELIMITER_TOKEN)) {
                this.delimiter = this.br.readLine();
                sb.setLength(0);
                continue;
            }
            if (stack.isEmpty() && this.isStmtTerminated(ch, this.delimiter)) {
                if (sb.length() <= 0) continue;
                callback.call(this.processStatement(ct.append((CharSequence)sb).toString()));
                ct.setLength(0);
                sb.setLength(0);
                continue;
            }
            sb.append(ch);
        }
        this.eof = true;
    }

    private SqlText processStatement(String statement) {
        if (this.compatibleWith3rd) {
            String trimmedStmt;
            String tempTrimmedStmt = trimmedStmt = statement.trim();
            while (tempTrimmedStmt.endsWith(this.delimiter)) {
                tempTrimmedStmt = tempTrimmedStmt.substring(0, tempTrimmedStmt.lastIndexOf(this.delimiter)).trim();
            }
            if (tempTrimmedStmt.startsWith("/*!") && tempTrimmedStmt.endsWith("*/")) {
                trimmedStmt = MySqlDumpParser.extractStatement(tempTrimmedStmt);
            }
            return this.analysisStatement(statement, trimmedStmt);
        }
        return new SqlText(statement, null, true);
    }

    private static String extractStatement(String trimmedStmt) {
        return Stream.of(trimmedStmt.split("\\*/")).map(s -> {
            int fromIndex;
            for (fromIndex = 0; fromIndex < s.length() && s.charAt(fromIndex) == ' '; ++fromIndex) {
            }
            int index = s.indexOf(32, fromIndex);
            return MySqlDumpParser.transformUnsupportedSnippet(index < 0 ? s : s.substring(index + 1)).trim();
        }).collect(Collectors.joining(" "));
    }

    private SqlText analysisStatement(String originStmt, String inputStmt) {
        String filterStmt;
        if (StringUtils.startsWithIgnoreCase((CharSequence)inputStmt.trim(), (CharSequence)"insert")) {
            return new SqlText(originStmt, null, true);
        }
        inputStmt = StringUtils.replaceIgnoreCase((String)inputStmt, (String)"ENGINE = ", (String)"ENGINE=");
        inputStmt = StringUtils.replaceIgnoreCase((String)inputStmt, (String)"CHARSET = ", (String)"CHARSET=");
        inputStmt = StringUtils.replaceIgnoreCase((String)inputStmt, (String)"COLLATE = ", (String)"COLLATE=");
        boolean versionCommentOpen = false;
        StringBuilder sb = new StringBuilder();
        ArrayList<String> snippets = new ArrayList<String>();
        for (int i = 0; i < inputStmt.length(); ++i) {
            char ch = inputStmt.charAt(i);
            if (ch == ' ') {
                while (i < inputStmt.length() && inputStmt.charAt(i) == ' ') {
                    ++i;
                }
                if (inputStmt.charAt(i) == '\n') {
                    sb.append('\n');
                    snippets.add(sb.toString());
                } else {
                    snippets.add(sb.toString());
                }
                --i;
                sb.setLength(0);
                continue;
            }
            if (ch == '\n') {
                sb.append('\n');
                snippets.add(sb.toString());
                sb.setLength(0);
                continue;
            }
            sb.append(ch);
            if (ch == '/' && i < inputStmt.length() - 2 && inputStmt.charAt(i + 1) == '*' && inputStmt.charAt(i + 2) == '!') {
                sb.append("*!");
                versionCommentOpen = true;
            }
            if (!versionCommentOpen) continue;
            for (int j = i + 1; j < inputStmt.length(); ++j) {
                char ch1 = inputStmt.charAt(j);
                if (ch1 == '*' && j < inputStmt.length() - 1 && inputStmt.charAt(j + 1) == '/') {
                    sb.append("*/");
                    i = j + 1;
                    versionCommentOpen = false;
                    break;
                }
                sb.append(ch1);
            }
            snippets.add(MySqlDumpParser.extractStatement(sb.toString()));
            sb.setLength(0);
        }
        if (sb.length() > 0) {
            snippets.add(sb.toString());
        }
        String targetStmt = originStmt.equals(filterStmt = this.joiningSnippets(snippets)) ? null : filterStmt;
        return new SqlText(originStmt, targetStmt, MySqlDumpParser.isGrammarSupported(filterStmt));
    }

    private String joiningSnippets(List<String> list) {
        String lastElement = (list = list.stream().map(MySqlDumpParser::transformUnsupportedSnippet).collect(Collectors.toList())).get(list.size() - 1);
        if (!this.delimiter.equals(lastElement)) {
            lastElement = " " + lastElement;
        }
        return list.stream().limit(list.size() - 1).collect(Collectors.joining(" ")) + lastElement;
    }

    private static String transformUnsupportedSnippet(String snippet) {
        if (StringUtils.isBlank((CharSequence)snippet)) {
            return "";
        }
        if (StringUtils.startsWithIgnoreCase((CharSequence)snippet, (CharSequence)"DEFINER=")) {
            if (StringUtils.containsIgnoreCase((CharSequence)snippet, (CharSequence)"SQL SECURITY DEFINER")) {
                int index = StringUtils.indexOfIgnoreCase((CharSequence)snippet, (CharSequence)"SQL SECURITY DEFINER");
                int end = index + "SQL SECURITY DEFINER".length();
                snippet = snippet.substring(0, index) + snippet.substring(end);
            }
            return Unsupported.Snippet.VIEW_DEFINER_PATTERN.matcher(snippet).matches() ? "" : snippet;
        }
        return snippet;
    }

    private static String findAvailableCollate(String collate) {
        if (!OBMYSQL_3323_SUPPORTED_COLLATE.contains(collate)) {
            if (StringUtils.containsIgnoreCase((CharSequence)collate, (CharSequence)"utf8")) {
                return "utf8mb4_general_ci";
            }
            if (StringUtils.containsIgnoreCase((CharSequence)collate, (CharSequence)"gbk")) {
                return "gbk_chinese_ci";
            }
            if (StringUtils.containsIgnoreCase((CharSequence)collate, (CharSequence)"utf16")) {
                return "utf16_general_ci";
            }
            if (StringUtils.containsIgnoreCase((CharSequence)collate, (CharSequence)"binary")) {
                return "binary";
            }
            if (StringUtils.containsIgnoreCase((CharSequence)collate, (CharSequence)"gb18030")) {
                return "gb18030_chinese_ci";
            }
            return "utf8mb4_general_ci";
        }
        return collate;
    }

    private static boolean isGrammarSupported(String statement) {
        if (StringUtils.isBlank((CharSequence)statement)) {
            return false;
        }
        String sql = statement.trim();
        if (sql.length() < 16 && COMMIT_STATEMENT_PATTERN.matcher(sql).matches()) {
            return false;
        }
        if (StringUtils.startsWithIgnoreCase((CharSequence)sql, (CharSequence)"CREATE EVENT")) {
            return !Unsupported.Grammar.CREATE_EVENT_PATTERN.matcher(statement).matches();
        }
        if (StringUtils.startsWithIgnoreCase((CharSequence)sql, (CharSequence)"ALTER TABLE")) {
            return !Unsupported.Grammar.ALTER_TABLE_KEYS_PATTERN.matcher(statement).matches();
        }
        if (StringUtils.containsIgnoreCase((CharSequence)sql, (CharSequence)"SET collation_connection")) {
            return !Unsupported.Grammar.SET_COLLATION_CONNECTION_PATTERN.matcher(statement).matches();
        }
        if (StringUtils.containsIgnoreCase((CharSequence)sql, (CharSequence)"SET character_set_client")) {
            return !Unsupported.Grammar.SET_CHARACTER_SET_CLIENT_PATTERN.matcher(statement).matches();
        }
        return true;
    }

    @Override
    public void close() throws Exception {
        if (this.br != null) {
            this.br.close();
            this.closed = true;
        }
    }

    public void setCompatibleWith3rd(boolean compatibleWith3rd) {
        this.compatibleWith3rd = compatibleWith3rd;
    }

    static {
        OBMYSQL_3323_SUPPORTED_CHARSET.addAll(Sets.newHashSet((Object[])new String[]{"gbk", "binary", "utf8mb4", "utf16", "gb18030"}));
        MYSQL_80_SUPPORTED_CHARSET.addAll(Sets.newHashSet((Object[])new String[]{"big5", "dec8", "cp850", "hp8", "koi8r", "latin1", "latin2", "swe7", "ascii", "ujis", "sjis", "hebrew", "tis620", "euckr", "koi8u"}));
        MYSQL_80_SUPPORTED_CHARSET.addAll(Sets.newHashSet((Object[])new String[]{"gb2312", "greek", "cp1250", "gbk", "latin5", "armscii8", "utf8", "ucs2", "cp866", "keybcs2", "macce", "macroman", "cp852", "latin7"}));
        MYSQL_80_SUPPORTED_CHARSET.addAll(Sets.newHashSet((Object[])new String[]{"cp1251", "utf16", "utf16le", "cp1256", "cp1257", "utf32", "binary", "geostd8", "cp932", "eucjpms", "gb18030", "utf8mb4"}));
        OBMYSQL_3323_SUPPORTED_COLLATE.addAll(Sets.newHashSet((Object[])new String[]{"utf8mb4_bin", "utf8mb4_general_ci", "binary", "gbk_chinese_ci", "gbk_bin", "utf16_general_ci"}));
        OBMYSQL_3323_SUPPORTED_COLLATE.addAll(Sets.newHashSet((Object[])new String[]{"utf16_bin", "utf8mb4_unicode_ci", "utf16_unicode_ci", "gb18030_chinese_ci", "gb18030_bin"}));
        MYSQL_80_SUPPORTED_COLLATE.addAll(Sets.newHashSet((Object[])new String[]{"armscii8_general_ci", "armscii8_bin", "ascii_general_ci", "ascii_bin", "big5_chinese_ci", "big5_bin", "binary", "cp1250_general_ci", "cp1250_czech_cs"}));
        MYSQL_80_SUPPORTED_COLLATE.addAll(Sets.newHashSet((Object[])new String[]{"cp1250_croatian_ci", "cp1250_bin", "cp1250_polish_ci", "cp1251_bulgarian_ci", "cp1251_ukrainian_ci", "cp1251_bin", "cp1251_general_ci", "cp1251_general_cs"}));
        MYSQL_80_SUPPORTED_COLLATE.addAll(Sets.newHashSet((Object[])new String[]{"cp1256_general_ci", "cp1256_bin", "cp1257_lithuanian_ci", "cp1257_bin", "cp1257_general_ci", "cp850_general_ci", "cp850_bin", "cp852_general_ci", "cp852_bin"}));
        MYSQL_80_SUPPORTED_COLLATE.addAll(Sets.newHashSet((Object[])new String[]{"cp866_general_ci", "cp866_bin", "cp932_japanese_ci", "cp932_bin", "dec8_swedish_ci", "dec8_bin", "eucjpms_japanese_ci", "eucjpms_bin", "euckr_korean_ci", "euckr_bin"}));
        MYSQL_80_SUPPORTED_COLLATE.addAll(Sets.newHashSet((Object[])new String[]{"gb18030_chinese_ci", "gb18030_bin", "gb18030_unicode_520_ci", "gb2312_chinese_ci", "gb2312_bin", "gbk_chinese_ci", "gbk_bin", "geostd8_general_ci", "geostd8_bin"}));
        MYSQL_80_SUPPORTED_COLLATE.addAll(Sets.newHashSet((Object[])new String[]{"greek_general_ci", "greek_bin", "hebrew_general_ci", "hebrew_bin", "hp8_english_ci", "hp8_bin", "keybcs2_general_ci", "keybcs2_bin", "koi8r_general_ci", "koi8r_bin"}));
        MYSQL_80_SUPPORTED_COLLATE.addAll(Sets.newHashSet((Object[])new String[]{"koi8u_general_ci", "koi8u_bin", "latin1_german1_ci", "latin1_swedish_ci", "latin1_danish_ci", "latin1_german2_ci", "latin1_bin", "latin1_general_ci", "latin1_general_cs"}));
        MYSQL_80_SUPPORTED_COLLATE.addAll(Sets.newHashSet((Object[])new String[]{"latin1_spanish_ci", "latin2_czech_cs", "latin2_general_ci", "latin2_hungarian_ci", "latin2_croatian_ci", "latin2_bin", "latin5_turkish_ci", "latin5_bin", "latin7_estonian_cs"}));
        MYSQL_80_SUPPORTED_COLLATE.addAll(Sets.newHashSet((Object[])new String[]{"latin7_general_ci", "latin7_general_cs", "latin7_bin", "macce_general_ci", "macce_bin", "macroman_general_ci", "macroman_bin", "sjis_japanese_ci", "sjis_bin"}));
        MYSQL_80_SUPPORTED_COLLATE.addAll(Sets.newHashSet((Object[])new String[]{"swe7_swedish_ci", "swe7_bin", "tis620_thai_ci", "tis620_bin", "ucs2_general_ci", "ucs2_bin", "ucs2_unicode_ci", "ucs2_icelandic_ci", "ucs2_latvian_ci"}));
        MYSQL_80_SUPPORTED_COLLATE.addAll(Sets.newHashSet((Object[])new String[]{"ucs2_romanian_ci", "ucs2_slovenian_ci", "ucs2_polish_ci", "ucs2_estonian_ci", "ucs2_spanish_ci", "ucs2_swedish_ci", "ucs2_turkish_ci", "ucs2_czech_ci"}));
        MYSQL_80_SUPPORTED_COLLATE.addAll(Sets.newHashSet((Object[])new String[]{"ucs2_danish_ci", "ucs2_lithuanian_ci", "ucs2_slovak_ci", "ucs2_spanish2_ci", "ucs2_roman_ci", "ucs2_persian_ci", "ucs2_esperanto_ci", "ucs2_hungarian_ci"}));
        MYSQL_80_SUPPORTED_COLLATE.addAll(Sets.newHashSet((Object[])new String[]{"ucs2_sinhala_ci", "ucs2_german2_ci", "ucs2_croatian_ci", "ucs2_unicode_520_ci", "ucs2_vietnamese_ci", "ucs2_general_mysql500_ci", "ujis_japanese_ci"}));
        MYSQL_80_SUPPORTED_COLLATE.addAll(Sets.newHashSet((Object[])new String[]{"ujis_bin", "utf16_general_ci", "utf16_bin", "utf16_unicode_ci", "utf16_icelandic_ci", "utf16_latvian_ci", "utf16_romanian_ci", "utf16_slovenian_ci"}));
        MYSQL_80_SUPPORTED_COLLATE.addAll(Sets.newHashSet((Object[])new String[]{"utf16_polish_ci", "utf16_estonian_ci", "utf16_spanish_ci", "utf16_swedish_ci", "utf16_turkish_ci", "utf16_czech_ci", "utf16_danish_ci", "utf16_lithuanian_ci"}));
        MYSQL_80_SUPPORTED_COLLATE.addAll(Sets.newHashSet((Object[])new String[]{"utf16_slovak_ci", "utf16_spanish2_ci", "utf16_roman_ci", "utf16_persian_ci", "utf16_esperanto_ci", "utf16_hungarian_ci", "utf16_sinhala_ci", "utf16_german2_ci"}));
        MYSQL_80_SUPPORTED_COLLATE.addAll(Sets.newHashSet((Object[])new String[]{"utf16_croatian_ci", "utf16_unicode_520_ci", "utf16_vietnamese_ci", "utf16le_general_ci", "utf16le_bin", "utf32_general_ci", "utf32_bin", "utf32_unicode_ci"}));
        MYSQL_80_SUPPORTED_COLLATE.addAll(Sets.newHashSet((Object[])new String[]{"utf32_icelandic_ci", "utf32_latvian_ci", "utf32_romanian_ci", "utf32_slovenian_ci", "utf32_polish_ci", "utf32_estonian_ci", "utf32_spanish_ci", "utf32_swedish_ci"}));
        MYSQL_80_SUPPORTED_COLLATE.addAll(Sets.newHashSet((Object[])new String[]{"utf32_turkish_ci", "utf32_czech_ci", "utf32_danish_ci", "utf32_lithuanian_ci", "utf32_slovak_ci", "utf32_spanish2_ci", "utf32_roman_ci", "utf32_persian_ci"}));
        MYSQL_80_SUPPORTED_COLLATE.addAll(Sets.newHashSet((Object[])new String[]{"utf32_esperanto_ci", "utf32_hungarian_ci", "utf32_sinhala_ci", "utf32_german2_ci", "utf32_croatian_ci", "utf32_unicode_520_ci", "utf32_vietnamese_ci"}));
        MYSQL_80_SUPPORTED_COLLATE.addAll(Sets.newHashSet((Object[])new String[]{"utf8_general_ci", "utf8_tolower_ci", "utf8_bin", "utf8_unicode_ci", "utf8_icelandic_ci", "utf8_latvian_ci", "utf8_romanian_ci", "utf8_slovenian_ci"}));
        MYSQL_80_SUPPORTED_COLLATE.addAll(Sets.newHashSet((Object[])new String[]{"utf8_polish_ci", "utf8_estonian_ci", "utf8_spanish_ci", "utf8_swedish_ci", "utf8_turkish_ci", "utf8_czech_ci", "utf8_danish_ci", "utf8_lithuanian_ci"}));
        MYSQL_80_SUPPORTED_COLLATE.addAll(Sets.newHashSet((Object[])new String[]{"utf8_slovak_ci", "utf8_spanish2_ci", "utf8_roman_ci", "utf8_persian_ci", "utf8_esperanto_ci", "utf8_hungarian_ci", "utf8_sinhala_ci", "utf8_german2_ci"}));
        MYSQL_80_SUPPORTED_COLLATE.addAll(Sets.newHashSet((Object[])new String[]{"utf8_croatian_ci", "utf8_unicode_520_ci", "utf8_vietnamese_ci", "utf8_general_mysql500_ci", "utf8mb4_general_ci", "utf8mb4_bin", "utf8mb4_unicode_ci"}));
        MYSQL_80_SUPPORTED_COLLATE.addAll(Sets.newHashSet((Object[])new String[]{"utf8mb4_icelandic_ci", "utf8mb4_latvian_ci", "utf8mb4_romanian_ci", "utf8mb4_slovenian_ci", "utf8mb4_polish_ci", "utf8mb4_estonian_ci", "utf8mb4_spanish_ci"}));
        MYSQL_80_SUPPORTED_COLLATE.addAll(Sets.newHashSet((Object[])new String[]{"utf8mb4_swedish_ci", "utf8mb4_turkish_ci", "utf8mb4_czech_ci", "utf8mb4_danish_ci", "utf8mb4_lithuanian_ci", "utf8mb4_slovak_ci", "utf8mb4_spanish2_ci"}));
        MYSQL_80_SUPPORTED_COLLATE.addAll(Sets.newHashSet((Object[])new String[]{"utf8mb4_roman_ci", "utf8mb4_persian_ci", "utf8mb4_esperanto_ci", "utf8mb4_hungarian_ci", "utf8mb4_sinhala_ci", "utf8mb4_german2_ci", "utf8mb4_croatian_ci"}));
        MYSQL_80_SUPPORTED_COLLATE.addAll(Sets.newHashSet((Object[])new String[]{"utf8mb4_unicode_520_ci", "utf8mb4_vietnamese_ci", "utf8mb4_0900_ai_ci", "utf8mb4_de_pb_0900_ai_ci", "utf8mb4_is_0900_ai_ci", "utf8mb4_lv_0900_ai_ci", "utf8mb4_ro_0900_ai_ci"}));
        MYSQL_80_SUPPORTED_COLLATE.addAll(Sets.newHashSet((Object[])new String[]{"utf8mb4_sl_0900_ai_ci", "utf8mb4_pl_0900_ai_ci", "utf8mb4_et_0900_ai_ci", "utf8mb4_es_0900_ai_ci", "utf8mb4_sv_0900_ai_ci", "utf8mb4_tr_0900_ai_ci", "utf8mb4_cs_0900_ai_ci"}));
        MYSQL_80_SUPPORTED_COLLATE.addAll(Sets.newHashSet((Object[])new String[]{"utf8mb4_da_0900_ai_ci", "utf8mb4_lt_0900_ai_ci", "utf8mb4_sk_0900_ai_ci", "utf8mb4_es_trad_0900_ai_ci", "utf8mb4_la_0900_ai_ci", "utf8mb4_eo_0900_ai_ci", "utf8mb4_hu_0900_ai_ci"}));
        MYSQL_80_SUPPORTED_COLLATE.addAll(Sets.newHashSet((Object[])new String[]{"utf8mb4_hr_0900_ai_ci", "utf8mb4_vi_0900_ai_ci", "utf8mb4_0900_as_cs", "utf8mb4_de_pb_0900_as_cs", "utf8mb4_is_0900_as_cs", "utf8mb4_lv_0900_as_cs", "utf8mb4_ro_0900_as_cs"}));
        MYSQL_80_SUPPORTED_COLLATE.addAll(Sets.newHashSet((Object[])new String[]{"utf8mb4_sl_0900_as_cs", "utf8mb4_pl_0900_as_cs", "utf8mb4_et_0900_as_cs", "utf8mb4_es_0900_as_cs", "utf8mb4_sv_0900_as_cs", "utf8mb4_tr_0900_as_cs", "utf8mb4_cs_0900_as_cs"}));
        MYSQL_80_SUPPORTED_COLLATE.addAll(Sets.newHashSet((Object[])new String[]{"utf8mb4_da_0900_as_cs", "utf8mb4_lt_0900_as_cs", "utf8mb4_sk_0900_as_cs", "utf8mb4_es_trad_0900_as_cs", "utf8mb4_la_0900_as_cs", "utf8mb4_eo_0900_as_cs", "utf8mb4_hu_0900_as_cs"}));
        MYSQL_80_SUPPORTED_COLLATE.addAll(Sets.newHashSet((Object[])new String[]{"utf8mb4_hr_0900_as_cs", "utf8mb4_vi_0900_as_cs", "utf8mb4_ja_0900_as_cs", "utf8mb4_ja_0900_as_cs_ks", "utf8mb4_0900_as_ci", "utf8mb4_ru_0900_ai_ci", "utf8mb4_ru_0900_as_cs", "utf8mb4_zh_0900_as_cs", "utf8mb4_0900_bin"}));
    }
}

