/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.parser.record;

import com.google.common.base.Preconditions;
import com.oceanbase.tools.loaddump.common.exception.ParseFailureException;
import com.oceanbase.tools.loaddump.common.model.Record;
import com.oceanbase.tools.loaddump.parser.AbstractParser;
import com.oceanbase.tools.loaddump.utils.CollectionUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRecordParser
extends AbstractParser<Record> {
    protected boolean closed;
    protected final DefaultRecordIterator defaultRecordIterator = new DefaultRecordIterator(this);
    protected boolean autoColumnMapping;
    protected List<String> fieldNameList;
    protected List<String> extraColumnNames;
    protected List<String> extraColumnsValues;
    protected boolean isExtraColumnPartition;
    protected Map<String, Integer> fieldIndexMapping;

    public abstract Record nextRecord() throws IOException;

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public Iterator<Record> iterator() {
        return this.defaultRecordIterator;
    }

    public void initFieldIndexMapAndExtraColumnsNameAndValue(boolean autoColumnMapping, List<String> extraColumnNames, List<String> extraColumnsValues, boolean isExtraColumnPartition, List<String> tableColumnNameList) {
        if (!autoColumnMapping) {
            this.fieldNameList = null;
            return;
        }
        this.extraColumnNames = extraColumnNames;
        this.extraColumnsValues = extraColumnsValues;
        this.isExtraColumnPartition = isExtraColumnPartition;
        if (CollectionUtils.isNotEmpty(extraColumnNames)) {
            extraColumnNames.forEach(c -> this.fieldNameList.forEach(f -> {
                if (f.equalsIgnoreCase((String)c)) {
                    throw new IllegalArgumentException("Found duplicate field '" + c + "' in file with extra columns, please check data consistency.");
                }
            }));
            this.fieldNameList.addAll(extraColumnNames);
        }
        if (CollectionUtils.isEmpty(this.fieldNameList)) {
            return;
        }
        int matchedColCnt = this.removeFieldNameCaseSensitivity(tableColumnNameList);
        Preconditions.checkArgument((matchedColCnt != 0 ? 1 : 0) != 0, (Object)("No column name matches table structure, parsed fields: [" + String.join((CharSequence)",", this.fieldNameList) + "], table columns: [" + String.join((CharSequence)",", tableColumnNameList) + "]"));
        this.fieldIndexMapping = new HashMap<String, Integer>();
        int i = 0;
        for (String fieldName : this.fieldNameList) {
            this.fieldIndexMapping.put(fieldName, i++);
        }
    }

    public int removeFieldNameCaseSensitivity(List<String> tableColumnNameList) {
        if (this.fieldNameList != null) {
            int matchedColCnt = 0;
            for (int i = 0; i < this.fieldNameList.size(); ++i) {
                for (String col : tableColumnNameList) {
                    if (!col.equalsIgnoreCase(this.fieldNameList.get(i))) continue;
                    this.fieldNameList.set(i, col);
                    ++matchedColCnt;
                }
            }
            return matchedColCnt;
        }
        return -1;
    }

    public boolean isAutoColumnMapping() {
        return this.autoColumnMapping;
    }

    public List<String> getFieldNameList() {
        return this.fieldNameList;
    }

    public void setFieldNameList(List<String> fieldNameList) {
        this.fieldNameList = fieldNameList;
    }

    public List<String> getExtraColumnNames() {
        return this.extraColumnNames;
    }

    public List<String> getExtraColumnsValues() {
        return this.extraColumnsValues;
    }

    public boolean isExtraColumnPartition() {
        return this.isExtraColumnPartition;
    }

    public Map<String, Integer> getFieldIndexMapping() {
        return this.fieldIndexMapping;
    }

    public static class DefaultRecordIterator
    implements Iterator<Record> {
        private static final Logger log = LoggerFactory.getLogger(DefaultRecordIterator.class);
        private Record current;
        private final AbstractRecordParser parser;

        public DefaultRecordIterator(AbstractRecordParser parser) {
            Preconditions.checkArgument((parser != null ? 1 : 0) != 0, (Object)"Input record parser is null");
            this.parser = parser;
        }

        @Override
        public boolean hasNext() {
            if (this.parser.isClosed()) {
                return false;
            }
            if (this.current == null) {
                this.current = this.getNextRecord();
            }
            return this.current != null;
        }

        @Override
        public Record next() {
            if (this.parser.isClosed()) {
                throw new NoSuchElementException("The record parser: [\"" + this.parser.getClass().getSimpleName() + "\"] is already closed");
            }
            Record next = this.current;
            this.current = null;
            if (next == null && (next = this.getNextRecord()) == null) {
                throw new NoSuchElementException("No more available records");
            }
            return next;
        }

        private Record getNextRecord() {
            try {
                return this.parser.nextRecord();
            }
            catch (IOException e) {
                throw new ParseFailureException("Get next record failed ", e);
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove is unsupported");
        }
    }
}

