/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.parser.record;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;

public final class ExtendedBufferedReader
extends BufferedReader {
    private static final int BUFFER_SIZE = 0x100000;
    private int lastChar = -2;
    private long eolCounter;
    private long position;
    private boolean closed;

    public ExtendedBufferedReader(Reader reader) {
        super(reader, Integer.getInteger("fs.page", 0x100000));
    }

    @Override
    public int read() throws IOException {
        int current = super.read();
        if (current == 13 || current == 10 && this.lastChar != 13) {
            ++this.eolCounter;
        }
        this.lastChar = current;
        ++this.position;
        return this.lastChar;
    }

    public int getLastChar() {
        return this.lastChar;
    }

    @Override
    public int read(char[] buf, int offset, int length) throws IOException {
        if (length == 0) {
            return 0;
        }
        int len = super.read(buf, offset, length);
        if (len > 0) {
            for (int i = offset; i < offset + len; ++i) {
                char ch = buf[i];
                if (ch == '\n') {
                    if (13 == (i > 0 ? buf[i - 1] : this.lastChar)) continue;
                    ++this.eolCounter;
                    continue;
                }
                if (ch != '\r') continue;
                ++this.eolCounter;
            }
            this.lastChar = buf[offset + len - 1];
        } else if (len == -1) {
            this.lastChar = -1;
        }
        this.position += (long)len;
        return len;
    }

    @Override
    public String readLine() throws IOException {
        String line = super.readLine();
        if (line != null) {
            this.lastChar = 10;
            ++this.eolCounter;
        } else {
            this.lastChar = -1;
        }
        return line;
    }

    public int lookAhead() throws IOException {
        return this.lookAhead(1);
    }

    public int lookAhead(int readAheadLimit) throws IOException {
        super.mark(readAheadLimit);
        int c = -1;
        for (int i = 0; i < readAheadLimit; ++i) {
            c = super.read();
        }
        super.reset();
        return c;
    }

    public int skipReads(int limit) throws IOException {
        int ch = -1;
        for (int i = 0; i < limit && (ch = this.read()) != -1; ++i) {
        }
        return ch;
    }

    public long getCurrentLineNumber() {
        if (this.lastChar == 13 || this.lastChar == 10 || this.lastChar == -2 || this.lastChar == -1) {
            return this.eolCounter;
        }
        return this.eolCounter + 1L;
    }

    public long getPosition() {
        return this.position;
    }

    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        this.lastChar = -1;
        super.close();
    }
}

