/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.parser.record.avro;

import com.oceanbase.tools.loaddump.common.constants.Constants;
import com.oceanbase.tools.loaddump.common.model.Record;
import com.oceanbase.tools.loaddump.parser.record.AbstractColumnOrientedParser;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.util.concurrent.TimeUnit;
import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.file.FileReader;
import org.apache.avro.file.SeekableInput;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericFixed;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.DatumReader;
import org.apache.commons.codec.binary.Hex;
import org.apache.hadoop.fs.AvroFSInput;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class AvroRecordParser
extends AbstractColumnOrientedParser {
    private final FileReader<GenericRecord> reader;
    private final Schema schema;

    private AvroRecordParser(FileReader<GenericRecord> reader, Schema schema) {
        this.reader = reader;
        this.schema = schema;
    }

    public static AvroRecordParser parse(FileSystem fs, String path) throws IOException {
        Path p = new Path(path);
        GenericDatumReader datumReader = new GenericDatumReader();
        FileReader fileReader = DataFileReader.openReader((SeekableInput)new AvroFSInput(fs.open(p), fs.getFileStatus(p).getLen()), (DatumReader)datumReader);
        return new AvroRecordParser((FileReader<GenericRecord>)fileReader, datumReader.getSchema());
    }

    @Override
    public Record extractRecord() throws IOException {
        if (!this.reader.hasNext()) {
            return null;
        }
        GenericRecord record = (GenericRecord)this.reader.next();
        String[] values = new String[this.schema.getFields().size()];
        try {
            for (int i = 0; i < this.schema.getFields().size(); ++i) {
                Object value = record.get(i);
                values[i] = value == null ? null : this.parseToString(value, ((Schema.Field)this.schema.getFields().get(i)).schema());
            }
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        return new Record(values);
    }

    private String parseToString(Object value, Schema schema) {
        LogicalType logicalType = schema.getLogicalType();
        if (logicalType == null) {
            switch (schema.getType()) {
                case FIXED: 
                case BYTES: {
                    return Hex.encodeHexString((byte[])((byte[])value));
                }
            }
            return value.toString();
        }
        switch (logicalType.getName()) {
            case "decimal": {
                int scale = ((LogicalTypes.Decimal)schema.getLogicalType()).getScale();
                if (value instanceof ByteBuffer) {
                    return new BigDecimal(new BigInteger(((ByteBuffer)value).array()), scale).toPlainString();
                }
                if (value instanceof GenericFixed) {
                    return new BigDecimal(new BigInteger(((GenericFixed)value).bytes()), scale).toPlainString();
                }
            }
            case "date": {
                return LocalDate.ofEpochDay(((Integer)value).intValue()).format(Constants.DEFAULT_MYSQL_DATE_FORMATTER);
            }
            case "time-micros": {
                return LocalTime.ofNanoOfDay(TimeUnit.MICROSECONDS.toNanos((Long)value)).format(Constants.DEFAULT_TIME_FORMATTER);
            }
            case "time-millis": {
                return LocalTime.ofNanoOfDay(TimeUnit.MILLISECONDS.toNanos(((Integer)value).intValue())).format(Constants.DEFAULT_TIME_FORMATTER);
            }
            case "timestamp-millis": 
            case "local-timestamp-millis": {
                return LocalDateTime.ofEpochSecond((Long)value / 1000L, (int)((Long)value % 1000L) * 1000000, ZoneOffset.UTC).toString();
            }
            case "timestamp-micros": 
            case "local-timestamp-micros": {
                return LocalDateTime.ofEpochSecond((Long)value / 1000000L, (int)((Long)value % 1000000L * 1000L), ZoneOffset.UTC).toString();
            }
        }
        return value.toString();
    }

    @Override
    public void close() throws Exception {
        if (this.reader != null) {
            this.reader.close();
            this.closed = true;
        }
        super.close();
    }
}

