/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.parser.record.csv;

import com.google.common.base.Preconditions;
import com.oceanbase.tools.loaddump.parser.record.csv.CsvFormat;
import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;

public final class CsvPrinter
implements Flushable,
Closeable {
    private final Appendable out;
    private final CsvFormat format;
    private boolean newRecord = true;

    public CsvPrinter(Appendable out, CsvFormat format) throws IOException {
        Preconditions.checkArgument((out != null ? 1 : 0) != 0, (Object)"Output is null");
        Preconditions.checkArgument((format != null ? 1 : 0) != 0, (Object)"CsvFormat is null");
        this.out = out;
        this.format = format;
        if (format.getHeaderComments() != null) {
            for (String line : format.getHeaderComments()) {
                if (line == null) continue;
                this.printComment(line);
            }
        }
        if (format.getHeader() != null && !format.getSkipHeaderRecord()) {
            this.printRecord(format.getHeader());
        }
    }

    @Override
    public void close() throws IOException {
        this.close(false);
    }

    public void close(boolean flush) throws IOException {
        if (flush || this.format.getAutoFlush()) {
            this.flush();
        }
        if (this.out instanceof Closeable) {
            ((Closeable)((Object)this.out)).close();
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.out instanceof Flushable) {
            ((Flushable)((Object)this.out)).flush();
        }
    }

    public Appendable getOut() {
        return this.out;
    }

    public void print(Object value) throws IOException {
        this.format.print(value, this.out, this.newRecord);
        this.newRecord = false;
    }

    public void printComment(String comment) throws IOException {
        if (!this.format.isCommentMarkerSet()) {
            return;
        }
        if (!this.newRecord) {
            this.println();
        }
        this.out.append(this.format.getCommentMarker().charValue());
        this.out.append(' ');
        block4: for (int i = 0; i < comment.length(); ++i) {
            char c = comment.charAt(i);
            switch (c) {
                case '\r': {
                    if (i + 1 >= comment.length() || comment.charAt(i + 1) != '\n') continue block4;
                    ++i;
                    continue block4;
                }
                case '\n': {
                    this.println();
                    this.out.append(this.format.getCommentMarker().charValue());
                    this.out.append(' ');
                    continue block4;
                }
                default: {
                    this.out.append(c);
                }
            }
        }
        this.println();
    }

    public void println() throws IOException {
        this.format.println(this.out);
        this.newRecord = true;
    }

    public void printRecord(Iterable<?> values) throws IOException {
        for (Object value : values) {
            this.print(value);
        }
        this.println();
    }

    public void printRecord(Object ... values) throws IOException {
        this.format.printRecord(this.out, values);
        this.newRecord = true;
    }

    public void printRecords(Iterable<?> values) throws IOException {
        for (Object value : values) {
            if (value instanceof Object[]) {
                this.printRecord((Object[])value);
                continue;
            }
            if (value instanceof Iterable) {
                this.printRecord((Iterable)value);
                continue;
            }
            this.printRecord(value);
        }
    }

    public void printRecords(Object ... values) throws IOException {
        this.printRecords(Arrays.asList(values));
    }

    public void printRecords(ResultSet resultSet) throws SQLException, IOException {
        int columnCount = resultSet.getMetaData().getColumnCount();
        while (resultSet.next()) {
            for (int i = 1; i <= columnCount; ++i) {
                Object object = resultSet.getObject(i);
                this.print(object instanceof Clob ? ((Clob)object).getCharacterStream() : object);
            }
            this.println();
        }
    }
}

