/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.parser.record.cut;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

class BufferReaderDelegate
implements AutoCloseable {
    private final BufferedReader reader;
    private final String columnSplitter;
    private final String lineSeparator;
    private final Character escapeCharacter;
    private final boolean trailDelimiter;
    private List<Character> cache = null;
    private int mark = -1;
    private int index = 0;

    public BufferReaderDelegate(BufferedReader reader, boolean trailDelimiter, String columnSplitter, String lineSeparator, Character escapeCharacter) {
        this.reader = reader;
        this.columnSplitter = columnSplitter;
        this.lineSeparator = lineSeparator;
        this.escapeCharacter = escapeCharacter;
        this.trailDelimiter = trailDelimiter;
    }

    public int read() throws IOException {
        if (!this.trailDelimiter) {
            return this.reader.read();
        }
        if (this.cache == null) {
            this.cacheNextLine();
        } else if (this.index >= this.cache.size()) {
            this.cacheNextLine();
        }
        if (this.cache.isEmpty()) {
            return -1;
        }
        if (this.index >= this.cache.size()) {
            return -1;
        }
        return this.cache.get(this.index++).charValue();
    }

    public void mark(int readAheadLimit) throws IOException {
        if (!this.trailDelimiter) {
            this.reader.mark(readAheadLimit);
        } else {
            this.mark = this.index;
        }
    }

    public void reset() throws IOException {
        if (!this.trailDelimiter) {
            this.reader.reset();
        } else {
            if (this.mark == -1) {
                throw new IllegalStateException("Can not call reset before mark");
            }
            this.index = this.mark;
            this.mark = -1;
        }
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
        if (this.cache != null) {
            this.cache.clear();
        }
        this.cache = null;
    }

    private void cacheNextLine() throws IOException {
        int i;
        int dt;
        int beginIndex = -1;
        int endIndex = -1;
        ArrayList<Character> tmp = new ArrayList<Character>(1024);
        while ((dt = this.reader.read()) != -1) {
            tmp.add(Character.valueOf((char)dt));
            int lineSepIdx = this.endWith(tmp.size() - 1, tmp, this.lineSeparator);
            if (lineSepIdx <= -1) continue;
            endIndex = lineSepIdx;
            int splitterIdx = this.endWith(lineSepIdx - 1, tmp, this.columnSplitter);
            if (splitterIdx <= -1 || !this.trailDelimiter) break;
            beginIndex = splitterIdx;
            break;
        }
        if (endIndex == -1 && !tmp.isEmpty()) {
            for (i = 0; i < this.lineSeparator.length(); ++i) {
                tmp.add(Character.valueOf(this.lineSeparator.charAt(i)));
            }
            endIndex = this.endWith(tmp.size() - 1, tmp, this.lineSeparator);
            if (endIndex < 0) {
                throw new IllegalStateException("Unknown error");
            }
            int splitterIdx = this.endWith(endIndex - 1, tmp, this.columnSplitter);
            if (splitterIdx > -1 && this.trailDelimiter) {
                beginIndex = splitterIdx;
            }
        }
        if (this.mark == -1 || this.cache == null) {
            this.index = 0;
            this.cache = new ArrayList<Character>(1024);
        }
        for (i = 0; i < tmp.size(); ++i) {
            if (this.shouldSkip(i, beginIndex, endIndex)) continue;
            this.cache.add((Character)tmp.get(i));
        }
    }

    private boolean shouldSkip(int idx, int beginIndex, int endIndex) {
        if (beginIndex == -1 || endIndex == -1) {
            return false;
        }
        return idx >= beginIndex && idx < endIndex;
    }

    private int endWith(int endIndex, List<Character> targets, String searchStr) {
        if (endIndex >= targets.size()) {
            throw new IllegalArgumentException("Too big end index " + endIndex + " for line length " + targets.size());
        }
        int len = searchStr.length();
        if (endIndex + 1 < len) {
            return -1;
        }
        int j = endIndex;
        int i = len - 1;
        while (i >= 0) {
            if (targets.get(j).charValue() != searchStr.charAt(i)) {
                return -1;
            }
            --i;
            --j;
        }
        if (j >= 0 && targets.get(j) == this.escapeCharacter) {
            return -1;
        }
        return j + 1;
    }
}

