/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.tools.loaddump.parser.record.cut;

import com.google.common.base.Preconditions;
import com.oceanbase.tools.loaddump.common.model.Record;
import com.oceanbase.tools.loaddump.parser.record.AbstractRowOrientedParser;
import com.oceanbase.tools.loaddump.parser.record.ExtendedBufferedReader;
import com.oceanbase.tools.loaddump.utils.ExceptionUtils;
import com.oceanbase.tools.loaddump.utils.StringUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class CutRecordParser
extends AbstractRowOrientedParser {
    private static final Logger log = LoggerFactory.getLogger(CutRecordParser.class);
    private static final String DEFAULT_LINE_SEPARATOR = System.lineSeparator();
    private static final boolean IS_NEWLINE_ON_WINDOWS = DEFAULT_LINE_SEPARATOR.equals("\r\n");
    private int fieldCount = 0;
    private final BufferedReader reader;
    private final String nullString;
    private final String columnSplitter;
    private final boolean trailDelimiter;
    private final boolean withTrim;
    private final String lineSeparator;
    private final Character escapeCharacter;
    private final boolean skipHeader;
    private final boolean skipFooter;
    private final Character firstCharacter;
    private final boolean customLineSeparator;
    private final StringBuilder sb;

    private CutRecordParser(Reader reader, String nullString, String columnSplitter, boolean trailDelimiter, Character escapeCharacter, boolean withTrim, String lineSeparator, boolean skipHeader, boolean skipFooter) {
        this.reader = new ExtendedBufferedReader(reader);
        this.nullString = nullString;
        this.columnSplitter = columnSplitter;
        this.trailDelimiter = trailDelimiter;
        this.escapeCharacter = escapeCharacter;
        this.withTrim = withTrim;
        this.lineSeparator = lineSeparator;
        this.skipHeader = skipHeader;
        this.skipFooter = skipFooter;
        this.firstCharacter = Character.valueOf(lineSeparator.charAt(0));
        this.customLineSeparator = !DEFAULT_LINE_SEPARATOR.equals(lineSeparator);
        this.sb = new StringBuilder(4096);
        this.skipHeader();
    }

    private void skipHeader() {
        if (this.skipHeader) {
            try {
                Record record = this.nextRecord();
                log.info("Skip header: {} finish", record == null ? "<No Header>" : record.getValues());
            }
            catch (IOException e) {
                log.warn("Skip header failed. Error: {}", (Object)ExceptionUtils.getRootCauseMessage(e));
            }
        }
    }

    public static CutRecordParser parse(File file, String charset, String nullString, String columnSplitter, boolean trailDelimiter, Character escapeCharacter) throws IOException {
        return CutRecordParser.parse(file, charset, nullString, columnSplitter, trailDelimiter, escapeCharacter, false, DEFAULT_LINE_SEPARATOR, false, false);
    }

    public static CutRecordParser parse(File file, String charset, String nullString, String columnSplitter, boolean trailDelimiter, Character escapeCharacter, boolean withTrim, String lineSeparator, boolean skipHeader, boolean skipFooter) throws IOException {
        Preconditions.checkArgument((file != null ? 1 : 0) != 0, (Object)"Input file is null");
        Preconditions.checkArgument((charset != null ? 1 : 0) != 0, (Object)"Input charset is null");
        return CutRecordParser.parse(new FileInputStream(file), charset, nullString, columnSplitter, trailDelimiter, escapeCharacter, withTrim, lineSeparator, skipHeader, skipFooter);
    }

    public static CutRecordParser parse(InputStream is, String charset, String nullString, String columnSplitter, boolean trailDelimiter, Character escapeCharacter) throws IOException {
        return CutRecordParser.parse(is, charset, nullString, columnSplitter, trailDelimiter, escapeCharacter, false, DEFAULT_LINE_SEPARATOR, false, false);
    }

    public static CutRecordParser parse(InputStream is, String charset, String nullString, String columnSplitter, boolean trailDelimiter, Character escapeCharacter, boolean withTrim, String lineSeparator, boolean skipHeader, boolean skipFooter) throws IOException {
        Preconditions.checkArgument((is != null ? 1 : 0) != 0, (Object)"Input stream is null");
        Preconditions.checkArgument((charset != null ? 1 : 0) != 0, (Object)"Input charset is null");
        Preconditions.checkArgument((columnSplitter != null ? 1 : 0) != 0, (Object)"Input columnSplitter is null");
        return CutRecordParser.parse(new InputStreamReader(is, charset), nullString, columnSplitter, trailDelimiter, escapeCharacter, withTrim, lineSeparator, skipHeader, skipFooter);
    }

    public static CutRecordParser parse(Path path, String charset, String nullString, String columnSplitter, boolean trailDelimiter, Character escapeCharacter, boolean withTrim, String lineSeparator) throws IOException {
        Preconditions.checkArgument((path != null ? 1 : 0) != 0, (Object)"Input path is null");
        Preconditions.checkArgument((charset != null ? 1 : 0) != 0, (Object)"Input charset is null");
        return CutRecordParser.parse(Files.newInputStream(path, new OpenOption[0]), charset, nullString, columnSplitter, trailDelimiter, escapeCharacter, withTrim, lineSeparator, false, false);
    }

    public static CutRecordParser parse(Reader reader, String nullString, String columnSplitter, boolean trailDelimiter, Character escapeChar) throws IOException {
        return CutRecordParser.parse(reader, nullString, columnSplitter, trailDelimiter, escapeChar, false, DEFAULT_LINE_SEPARATOR, false, false);
    }

    public static CutRecordParser parse(Reader reader, String nullString, String columnSplitter, boolean trailDelimiter, Character escapeChar, boolean withTrim, String lineSeparator, boolean skipHeader, boolean skipFooter) throws IOException {
        Preconditions.checkArgument((reader != null ? 1 : 0) != 0, (Object)"Input reader is null");
        Preconditions.checkArgument((columnSplitter != null ? 1 : 0) != 0, (Object)"Input column splitter is null");
        return new CutRecordParser(reader, nullString, columnSplitter, trailDelimiter, escapeChar, withTrim, lineSeparator, skipHeader, skipFooter);
    }

    public static CutRecordParser parse(String string, String nullString, String columnSplitter, boolean trailDelimiter, Character escapeChar) throws IOException {
        return CutRecordParser.parse(string, nullString, columnSplitter, trailDelimiter, escapeChar, false, DEFAULT_LINE_SEPARATOR);
    }

    public static CutRecordParser parse(String string, String nullString, String columnSplitter, boolean trailDelimiter, Character escapeChar, boolean withTrim, String lineSeparator) throws IOException {
        Preconditions.checkArgument((string != null ? 1 : 0) != 0, (Object)"Input string is null");
        return CutRecordParser.parse(new StringReader(string), nullString, columnSplitter, trailDelimiter, escapeChar, withTrim, lineSeparator, false, false);
    }

    public static CutRecordParser parse(URL url, String charset, String nullString, String columnSplitter, boolean trailDelimiter, Character escapeChar, boolean withTrim, String lineSeparator, boolean skipHeader, boolean skipFooter) throws IOException {
        Preconditions.checkArgument((url != null ? 1 : 0) != 0, (Object)"Input url is null");
        return CutRecordParser.parse(url.openStream(), charset, nullString, columnSplitter, trailDelimiter, escapeChar, withTrim, lineSeparator, skipHeader, skipFooter);
    }

    @Override
    public Record nextRecord() throws IOException {
        String line = this.readLine();
        if (line == null) {
            return null;
        }
        if (StringUtils.isBlank(line)) {
            return new Record(line, new ArrayList(), "Empty line");
        }
        String splitter = this.getColumnSplitter();
        if (this.isTrailDelimiter() && line.endsWith(splitter)) {
            line = line.substring(0, line.length() - splitter.length());
        }
        try {
            List<String> values = this.splitByWholeSeparator(line, splitter);
            if (!this.skipHeader && !this.skipFooter) {
                int valueCount = values.size();
                int n = this.fieldCount = this.fieldCount == 0 ? valueCount : this.fieldCount;
                if (this.fieldCount != valueCount) {
                    log.error("Parse the cut file failed as the field count ({}) is unmatched with previous lines ({}). Line: {}", new Object[]{valueCount, this.fieldCount, line});
                }
            }
            return new Record(values, 1L);
        }
        catch (Exception e) {
            return new Record(line, Arrays.asList(StringUtils.split((String)line, (String)this.columnSplitter)), e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readLine() throws IOException {
        try {
            int dt = -1;
            while ((dt = this.reader.read()) != -1) {
                char ch = (char)dt;
                if (this.firstCharacter.charValue() == ch) {
                    int end;
                    int start;
                    int len = this.lineSeparator.length() - 1;
                    this.reader.mark(len);
                    boolean found = true;
                    for (int i = 1; i <= len; ++i) {
                        char nextChar = (char)this.reader.read();
                        found &= this.lineSeparator.charAt(i) == nextChar;
                    }
                    if (found && (!this.isTrailDelimiter() || (start = (end = this.sb.length()) - this.getColumnSplitter().length()) <= end && this.sb.substring(start, end).equals(this.getColumnSplitter()))) break;
                    this.reader.reset();
                }
                this.sb.append(ch);
            }
            String string = this.sb.length() < 1 && dt == -1 ? null : this.sb.toString();
            return string;
        }
        finally {
            this.sb.setLength(0);
        }
    }

    private List<String> splitByWholeSeparator(String str, String splitter) {
        boolean isEscaped;
        if (str == null) {
            return null;
        }
        if (StringUtils.isEmpty(splitter)) {
            throw new IllegalArgumentException("--column-splitter is null");
        }
        int len = str.length();
        ArrayList<String> substrings = new ArrayList<String>();
        if (len == 0) {
            return substrings;
        }
        int splitterLength = splitter.length();
        boolean bl = isEscaped = this.getEscapeCharacter() != null;
        if (splitterLength > 1) {
            String[] strs = StringUtils.splitByWholeSeparatorPreserveAllTokens((String)str, (String)splitter);
            return Arrays.stream(strs).map(e -> this.unescapeValues((String)e, isEscaped)).collect(Collectors.toList());
        }
        int beg = 0;
        int end = 0;
        while (end < len) {
            end = str.indexOf(splitter, beg);
            while (isEscaped && end > 0 && this.isEscapedChar(str, end - 1)) {
                end = str.indexOf(splitter, end + 1);
            }
            if (end > -1) {
                if (end >= beg) {
                    substrings.add(this.unescapeValues(str.substring(beg, end), isEscaped));
                }
                beg = end + splitterLength;
                continue;
            }
            substrings.add(this.unescapeValues(str.substring(beg), isEscaped));
            end = len;
        }
        return substrings;
    }

    private boolean isEscapedChar(String str, int index) {
        int i;
        if (StringUtils.isEmpty(str)) {
            return false;
        }
        for (i = index; i > -1 && str.charAt(i) == this.escapeCharacter.charValue(); --i) {
        }
        return (index - i & 1) != 0;
    }

    private String unescapeValues(String str, boolean isEscaped) {
        String nullString = this.getNullString();
        if (nullString != null && StringUtils.equals(str, nullString)) {
            return null;
        }
        if (!isEscaped) {
            return str;
        }
        StringBuilder sb = new StringBuilder(str.length());
        int len = str.length();
        boolean isEscapedChar = true;
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            if (c == this.escapeCharacter.charValue() && isEscapedChar) {
                isEscapedChar = false;
                continue;
            }
            sb.append(c);
            isEscapedChar = true;
        }
        return this.isWithTrim() ? sb.toString().trim() : sb.toString();
    }

    @Override
    public void close() throws Exception {
        if (this.reader != null) {
            this.reader.close();
            this.closed = true;
        }
        this.sb.setLength(0);
        super.close();
    }

    public String getNullString() {
        return this.nullString;
    }

    public String getColumnSplitter() {
        return this.columnSplitter;
    }

    public boolean isTrailDelimiter() {
        return this.trailDelimiter;
    }

    public boolean isWithTrim() {
        return this.withTrim;
    }

    public String getLineSeparator() {
        return this.lineSeparator;
    }

    public Character getEscapeCharacter() {
        return this.escapeCharacter;
    }

    public boolean isSkipHeader() {
        return this.skipHeader;
    }

    public boolean isSkipFooter() {
        return this.skipFooter;
    }

    public Character getFirstCharacter() {
        return this.firstCharacter;
    }

    public boolean isCustomLineSeparator() {
        return this.customLineSeparator;
    }
}

